/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.TbStopWatch;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportSettings;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.common.data.sync.ie.EntityImportSettings;
import org.thingsboard.server.common.data.sync.vc.AutoCommitSettings;
import org.thingsboard.server.common.data.sync.vc.BranchInfo;
import org.thingsboard.server.common.data.sync.vc.EntityDataDiff;
import org.thingsboard.server.common.data.sync.vc.EntityDataInfo;
import org.thingsboard.server.common.data.sync.vc.EntityLoadError;
import org.thingsboard.server.common.data.sync.vc.EntityTypeLoadResult;
import org.thingsboard.server.common.data.sync.vc.EntityVersion;
import org.thingsboard.server.common.data.sync.vc.RepositorySettings;
import org.thingsboard.server.common.data.sync.vc.VcUtils;
import org.thingsboard.server.common.data.sync.vc.VersionCreationResult;
import org.thingsboard.server.common.data.sync.vc.VersionLoadResult;
import org.thingsboard.server.common.data.sync.vc.VersionedEntityInfo;
import org.thingsboard.server.common.data.sync.vc.request.create.AutoVersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.ComplexVersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.create.EntityTypeVersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.SingleEntityVersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.create.SyncStrategy;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateConfig;
import org.thingsboard.server.common.data.sync.vc.request.create.VersionCreateRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.EntityTypeVersionLoadConfig;
import org.thingsboard.server.common.data.sync.vc.request.load.EntityTypeVersionLoadRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.SingleEntityVersionLoadRequest;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadConfig;
import org.thingsboard.server.common.data.sync.vc.request.load.VersionLoadRequest;
import org.thingsboard.server.common.data.util.ThrowingRunnable;
import org.thingsboard.server.dao.DaoUtil;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.exception.DeviceCredentialsValidationException;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.owner.OwnerService;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.executors.VersionControlExecutor;
import org.thingsboard.server.service.sync.ie.EntitiesExportImportService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.ie.importing.MissingEntityException;
import org.thingsboard.server.service.sync.vc.DefaultEntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.EntitiesVersionControlService;
import org.thingsboard.server.service.sync.vc.GitVersionControlQueueService;
import org.thingsboard.server.service.sync.vc.LoadEntityException;
import org.thingsboard.server.service.sync.vc.VersionControlTaskCacheEntry;
import org.thingsboard.server.service.sync.vc.autocommit.TbAutoCommitSettingsService;
import org.thingsboard.server.service.sync.vc.data.CommitGitRequest;
import org.thingsboard.server.service.sync.vc.data.ComplexEntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;
import org.thingsboard.server.service.sync.vc.data.EntityTypeExportCtx;
import org.thingsboard.server.service.sync.vc.data.EntityTypeExportTask;
import org.thingsboard.server.service.sync.vc.data.ReimportTask;
import org.thingsboard.server.service.sync.vc.data.SimpleEntitiesExportCtx;
import org.thingsboard.server.service.sync.vc.repository.TbRepositorySettingsService;

@Service
@TbCoreComponent
public class DefaultEntitiesVersionControlService
implements EntitiesVersionControlService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEntitiesVersionControlService.class);
    private final TbRepositorySettingsService repositorySettingsService;
    private final TbAutoCommitSettingsService autoCommitSettingsService;
    private final GitVersionControlQueueService gitServiceQueue;
    private final EntitiesExportImportService exportImportService;
    private final ExportableEntitiesService exportableEntitiesService;
    private final TbLogEntityActionService logEntityActionService;
    private final TransactionTemplate transactionTemplate;
    private final CustomerService customerService;
    private final OwnerService ownersService;
    private final EntityGroupService groupService;
    private final TbTransactionalCache<UUID, VersionControlTaskCacheEntry> taskCache;
    private final VersionControlExecutor executor;
    private static final Set<EntityType> GROUP_ENTITIES = EnumSet.of(EntityType.CUSTOMER, new EntityType[]{EntityType.DEVICE, EntityType.ASSET, EntityType.DASHBOARD, EntityType.ENTITY_VIEW, EntityType.USER});

    public ListenableFuture<UUID> saveEntitiesVersion(User user, VersionCreateRequest request) {
        VcUtils.checkBranchName((String)request.getBranch());
        ListenableFuture pendingCommit = this.gitServiceQueue.prepareCommit(user, request);
        DonAsynchron.withCallback((ListenableFuture)pendingCommit, commit -> {
            this.cachePut(commit.getTxId(), new VersionCreationResult());
            try {
                ListenableFuture resultFuture = Futures.transformAsync((ListenableFuture)Futures.allAsList((Iterable)(switch (1.$SwitchMap$org$thingsboard$server$common$data$sync$vc$request$create$VersionCreateRequestType[request.getType().ordinal()]) {
                    case 1 -> {
                        SimpleEntitiesExportCtx ctx = new SimpleEntitiesExportCtx(user, commit, (SingleEntityVersionCreateRequest)request);
                        this.handleSingleEntityRequest(ctx);
                        yield ctx;
                    }
                    case 2 -> {
                        SimpleEntitiesExportCtx ctx = new ComplexEntitiesExportCtx(user, commit, (ComplexVersionCreateRequest)request);
                        this.handleComplexRequest((ComplexEntitiesExportCtx)ctx);
                        yield ctx;
                    }
                    default -> throw new RuntimeException("Unsupported request type: " + String.valueOf(request.getType()));
                }).getFutures()), f -> this.gitServiceQueue.push(commit), (Executor)this.executor);
                DonAsynchron.withCallback((ListenableFuture)resultFuture, result -> this.cachePut(commit.getTxId(), result), e -> this.processCommitError(user, request, commit, e), (Executor)this.executor);
            }
            catch (Exception e2) {
                this.processCommitError(user, request, commit, (Throwable)e2);
            }
        }, t -> log.debug("[{}] Failed to prepare the commit: {}", new Object[]{user.getId(), request, t}));
        return Futures.transform((ListenableFuture)pendingCommit, CommitGitRequest::getTxId, (Executor)MoreExecutors.directExecutor());
    }

    public VersionCreationResult getVersionCreateStatus(User user, UUID requestId) throws ThingsboardException {
        return (VersionCreationResult)this.getStatus(user, requestId, VersionControlTaskCacheEntry::getExportResult);
    }

    public VersionLoadResult getVersionLoadStatus(User user, UUID requestId) throws ThingsboardException {
        return (VersionLoadResult)this.getStatus(user, requestId, VersionControlTaskCacheEntry::getImportResult);
    }

    private <T> T getStatus(User user, UUID requestId, Function<VersionControlTaskCacheEntry, T> getter) throws ThingsboardException {
        TbCacheValueWrapper cacheEntry = this.taskCache.get((Serializable)requestId);
        if (cacheEntry == null || cacheEntry.get() == null) {
            log.debug("[{}] No cache record: {}", (Object)requestId, (Object)cacheEntry);
            throw new ThingsboardException("Task execution timed-out", ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        VersionControlTaskCacheEntry entry = (VersionControlTaskCacheEntry)cacheEntry.get();
        log.trace("[{}] Cache get: {}", (Object)requestId, (Object)entry);
        T result = getter.apply(entry);
        if (result == null) {
            throw new ThingsboardException("Invalid task", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        return result;
    }

    private void handleSingleEntityRequest(SimpleEntitiesExportCtx ctx) throws Exception {
        EntityId entityId = ((SingleEntityVersionCreateRequest)ctx.getRequest()).getEntityId();
        if (EntityType.ENTITY_GROUP.equals((Object)entityId.getEntityType())) {
            this.exportGroup((EntitiesExportCtx)ctx, new EntityGroupId(entityId.getId()));
        } else {
            EntityExportData entityData = this.exportImportService.exportEntity((EntitiesExportCtx)ctx, entityId);
            ExportableEntity entity = entityData.getEntity();
            if (entity instanceof HasOwnerId) {
                List hierarchy = this.addCustomerHierarchyToCommit((EntitiesExportCtx)ctx, entityId, (HasOwnerId)entity);
                ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), hierarchy, entityData));
            } else {
                ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), entityData));
            }
        }
    }

    private void handleComplexRequest(ComplexEntitiesExportCtx parentCtx) throws Exception {
        ComplexVersionCreateRequest request = (ComplexVersionCreateRequest)parentCtx.getRequest();
        request.getEntityTypes().forEach((entityType, config) -> {
            EntityTypeExportCtx ctx = new EntityTypeExportCtx((EntitiesExportCtx)parentCtx, config, request.getSyncStrategy(), entityType);
            if (ctx.isOverwrite()) {
                ctx.add(this.gitServiceQueue.deleteAll(ctx.getCommit(), entityType));
            }
            if (GROUP_ENTITIES.contains(entityType)) {
                if (config.isAllEntities()) {
                    EntityTypeExportTask task;
                    ctx.addTask(new EntityTypeExportTask(Collections.emptyList(), (EntityId)ctx.getUser().getTenantId()));
                    while ((task = ctx.pollTask()) != null) {
                        this.exportGroupEntities(ctx, task);
                    }
                } else {
                    for (UUID groupId : config.getEntityIds()) {
                        this.exportGroup((EntitiesExportCtx)ctx, new EntityGroupId(groupId));
                    }
                }
            } else if (config.isAllEntities()) {
                DaoUtil.processInBatches(pageLink -> this.exportableEntitiesService.findEntitiesIdsByTenantId(ctx.getTenantId(), entityType, pageLink), (int)100, entityId -> this.saveEntityData((EntitiesExportCtx)ctx, entityId));
            } else {
                for (UUID entityId2 : config.getEntityIds()) {
                    this.saveEntityData((EntitiesExportCtx)ctx, EntityIdFactory.getByTypeAndUuid((EntityType)entityType, (UUID)entityId2));
                }
            }
        });
    }

    private void exportGroup(EntitiesExportCtx<?> ctx, EntityGroupId entityId) {
        EntityExportData entityData = this.exportImportService.exportEntity(ctx, (EntityId)entityId);
        EntityGroup group = (EntityGroup)entityData.getEntity();
        List hierarchy = this.addCustomerHierarchyToCommit(ctx, (EntityId)entityId, (HasOwnerId)group);
        ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), hierarchy, entityData));
        if (ctx.getSettings().isExportGroupEntities() && ctx.shouldExportEntities(group.getType())) {
            PageDataIterable entityIdsIterator = new PageDataIterable(link -> this.groupService.findEntityIds(ctx.getTenantId(), group.getType(), entityId, link), 1024);
            ArrayList<EntityId> groupEntityIds = new ArrayList<EntityId>();
            for (EntityId groupEntityId : entityIdsIterator) {
                if (!group.isGroupAll()) {
                    groupEntityIds.add(Optional.ofNullable(this.exportableEntitiesService.getExternalIdByInternal(groupEntityId)).orElse(groupEntityId));
                }
                if (!ctx.isExportRelatedEntities()) continue;
                EntityExportData groupEntityData = this.exportImportService.exportEntity(ctx, groupEntityId);
                ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), hierarchy, groupEntityData));
            }
            if (!group.isGroupAll()) {
                ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), hierarchy, group.getType(), entityData.getExternalId(), groupEntityIds));
            }
        }
    }

    private List<CustomerId> addCustomerHierarchyToCommit(EntitiesExportCtx<?> ctx, EntityId entityId, HasOwnerId entity) throws ThingsboardException {
        Map customerIds = this.getOrderedCustomerIdsMap(ctx.getTenantId(), entityId, entity);
        ArrayList<CustomerId> hierarchy = new ArrayList<CustomerId>(customerIds.size());
        for (Map.Entry idPair : customerIds.entrySet()) {
            CustomerId internalId = (CustomerId)idPair.getKey();
            CustomerId externalId = (CustomerId)idPair.getValue();
            if (ctx.isExportRelatedCustomers()) {
                EntityExportData ownerData = this.exportImportService.exportEntity(ctx, (EntityId)internalId);
                ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), new ArrayList<CustomerId>(hierarchy), ownerData));
            }
            hierarchy.add(externalId);
        }
        return hierarchy;
    }

    private void exportGroupEntities(EntityTypeExportCtx ctx, EntityTypeExportTask task) {
        CustomerId customerId;
        ArrayList<CustomerId> parents = new ArrayList<CustomerId>(task.getParents());
        CustomerId customerId2 = customerId = EntityType.CUSTOMER.equals((Object)task.getOwnerId().getEntityType()) ? new CustomerId(task.getOwnerId().getId()) : null;
        if (customerId != null) {
            CustomerId externalCustomerId = (CustomerId)ctx.getExternalId((EntityId)customerId);
            if (externalCustomerId == null) {
                Customer customer = this.customerService.findCustomerById(ctx.getTenantId(), customerId);
                externalCustomerId = customer.getExternalId() != null ? customer.getExternalId() : customerId;
                ctx.putExternalId((EntityId)customerId, (EntityId)externalCustomerId);
            }
            parents.add(externalCustomerId);
        }
        if (ctx.shouldExportEntities(ctx.getEntityType())) {
            DaoUtil.processInBatches(pageLink -> this.exportableEntitiesService.findEntityIdsByTenantIdAndCustomerId(ctx.getTenantId(), (EntityId)customerId, ctx.getEntityType(), pageLink), (int)1024, entityId -> {
                try {
                    EntityExportData entityData = this.exportImportService.exportEntity((EntitiesExportCtx)ctx, entityId);
                    ctx.getFutures().add(this.gitServiceQueue.addToCommit(ctx.getCommit(), parents, entityData));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        DaoUtil.processInBatches(pageLink -> this.groupService.findEntityGroupsByType(ctx.getTenantId(), task.getOwnerId(), ctx.getEntityType(), pageLink), (int)1024, group -> {
            try {
                EntityExportData entityData = this.exportImportService.exportEntity((EntitiesExportCtx)ctx, (EntityId)group.getId());
                ctx.getFutures().add(this.gitServiceQueue.addToCommit(ctx.getCommit(), parents, entityData));
                if (!group.isGroupAll() && ctx.shouldExportEntities(ctx.getEntityType())) {
                    PageDataIterable entityIdsIterator = new PageDataIterable(link -> this.groupService.findEntityIds(ctx.getTenantId(), group.getType(), group.getId(), link), 1024);
                    ArrayList<EntityId> groupEntityIds = new ArrayList<EntityId>();
                    for (EntityId groupEntityId : entityIdsIterator) {
                        EntityId entityExternalId = ctx.getExternalId(groupEntityId);
                        if (entityExternalId == null) continue;
                        groupEntityIds.add(entityExternalId);
                    }
                    ctx.getFutures().add(this.gitServiceQueue.addToCommit(ctx.getCommit(), parents, group.getType(), entityData.getExternalId(), groupEntityIds));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        DaoUtil.processInBatches(pageLink -> this.exportableEntitiesService.findEntityIdsByTenantIdAndCustomerId(ctx.getTenantId(), (EntityId)customerId, EntityType.CUSTOMER, pageLink), (int)1024, cId -> ctx.addTask(new EntityTypeExportTask(parents, cId)));
    }

    private void saveEntityData(EntitiesExportCtx<?> ctx, EntityId entityId) {
        EntityExportData entityData = this.exportImportService.exportEntity(ctx, entityId);
        ctx.add(this.gitServiceQueue.addToCommit(ctx.getCommit(), entityData));
    }

    public ListenableFuture<PageData<EntityVersion>> listEntityVersions(TenantId tenantId, String branch, EntityId externalId, EntityId internalId, PageLink pageLink) throws Exception {
        if (internalId == null) {
            internalId = externalId;
        }
        List customerExternalIds = this.getCustomerExternalIds(tenantId, internalId);
        if (EntityType.ENTITY_GROUP.equals((Object)internalId.getEntityType())) {
            HasId entity = this.findExportableEntityInDb(tenantId, internalId);
            return this.gitServiceQueue.listVersions(tenantId, branch, customerExternalIds, ((EntityGroup)entity).getType(), externalId, pageLink);
        }
        return this.gitServiceQueue.listVersions(tenantId, branch, customerExternalIds, externalId, pageLink);
    }

    public ListenableFuture<PageData<EntityVersion>> listEntityTypeVersions(TenantId tenantId, String branch, EntityType entityType, PageLink pageLink) throws Exception {
        return this.gitServiceQueue.listVersions(tenantId, branch, entityType, pageLink);
    }

    public ListenableFuture<PageData<EntityVersion>> listVersions(TenantId tenantId, String branch, PageLink pageLink) throws Exception {
        return this.gitServiceQueue.listVersions(tenantId, branch, pageLink);
    }

    public ListenableFuture<List<VersionedEntityInfo>> listEntitiesAtVersion(TenantId tenantId, String versionId, EntityType entityType) throws Exception {
        return this.gitServiceQueue.listEntitiesAtVersion(tenantId, versionId, entityType);
    }

    public ListenableFuture<List<VersionedEntityInfo>> listAllEntitiesAtVersion(TenantId tenantId, String versionId) throws Exception {
        return this.gitServiceQueue.listEntitiesAtVersion(tenantId, versionId);
    }

    public UUID loadEntitiesVersion(User user, VersionLoadRequest request) throws Exception {
        EntitiesImportCtx ctx = new EntitiesImportCtx(UUID.randomUUID(), user, request.getVersionId());
        this.cachePut(ctx.getRequestId(), VersionLoadResult.empty());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$sync$vc$request$load$VersionLoadRequestType[request.getType().ordinal()]) {
            case 1: {
                SingleEntityVersionLoadRequest versionLoadRequest = (SingleEntityVersionLoadRequest)request;
                ctx.setRollbackOnError(true);
                this.executor.submit(() -> this.load(ctx, request, c -> this.loadSingleEntity(c, versionLoadRequest)));
                break;
            }
            case 2: {
                EntityTypeVersionLoadRequest versionLoadRequest = (EntityTypeVersionLoadRequest)request;
                ctx.setRollbackOnError(versionLoadRequest.isRollbackOnError());
                this.executor.submit(() -> this.load(ctx, request, c -> this.loadMultipleEntities(c, versionLoadRequest)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported version load request");
            }
        }
        return ctx.getRequestId();
    }

    private <R> VersionLoadResult load(EntitiesImportCtx ctx, VersionLoadRequest request, Function<EntitiesImportCtx, VersionLoadResult> loadFunction) {
        try {
            VersionLoadResult result;
            if (ctx.isRollbackOnError()) {
                result = (VersionLoadResult)this.transactionTemplate.execute(status -> {
                    try {
                        return (VersionLoadResult)loadFunction.apply(ctx);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                for (ThrowingRunnable eventCallback : ctx.getEventCallbacks()) {
                    eventCallback.run();
                }
            } else {
                result = loadFunction.apply(ctx);
            }
            result.setDone(true);
            return this.cachePut(ctx.getRequestId(), result);
        }
        catch (LoadEntityException e) {
            return this.cachePut(ctx.getRequestId(), this.onError(e.getExternalId(), e.getCause()));
        }
        catch (Throwable e) {
            log.info("[{}] Failed to process request [{}] due to: ", new Object[]{ctx.getTenantId(), request, e});
            return this.cachePut(ctx.getRequestId(), VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e)));
        }
    }

    private VersionLoadResult loadSingleEntity(EntitiesImportCtx ctx, SingleEntityVersionLoadRequest request) {
        EntityId internalId = request.getInternalEntityId();
        List ownerIds = internalId != null ? this.getCustomerExternalIds(ctx.getTenantId(), internalId) : Collections.emptyList();
        VersionLoadConfig config = request.getConfig();
        EntityImportSettings settings = EntityImportSettings.builder().updateRelations(config.isLoadRelations()).saveAttributes(config.isLoadAttributes()).saveCredentials(config.isLoadCredentials()).saveCalculatedFields(config.isLoadCalculatedFields()).saveUserGroupPermissions(config.isLoadPermissions()).autoGenerateIntegrationKey(config.isAutoGenerateIntegrationKey()).findExistingByName(false).build();
        ctx.setFinalImportAttempt(true);
        ctx.setSettings(settings);
        if (EntityType.ENTITY_GROUP.equals((Object)request.getExternalEntityId().getEntityType())) {
            HasId entity = this.findExportableEntityInDb(ctx.getTenantId(), internalId != null ? internalId : request.getExternalEntityId());
            EntityExportData groupData = (EntityExportData)this.gitServiceQueue.getEntityGroup(ctx.getTenantId(), request.getVersionId(), ownerIds, ((EntityGroup)entity).getType(), request.getExternalEntityId()).get();
            EntityImportResult importResult = this.exportImportService.importEntity(ctx, groupData);
            EntityGroup savedGroup = (EntityGroup)importResult.getSavedEntity();
            if (config.isLoadGroupEntities() && ctx.shouldImportEntities(savedGroup.getType())) {
                if (savedGroup.isGroupAll()) {
                    this.importEntities(ctx, ownerIds, savedGroup.getType(), false);
                } else {
                    this.importGroupEntities(ctx, ownerIds, savedGroup.getType(), savedGroup.getId(), groupData.getExternalId());
                }
                this.reimport(ctx);
            }
            this.exportImportService.saveReferencesAndRelations(ctx);
            return VersionLoadResult.success((EntityTypeLoadResult)EntityTypeLoadResult.builder().entityType(importResult.getEntityType()).created(importResult.getOldEntity() == null ? 1 : 0).updated(importResult.getOldEntity() != null ? 1 : 0).deleted(0).build());
        }
        EntityExportData entityData = (EntityExportData)this.gitServiceQueue.getEntity(ctx.getTenantId(), ctx.getVersionId(), ownerIds, request.getExternalEntityId()).get();
        try {
            EntityImportResult importResult = this.exportImportService.importEntity(ctx, entityData);
            this.exportImportService.saveReferencesAndRelations(ctx);
            return VersionLoadResult.success((EntityTypeLoadResult)EntityTypeLoadResult.builder().entityType(importResult.getEntityType()).created(importResult.getOldEntity() == null ? 1 : 0).updated(importResult.getOldEntity() != null ? 1 : 0).deleted(0).build());
        }
        catch (Exception e) {
            throw new LoadEntityException(entityData.getExternalId(), (Throwable)e);
        }
    }

    private List<CustomerId> getCustomerExternalIds(TenantId tenantId, EntityId entityId) {
        return this.getCustomerExternalIds(tenantId, entityId, null);
    }

    private List<CustomerId> getCustomerExternalIds(TenantId tenantId, EntityId entityId, HasOwnerId entity) {
        Map map = this.getOrderedCustomerIdsMap(tenantId, entityId, entity);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<CustomerId>(map.values());
    }

    private Map<CustomerId, CustomerId> getOrderedCustomerIdsMap(TenantId tenantId, EntityId entityId, HasOwnerId entity) {
        Set ownersSet = entity != null ? this.ownersService.getOwners(tenantId, entityId, entity) : this.ownersService.getOwners(tenantId, entityId);
        ArrayList owners = new ArrayList(ownersSet);
        if (owners.size() == 1) {
            return Collections.emptyMap();
        }
        Collections.reverse(owners);
        LinkedHashMap<CustomerId, CustomerId> result = new LinkedHashMap<CustomerId, CustomerId>(Math.max(1, owners.size() - 1));
        for (EntityId ownerId : owners) {
            if (EntityType.TENANT.equals((Object)ownerId.getEntityType())) continue;
            CustomerId internalId = new CustomerId(ownerId.getId());
            Customer customer = this.customerService.findCustomerById(tenantId, internalId);
            if (customer == null) {
                throw new RuntimeException("Failed to fetch customer with id: " + String.valueOf(internalId));
            }
            result.put(internalId, customer.getExternalId() != null ? customer.getExternalId() : internalId);
        }
        return result;
    }

    private VersionLoadResult loadMultipleEntities(EntitiesImportCtx ctx, EntityTypeVersionLoadRequest request) {
        TbStopWatch sw = TbStopWatch.create((String)"before");
        List entityTypes = request.getEntityTypes().keySet().stream().sorted(this.exportImportService.getEntityTypeComparatorForImport()).toList();
        for (EntityType entityType2 : entityTypes) {
            log.debug("[{}] LOADING {} entities", (Object)ctx.getTenantId(), (Object)entityType2);
            sw.startNew("Entities " + entityType2.name());
            ctx.setSettings(this.getEntityImportSettings(request, entityType2));
            this.importEntities(ctx, Collections.emptyList(), entityType2, true);
        }
        for (EntityType groupType : GROUP_ENTITIES) {
            if (!entityTypes.contains(groupType)) continue;
            log.debug("[{}] Loading {} groups", (Object)ctx.getTenantId(), (Object)groupType);
            sw.startNew("Groups " + groupType.name());
            ctx.setSettings(this.getEntityImportSettings(request, groupType));
            this.importEntityGroups(ctx, groupType);
            this.persistToCache(ctx);
        }
        sw.startNew("Reimport");
        this.reimport(ctx);
        this.persistToCache(ctx);
        sw.startNew("Remove Others");
        request.getEntityTypes().keySet().stream().filter(entityType -> ((EntityTypeVersionLoadConfig)request.getEntityTypes().get(entityType)).isRemoveOtherEntities()).sorted(this.exportImportService.getEntityTypeComparatorForImport().reversed()).forEach(entityType -> this.removeOtherEntities(ctx, entityType));
        sw.startNew("References and Relations");
        this.exportImportService.saveReferencesAndRelations(ctx);
        sw.stop();
        for (StopWatch.TaskInfo task : sw.getTaskInfo()) {
            log.debug("[{}] Executed: {} in {}ms", new Object[]{ctx.getTenantId(), task.getTaskName(), task.getTimeMillis()});
        }
        log.debug("[{}] Total import time: {}ms", (Object)ctx.getTenantId(), (Object)sw.getTotalTimeMillis());
        return VersionLoadResult.success(new ArrayList(ctx.getResults().values()));
    }

    private EntityImportSettings getEntityImportSettings(EntityTypeVersionLoadRequest request, EntityType entityType) {
        EntityTypeVersionLoadConfig config = (EntityTypeVersionLoadConfig)request.getEntityTypes().get(entityType);
        return EntityImportSettings.builder().updateRelations(config.isLoadRelations()).saveAttributes(config.isLoadAttributes()).saveCredentials(config.isLoadCredentials()).saveCalculatedFields(config.isLoadCalculatedFields()).saveUserGroupPermissions(config.isLoadPermissions()).findExistingByName(config.isFindExistingEntityByName()).autoGenerateIntegrationKey(config.isAutoGenerateIntegrationKey()).build();
    }

    private void importGroupEntities(EntitiesImportCtx ctx, List<CustomerId> ownerIds, EntityType entityType, EntityGroupId internalGroupId, EntityId externalGroupId) {
        List allGroupEntityIds = (List)this.gitServiceQueue.getGroupEntityIds(ctx.getTenantId(), ctx.getVersionId(), ownerIds, entityType, externalGroupId).get();
        for (List entityIds : Lists.partition(allGroupEntityIds.stream().map(EntityId::getId).collect(Collectors.toList()), (int)100)) {
            List entityDataList;
            try {
                entityDataList = (List)this.gitServiceQueue.getEntities(ctx.getTenantId(), ctx.getVersionId(), ownerIds, entityType, entityIds).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            List result = this.importEntityDataList(ctx, entityType, entityDataList);
            ArrayList internalIds = result.stream().map(EntityImportResult::getSavedEntity).map(HasId::getId).collect(Collectors.toCollection(ArrayList::new));
            this.groupService.addEntitiesToEntityGroup(ctx.getTenantId(), internalGroupId, (List)internalIds);
        }
    }

    private void importEntities(EntitiesImportCtx ctx, List<CustomerId> ownerIds, EntityType entityType, boolean recursive) {
        List entityDataList;
        int limit = 100;
        int offset = 0;
        do {
            long ts = System.currentTimeMillis();
            try {
                entityDataList = (List)this.gitServiceQueue.getEntities(ctx.getTenantId(), ctx.getVersionId(), ownerIds, entityType, false, recursive, offset, limit).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            long getEntities = System.currentTimeMillis() - ts;
            this.importEntityDataList(ctx, entityType, entityDataList);
            long importEntities = System.currentTimeMillis() - ts;
            log.info("[{}][{}] Import: get -> {}, import -> {}", new Object[]{entityType, entityDataList.size(), getEntities, importEntities});
            offset += limit;
        } while (entityDataList.size() == limit);
    }

    private void importEntityGroups(EntitiesImportCtx ctx, EntityType entityType) {
        List entityDataList;
        int limit = 100;
        int offset = 0;
        HashMap<EntityId, List> ownersCache = new HashMap<EntityId, List>();
        do {
            try {
                entityDataList = (List)this.gitServiceQueue.getEntities(ctx.getTenantId(), ctx.getVersionId(), Collections.emptyList(), entityType, true, true, offset, limit).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            List entityGroupResults = this.importEntityDataList(ctx, entityType, entityDataList);
            for (EntityImportResult entityImportResult : entityGroupResults) {
                EntityGroup savedGroup = (EntityGroup)entityImportResult.getSavedEntity();
                if (savedGroup.isGroupAll() || !ctx.shouldImportEntities(savedGroup.getType())) continue;
                List ownerIds = (List)ownersCache.get(savedGroup.getOwnerId());
                if (ownerIds == null) {
                    ownerIds = this.getCustomerExternalIds(ctx.getTenantId(), (EntityId)savedGroup.getId(), (HasOwnerId)savedGroup);
                    ownersCache.put(savedGroup.getOwnerId(), ownerIds);
                }
                List allGroupEntityIds = (List)this.gitServiceQueue.getGroupEntityIds(ctx.getTenantId(), ctx.getVersionId(), ownerIds, entityType, (EntityId)savedGroup.getExternalId()).get();
                this.createGroupRelations(ctx, savedGroup.getId(), allGroupEntityIds);
            }
            offset += limit;
        } while (entityDataList.size() == limit);
    }

    private List<EntityImportResult<?>> importEntityDataList(EntitiesImportCtx ctx, EntityType entityType, List<EntityExportData> entityDataList) {
        log.debug("[{}] Loading {} entities pack ({})", new Object[]{ctx.getTenantId(), entityType, entityDataList.size()});
        ArrayList importResults = new ArrayList();
        for (EntityExportData entityData : entityDataList) {
            EntityImportResult importResult;
            EntityExportData reimportBackup = (EntityExportData)JacksonUtil.clone((Object)entityData);
            log.debug("[{}] Loading {} entities", (Object)ctx.getTenantId(), (Object)entityType);
            try {
                importResult = this.exportImportService.importEntity(ctx, entityData);
                importResults.add(importResult);
            }
            catch (Exception e) {
                throw new LoadEntityException(entityData.getExternalId(), (Throwable)e);
            }
            this.registerResult(ctx, entityType, importResult, entityData);
            if (!importResult.isUpdatedAllExternalIds()) {
                ctx.getToReimport().put(entityData.getEntity().getExternalId(), new ReimportTask(reimportBackup, ctx.getSettings()));
                continue;
            }
            EntityId savedEntityId = (EntityId)importResult.getSavedEntity().getId();
            ctx.getImportedEntities().computeIfAbsent(entityType, t -> new HashSet()).add(savedEntityId);
        }
        this.persistToCache(ctx);
        log.debug("Imported {} pack ({}) for tenant {}", new Object[]{entityType, entityDataList.size(), ctx.getTenantId()});
        return importResults;
    }

    private void createGroupRelations(EntitiesImportCtx ctx, EntityGroupId groupId, List<EntityId> externalIds) {
        ArrayList<EntityId> internalIds = new ArrayList<EntityId>(externalIds.size());
        for (EntityId externalId : externalIds) {
            EntityId internalId = ctx.getInternalId(externalId);
            if (internalId == null) {
                internalId = Optional.ofNullable(this.exportableEntitiesService.findEntityByTenantIdAndExternalId(ctx.getTenantId(), externalId)).or(() -> Optional.ofNullable(this.exportableEntitiesService.findEntityByTenantIdAndId(ctx.getTenantId(), externalId))).map(HasId::getId).orElseThrow(() -> new LoadEntityException((EntityId)groupId, (Throwable)new MissingEntityException(externalId)));
            }
            ctx.putInternalId(externalId, internalId);
            internalIds.add(internalId);
        }
        this.groupService.addEntitiesToEntityGroup(ctx.getTenantId(), groupId, internalIds);
    }

    private void reimport(EntitiesImportCtx ctx) {
        ctx.setFinalImportAttempt(true);
        ctx.getToReimport().forEach((externalId, task) -> {
            try {
                EntityExportData entityData = task.getData();
                EntityImportSettings settings = task.getSettings();
                ctx.setSettings(settings);
                EntityImportResult importResult = this.exportImportService.importEntity(ctx, entityData);
                EntityId savedEntityId = (EntityId)importResult.getSavedEntity().getId();
                ctx.getImportedEntities().computeIfAbsent(externalId.getEntityType(), t -> new HashSet()).add(savedEntityId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void removeOtherEntities(EntitiesImportCtx ctx, EntityType entityType) {
        PageDataIterable entities = new PageDataIterable(link -> this.exportableEntitiesService.findEntitiesIdsByTenantId(ctx.getTenantId(), entityType, link), 100);
        LinkedHashSet<Object> toRemove = new LinkedHashSet<Object>();
        for (EntityId entityId : entities) {
            if (ctx.getImportedEntities().get(entityType) != null && ((Set)ctx.getImportedEntities().get(entityType)).contains(entityId)) continue;
            toRemove.add(entityId);
        }
        PageDataIterable entityGroups = new PageDataIterable(link -> this.groupService.findEntityGroupsByType(ctx.getTenantId(), entityType, link), 100);
        for (EntityGroup entityGroup : entityGroups) {
            if (entityGroup.isGroupAll() || ctx.getImportedEntities().get(entityType) != null && ((Set)ctx.getImportedEntities().get(entityType)).contains(entityGroup.getId())) continue;
            toRemove.add(entityGroup.getId());
        }
        for (EntityId entityId : toRemove) {
            ExportableEntity entity = (ExportableEntity)this.exportableEntitiesService.findEntityById(entityId);
            this.exportableEntitiesService.removeById(ctx.getTenantId(), entityId);
            ThrowingRunnable callback = () -> this.logEntityActionService.logEntityAction(ctx.getTenantId(), (EntityId)entity.getId(), (HasName)entity, null, ActionType.DELETED, ctx.getUser(), new Object[0]);
            if (ctx.isRollbackOnError()) {
                ctx.addEventCallback(callback);
            } else {
                try {
                    callback.run();
                }
                catch (ThingsboardException e) {
                    throw new RuntimeException(e);
                }
            }
            ctx.registerDeleted(entityType, entityId.getEntityType() == EntityType.ENTITY_GROUP);
        }
        this.persistToCache(ctx);
    }

    private VersionLoadResult onError(EntityId externalId, Throwable e) {
        return this.analyze(e, externalId).orElse(VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e, (EntityId)externalId)));
    }

    private Optional<VersionLoadResult> analyze(Throwable e, EntityId externalId) {
        DataValidationException dve;
        if (e == null) {
            return Optional.empty();
        }
        if (e instanceof DeviceCredentialsValidationException) {
            return Optional.of(VersionLoadResult.error((EntityLoadError)EntityLoadError.credentialsError((EntityId)externalId)));
        }
        if (e instanceof MissingEntityException) {
            return Optional.of(VersionLoadResult.error((EntityLoadError)EntityLoadError.referenceEntityError((EntityId)externalId, (EntityId)((MissingEntityException)e).getEntityId())));
        }
        if (e instanceof DataValidationException && (dve = (DataValidationException)e).getMessage().equals("Integration with such routing key already exists!")) {
            return Optional.of(VersionLoadResult.error((EntityLoadError)EntityLoadError.routingKeyError((EntityId)externalId)));
        }
        return this.analyze(e.getCause(), externalId);
    }

    public ListenableFuture<EntityDataDiff> compareEntityDataToVersion(User user, EntityId entityId, String versionId) {
        HasId entity = this.findExportableEntityInDb(user.getTenantId(), entityId);
        EntityId externalId = ((ExportableEntity)entity).getExternalId();
        if (externalId == null) {
            externalId = entityId;
        }
        List customerIds = this.getCustomerExternalIds(user.getTenantId(), entityId);
        ListenableFuture future = EntityType.ENTITY_GROUP.equals((Object)((EntityId)entity.getId()).getEntityType()) ? this.gitServiceQueue.getEntityGroup(user.getTenantId(), versionId, customerIds, ((EntityGroup)entity).getType(), externalId) : this.gitServiceQueue.getEntity(user.getTenantId(), versionId, customerIds, externalId);
        return Futures.transform((ListenableFuture)future, otherVersion -> {
            EntityExportData currentVersion;
            SimpleEntitiesExportCtx ctx = new SimpleEntitiesExportCtx(user, null, null, EntityExportSettings.builder().exportRelations(otherVersion.hasRelations()).exportAttributes(otherVersion.hasAttributes()).exportCredentials(otherVersion.hasCredentials()).exportCalculatedFields(otherVersion.hasCalculatedFields()).exportPermissions(otherVersion.hasPermissions()).exportGroupEntities(otherVersion.hasGroupEntities()).build());
            try {
                currentVersion = this.exportImportService.exportEntity((EntitiesExportCtx)ctx, entityId);
            }
            catch (ThingsboardException e) {
                throw new RuntimeException(e);
            }
            return new EntityDataDiff(currentVersion.sort(), otherVersion.sort());
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<EntityDataInfo> getEntityDataInfo(User user, EntityId externalId, EntityId internalId, String versionId) {
        ListenableFuture future;
        List customerIds;
        List list = customerIds = internalId != null ? this.getCustomerExternalIds(user.getTenantId(), internalId) : Collections.emptyList();
        if (EntityType.ENTITY_GROUP.equals((Object)externalId.getEntityType())) {
            HasId entity2 = this.findExportableEntityInDb(user.getTenantId(), internalId != null ? internalId : externalId);
            future = this.gitServiceQueue.getEntityGroup(user.getTenantId(), versionId, customerIds, ((EntityGroup)entity2).getType(), externalId);
        } else {
            future = this.gitServiceQueue.getEntity(user.getTenantId(), versionId, customerIds, externalId);
        }
        return Futures.transform((ListenableFuture)future, entity -> new EntityDataInfo(entity.hasRelations(), entity.hasAttributes(), entity.hasCredentials(), entity.hasCalculatedFields(), entity.hasPermissions(), entity.hasGroupEntities()), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<BranchInfo>> listBranches(TenantId tenantId) {
        return this.gitServiceQueue.listBranches(tenantId);
    }

    public RepositorySettings getVersionControlSettings(TenantId tenantId) {
        return this.repositorySettingsService.get(tenantId);
    }

    public ListenableFuture<RepositorySettings> saveVersionControlSettings(TenantId tenantId, RepositorySettings versionControlSettings) {
        VcUtils.checkBranchName((String)versionControlSettings.getDefaultBranch());
        RepositorySettings restoredSettings = this.repositorySettingsService.restore(tenantId, versionControlSettings);
        try {
            ListenableFuture future = this.gitServiceQueue.initRepository(tenantId, restoredSettings);
            return Futures.transform((ListenableFuture)future, f -> this.repositorySettingsService.save(tenantId, restoredSettings), (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            log.debug("{} Failed to init repository: {}", new Object[]{tenantId, versionControlSettings, e});
            throw new RuntimeException("Failed to init repository!", e);
        }
    }

    public ListenableFuture<Void> deleteVersionControlSettings(TenantId tenantId) {
        log.debug("[{}] Deleting version control settings", (Object)tenantId);
        this.repositorySettingsService.delete(tenantId);
        return this.gitServiceQueue.clearRepository(tenantId);
    }

    public ListenableFuture<Void> checkVersionControlAccess(TenantId tenantId, RepositorySettings settings) throws ThingsboardException {
        VcUtils.checkBranchName((String)settings.getDefaultBranch());
        settings = this.repositorySettingsService.restore(tenantId, settings);
        try {
            return this.gitServiceQueue.testRepository(tenantId, settings);
        }
        catch (Exception e) {
            throw new ThingsboardException(String.format("Unable to access repository: %s", this.getCauseMessage(e)), ThingsboardErrorCode.GENERAL);
        }
    }

    public ListenableFuture<UUID> autoCommit(User user, EntityId entityId) {
        RepositorySettings repositorySettings = this.repositorySettingsService.get(user.getTenantId());
        if (repositorySettings == null || repositorySettings.isReadOnly()) {
            return Futures.immediateFuture(null);
        }
        AutoCommitSettings autoCommitSettings = this.autoCommitSettingsService.get(user.getTenantId());
        if (autoCommitSettings == null) {
            return Futures.immediateFuture(null);
        }
        EntityType entityType = entityId.getEntityType();
        AutoVersionCreateConfig autoCommitConfig = (AutoVersionCreateConfig)autoCommitSettings.get((Object)entityType);
        if (autoCommitConfig == null) {
            return Futures.immediateFuture(null);
        }
        SingleEntityVersionCreateRequest vcr = new SingleEntityVersionCreateRequest();
        String autoCommitBranchName = autoCommitConfig.getBranch();
        if (StringUtils.isEmpty((CharSequence)autoCommitBranchName)) {
            autoCommitBranchName = StringUtils.isNotEmpty((CharSequence)repositorySettings.getDefaultBranch()) ? repositorySettings.getDefaultBranch() : "auto-commits";
        }
        vcr.setBranch(autoCommitBranchName);
        vcr.setVersionName("auto-commit at " + String.valueOf(Instant.ofEpochSecond(System.currentTimeMillis() / 1000L)));
        vcr.setEntityId(entityId);
        vcr.setConfig((VersionCreateConfig)autoCommitConfig);
        return this.saveEntitiesVersion(user, (VersionCreateRequest)vcr);
    }

    public ListenableFuture<UUID> autoCommit(User user, EntityType entityType, EntityGroupId groupId) throws Exception {
        RepositorySettings repositorySettings = this.repositorySettingsService.get(user.getTenantId());
        if (repositorySettings == null || repositorySettings.isReadOnly()) {
            return Futures.immediateFuture(null);
        }
        AutoCommitSettings autoCommitSettings = this.autoCommitSettingsService.get(user.getTenantId());
        if (autoCommitSettings == null) {
            return Futures.immediateFuture(null);
        }
        AutoVersionCreateConfig autoCommitConfig = (AutoVersionCreateConfig)autoCommitSettings.get((Object)entityType);
        if (autoCommitConfig == null) {
            return Futures.immediateFuture(null);
        }
        AutoVersionCreateConfig groupConfig = autoCommitConfig.copy();
        groupConfig.setSaveGroupEntities(false);
        SingleEntityVersionCreateRequest vcr = new SingleEntityVersionCreateRequest();
        String autoCommitBranchName = groupConfig.getBranch();
        if (StringUtils.isEmpty((CharSequence)autoCommitBranchName)) {
            autoCommitBranchName = StringUtils.isNotEmpty((CharSequence)repositorySettings.getDefaultBranch()) ? repositorySettings.getDefaultBranch() : "auto-commits";
        }
        vcr.setBranch(autoCommitBranchName);
        vcr.setVersionName("auto-commit at " + String.valueOf(Instant.ofEpochSecond(System.currentTimeMillis() / 1000L)));
        vcr.setEntityId((EntityId)groupId);
        vcr.setConfig((VersionCreateConfig)groupConfig);
        return this.saveEntitiesVersion(user, (VersionCreateRequest)vcr);
    }

    public ListenableFuture<UUID> autoCommit(User user, EntityType entityType, List<UUID> entityIds) {
        RepositorySettings repositorySettings = this.repositorySettingsService.get(user.getTenantId());
        if (repositorySettings == null || repositorySettings.isReadOnly()) {
            return Futures.immediateFuture(null);
        }
        AutoCommitSettings autoCommitSettings = this.autoCommitSettingsService.get(user.getTenantId());
        if (autoCommitSettings == null) {
            return Futures.immediateFuture(null);
        }
        AutoVersionCreateConfig autoCommitConfig = (AutoVersionCreateConfig)autoCommitSettings.get((Object)entityType);
        if (autoCommitConfig == null) {
            return Futures.immediateFuture(null);
        }
        String autoCommitBranchName = autoCommitConfig.getBranch();
        if (StringUtils.isEmpty((CharSequence)autoCommitBranchName)) {
            autoCommitBranchName = StringUtils.isNotEmpty((CharSequence)repositorySettings.getDefaultBranch()) ? repositorySettings.getDefaultBranch() : "auto-commits";
        }
        ComplexVersionCreateRequest vcr = new ComplexVersionCreateRequest();
        vcr.setBranch(autoCommitBranchName);
        vcr.setVersionName("auto-commit at " + String.valueOf(Instant.ofEpochSecond(System.currentTimeMillis() / 1000L)));
        vcr.setSyncStrategy(SyncStrategy.MERGE);
        EntityTypeVersionCreateConfig vcrConfig = new EntityTypeVersionCreateConfig();
        vcrConfig.setEntityIds(entityIds);
        vcr.setEntityTypes(Collections.singletonMap(entityType, vcrConfig));
        return this.saveEntitiesVersion(user, (VersionCreateRequest)vcr);
    }

    private String getCauseMessage(Exception e) {
        String message = e.getCause() != null && StringUtils.isNotEmpty((CharSequence)e.getCause().getMessage()) ? e.getCause().getMessage() : e.getMessage();
        return message;
    }

    private HasId<? extends EntityId> findExportableEntityInDb(TenantId tenantId, EntityId entityId) {
        HasId entity = this.exportableEntitiesService.findEntityByTenantIdAndId(tenantId, entityId);
        if (entity == null) {
            throw new IllegalArgumentException("Can't find the entity with id: " + String.valueOf(entityId));
        }
        if (!(entity instanceof ExportableEntity)) {
            throw new IllegalArgumentException("Unsupported entity type");
        }
        return entity;
    }

    private void registerResult(EntitiesImportCtx ctx, EntityType entityType, EntityImportResult<?> importResult, EntityExportData exportData) {
        boolean isGroup = exportData.getEntity() instanceof EntityGroup;
        if (isGroup) {
            entityType = ((EntityGroup)exportData.getEntity()).getType();
        }
        if (importResult.isCreated()) {
            ctx.registerResult(entityType, isGroup, true);
        } else if (importResult.isUpdated() || importResult.isUpdatedRelatedEntities()) {
            ctx.registerResult(entityType, isGroup, false);
        }
    }

    private void processCommitError(User user, VersionCreateRequest request, CommitGitRequest commit, Throwable e) {
        log.debug("[{}] Failed to prepare the commit: {}", new Object[]{user.getId(), request, e});
        this.cachePut(commit.getTxId(), new VersionCreationResult(e.getMessage()));
    }

    private void processLoadError(EntitiesImportCtx ctx, Throwable e) {
        log.debug("[{}] Failed to load the commit: {}", new Object[]{ctx.getRequestId(), ctx.getVersionId(), e});
        this.cachePut(ctx.getRequestId(), VersionLoadResult.error((EntityLoadError)EntityLoadError.runtimeError((Throwable)e)));
    }

    private void cachePut(UUID requestId, VersionCreationResult result) {
        this.taskCache.put((Serializable)requestId, (Serializable)VersionControlTaskCacheEntry.newForExport((VersionCreationResult)result));
    }

    private VersionLoadResult cachePut(UUID requestId, VersionLoadResult result) {
        log.trace("[{}] Cache put: {}", (Object)requestId, (Object)result);
        this.taskCache.put((Serializable)requestId, (Serializable)VersionControlTaskCacheEntry.newForImport((VersionLoadResult)result));
        return result;
    }

    private void persistToCache(EntitiesImportCtx ctx) {
        this.cachePut(ctx.getRequestId(), VersionLoadResult.success(new ArrayList(ctx.getResults().values())));
    }

    @ConstructorProperties(value={"repositorySettingsService", "autoCommitSettingsService", "gitServiceQueue", "exportImportService", "exportableEntitiesService", "logEntityActionService", "transactionTemplate", "customerService", "ownersService", "groupService", "taskCache", "executor"})
    @Generated
    public DefaultEntitiesVersionControlService(TbRepositorySettingsService repositorySettingsService, TbAutoCommitSettingsService autoCommitSettingsService, GitVersionControlQueueService gitServiceQueue, EntitiesExportImportService exportImportService, ExportableEntitiesService exportableEntitiesService, TbLogEntityActionService logEntityActionService, TransactionTemplate transactionTemplate, CustomerService customerService, OwnerService ownersService, EntityGroupService groupService, TbTransactionalCache<UUID, VersionControlTaskCacheEntry> taskCache, VersionControlExecutor executor) {
        this.repositorySettingsService = repositorySettingsService;
        this.autoCommitSettingsService = autoCommitSettingsService;
        this.gitServiceQueue = gitServiceQueue;
        this.exportImportService = exportImportService;
        this.exportableEntitiesService = exportableEntitiesService;
        this.logEntityActionService = logEntityActionService;
        this.transactionTemplate = transactionTemplate;
        this.customerService = customerService;
        this.ownersService = ownersService;
        this.groupService = groupService;
        this.taskCache = taskCache;
        this.executor = executor;
    }
}

