/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.sync.ie.SchedulerEventExportData;
import org.thingsboard.server.dao.scheduler.SchedulerEventService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class SchedulerEventImportService
extends BaseEntityImportService<SchedulerEventId, SchedulerEvent, SchedulerEventExportData> {
    private final SchedulerEventService schedulerEventService;

    protected void setOwner(TenantId tenantId, SchedulerEvent schedulerEvent, BaseEntityImportService.IdProvider idProvider) {
        schedulerEvent.setTenantId(tenantId);
        if (schedulerEvent.getOwnerId() instanceof TenantId) {
            schedulerEvent.setOwnerId((EntityId)tenantId);
        } else {
            schedulerEvent.setOwnerId(idProvider.getInternalId(schedulerEvent.getOwnerId()));
        }
    }

    protected SchedulerEvent prepare(EntitiesImportCtx ctx, SchedulerEvent schedulerEvent, SchedulerEvent oldSchedulerEvent, SchedulerEventExportData exportData, BaseEntityImportService.IdProvider idProvider) {
        EntityId originatorId = schedulerEvent.getOriginatorId();
        boolean isEntityGroup = originatorId != null && originatorId.getEntityType() == EntityType.ENTITY_GROUP;
        EntityId internalId = idProvider.getInternalId(originatorId, !isEntityGroup || ctx.isFinalImportAttempt());
        schedulerEvent.setOriginatorId(internalId != null ? internalId : originatorId);
        JsonNode configuration = exportData.prepareConfiguration(schedulerEvent.getConfiguration(), schedulerEvent.getType(), arg_0 -> ((BaseEntityImportService.IdProvider)idProvider).getInternalId(arg_0), ctx.getUser().getId());
        schedulerEvent.setConfiguration(configuration);
        return schedulerEvent;
    }

    protected SchedulerEvent deepCopy(SchedulerEvent schedulerEvent) {
        return new SchedulerEvent(schedulerEvent);
    }

    protected SchedulerEvent saveOrUpdate(EntitiesImportCtx ctx, SchedulerEvent schedulerEvent, SchedulerEventExportData exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) throws Exception {
        return this.schedulerEventService.saveSchedulerEvent(schedulerEvent);
    }

    protected void cleanupForComparison(SchedulerEvent schedulerEvent) {
        super.cleanupForComparison((ExportableEntity)schedulerEvent);
        if (schedulerEvent.getCustomerId() != null && schedulerEvent.getCustomerId().isNullUid()) {
            schedulerEvent.setCustomerId(null);
        }
    }

    public EntityType getEntityType() {
        return EntityType.SCHEDULER_EVENT;
    }

    @ConstructorProperties(value={"schedulerEventService"})
    @Generated
    public SchedulerEventImportService(SchedulerEventService schedulerEventService) {
        this.schedulerEventService = schedulerEventService;
    }
}

