/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.ReportTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.report.ReportTemplate;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.report.ReportTemplateService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class ReportTemplateImportService
extends BaseEntityImportService<ReportTemplateId, ReportTemplate, EntityExportData<ReportTemplate>> {
    private static final LinkedHashSet<EntityType> HINTS = new LinkedHashSet<EntityType>(Arrays.asList(EntityType.DASHBOARD, EntityType.DEVICE, EntityType.ASSET));
    private final ReportTemplateService reportTemplateService;

    protected void setOwner(TenantId tenantId, ReportTemplate reportTemplate, BaseEntityImportService.IdProvider idProvider) {
        reportTemplate.setTenantId(tenantId);
        if (reportTemplate.getOwnerId() instanceof TenantId) {
            reportTemplate.setOwnerId((EntityId)tenantId);
        } else {
            reportTemplate.setOwnerId(idProvider.getInternalId(reportTemplate.getOwnerId()));
        }
    }

    protected ReportTemplate prepare(EntitiesImportCtx ctx, ReportTemplate reportTemplate, ReportTemplate oldReportTemplate, EntityExportData<ReportTemplate> exportData, BaseEntityImportService.IdProvider idProvider) {
        for (JsonNode entityAlias : reportTemplate.getEntityAliasesConfig()) {
            this.replaceIdsRecursively(ctx, idProvider, entityAlias, Set.of("id"), null, HINTS);
        }
        for (JsonNode dataSource : reportTemplate.getComponentDataSources()) {
            this.replaceIdsRecursively(ctx, idProvider, dataSource, Set.of("entityAlias"), null, HINTS);
        }
        return reportTemplate;
    }

    protected ReportTemplate deepCopy(ReportTemplate reportTemplate) {
        return new ReportTemplate(reportTemplate);
    }

    protected ReportTemplate saveOrUpdate(EntitiesImportCtx ctx, ReportTemplate reportTemplate, EntityExportData<ReportTemplate> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) throws Exception {
        return this.reportTemplateService.saveReportTemplate(reportTemplate);
    }

    protected void cleanupForComparison(ReportTemplate reportTemplate) {
        super.cleanupForComparison((ExportableEntity)reportTemplate);
        if (reportTemplate.getCustomerId() != null && reportTemplate.getCustomerId().isNullUid()) {
            reportTemplate.setCustomerId(null);
        }
    }

    public EntityType getEntityType() {
        return EntityType.REPORT_TEMPLATE;
    }

    @ConstructorProperties(value={"reportTemplateService"})
    @Generated
    public ReportTemplateImportService(ReportTemplateService reportTemplateService) {
        this.reportTemplateService = reportTemplateService;
    }
}

