/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.converter.Converter;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.ConverterId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class ConverterImportService
extends BaseEntityImportService<ConverterId, Converter, EntityExportData<Converter>> {
    private final ConverterService converterService;

    protected void setOwner(TenantId tenantId, Converter converter, BaseEntityImportService.IdProvider idProvider) {
        converter.setTenantId(tenantId);
    }

    protected Converter prepare(EntitiesImportCtx ctx, Converter entity, Converter oldEntity, EntityExportData<Converter> exportData, BaseEntityImportService.IdProvider idProvider) {
        return entity;
    }

    protected Converter deepCopy(Converter converter) {
        return new Converter(converter);
    }

    protected Converter saveOrUpdate(EntitiesImportCtx ctx, Converter entity, EntityExportData<Converter> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        return this.converterService.saveConverter(entity);
    }

    protected void onEntitySaved(User user, Converter savedConverter, Converter oldConverter) throws ThingsboardException {
        super.onEntitySaved(user, (ExportableEntity)savedConverter, (ExportableEntity)oldConverter);
    }

    public EntityType getEntityType() {
        return EntityType.CONVERTER;
    }

    @ConstructorProperties(value={"converterService"})
    @Generated
    public ConverterImportService(ConverterService converterService) {
        this.converterService = converterService;
    }
}

