/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.api.client.util.Objects;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDefaultOption;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.configuration.AlarmCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.ArgumentsBasedCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.HasId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.sync.ie.AttributeExportData;
import org.thingsboard.server.common.data.sync.ie.EntityExportData;
import org.thingsboard.server.common.data.sync.ie.EntityImportResult;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.relation.RelationDao;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.entitiy.TbLogEntityActionService;
import org.thingsboard.server.service.security.permission.OwnersCacheService;
import org.thingsboard.server.service.sync.ie.exporting.ExportableEntitiesService;
import org.thingsboard.server.service.sync.ie.importing.EntityImportService;
import org.thingsboard.server.service.sync.ie.importing.MissingEntityException;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

public abstract class BaseEntityImportService<I extends EntityId, E extends ExportableEntity<I>, D extends EntityExportData<E>>
implements EntityImportService<I, E, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseEntityImportService.class);
    @Autowired
    @Lazy
    protected ExportableEntitiesService entitiesService;
    @Autowired
    @Lazy
    protected OwnersCacheService ownersCacheService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private RelationService relationService;
    @Autowired
    private RelationDao relationDao;
    @Autowired
    private TelemetrySubscriptionService tsSubService;
    @Autowired
    protected EntityActionService entityActionService;
    @Autowired
    protected TbClusterService clusterService;
    @Autowired
    protected TbLogEntityActionService logEntityActionService;
    @Autowired
    protected SecretConfigurationService secretConfigurationService;

    public EntityImportResult<E> importEntity(EntitiesImportCtx ctx, D exportData) throws Exception {
        EntityImportResult importResult = new EntityImportResult();
        ctx.setCurrentImportResult(importResult);
        importResult.setEntityType(this.getEntityType());
        IdProvider idProvider = new IdProvider(this, ctx, importResult);
        ExportableEntity entity = exportData.getEntity();
        entity.setExternalId((EntityId)entity.getId());
        ExportableEntity existingEntity = this.findExistingEntity(ctx, entity, idProvider);
        importResult.setOldEntity(existingEntity);
        this.setOwner(ctx.getTenantId(), entity, idProvider);
        if (existingEntity == null) {
            entity.setId(null);
        } else {
            entity.setId((EntityId)existingEntity.getId());
            entity.setCreatedTime(existingEntity.getCreatedTime());
        }
        ExportableEntity prepared = this.prepare(ctx, entity, existingEntity, exportData, idProvider);
        CompareResult compareResult = this.compare(ctx, exportData, prepared, existingEntity);
        if (compareResult.isUpdateNeeded()) {
            boolean changeOwner = false;
            if (existingEntity != null && prepared instanceof HasOwnerId) {
                EntityId oldOwnerId;
                EntityId newOwnerId = ((HasOwnerId)prepared).getOwnerId();
                boolean bl = changeOwner = !newOwnerId.equals(oldOwnerId = ((HasOwnerId)existingEntity).getOwnerId());
                if (changeOwner) {
                    this.ownersCacheService.changeEntityOwner(ctx.getTenantId(), (EntityId)existingEntity.getId(), newOwnerId, oldOwnerId);
                }
            }
            ExportableEntity savedEntity = this.saveOrUpdate(ctx, prepared, exportData, idProvider, compareResult);
            if (changeOwner) {
                importResult.addSendEventsCallback(() -> this.logEntityActionService.logEntityAction(ctx.getTenantId(), (EntityId)savedEntity.getId(), (HasName)entity, ActionType.CHANGE_OWNER, ctx.getUser(), new Object[]{((HasOwnerId)savedEntity).getOwnerId()}));
            }
            boolean created = existingEntity == null;
            importResult.setCreated(created);
            importResult.setUpdated(!created);
            importResult.setSavedEntity(savedEntity);
            ctx.putInternalId(exportData.getExternalId(), (EntityId)savedEntity.getId());
        } else {
            importResult.setSavedEntity(existingEntity);
            ctx.putInternalId(exportData.getExternalId(), (EntityId)existingEntity.getId());
            importResult.setUpdatedRelatedEntities(this.updateRelatedEntitiesIfUnmodified(ctx, prepared, exportData, idProvider));
        }
        this.processAfterSaved(ctx, importResult, exportData, idProvider);
        return importResult;
    }

    protected boolean updateRelatedEntitiesIfUnmodified(EntitiesImportCtx ctx, E prepared, D exportData, IdProvider idProvider) {
        return this.importCalculatedFields(ctx, prepared, exportData, idProvider);
    }

    public abstract EntityType getEntityType();

    protected abstract void setOwner(TenantId var1, E var2, IdProvider var3);

    protected abstract E prepare(EntitiesImportCtx var1, E var2, E var3, D var4, IdProvider var5);

    protected CompareResult compare(EntitiesImportCtx ctx, D exportData, E prepared, E existing) {
        if (existing == null) {
            log.debug("[{}] Found new entity.", (Object)prepared.getId());
            return new CompareResult(true);
        }
        ExportableEntity newCopy = this.deepCopy(prepared);
        ExportableEntity existingCopy = this.deepCopy(existing);
        this.cleanupForComparison(newCopy);
        this.cleanupForComparison(existingCopy);
        boolean updateNeeded = this.isUpdateNeeded(ctx, exportData, newCopy, existingCopy);
        boolean externalIdChangedOnly = false;
        if (updateNeeded) {
            log.debug("[{}] Found update.", (Object)prepared.getId());
            log.debug("[{}] From: {}", (Object)prepared.getId(), (Object)newCopy);
            log.debug("[{}] To: {}", (Object)prepared.getId(), (Object)existingCopy);
            this.cleanupExternalId(newCopy);
            this.cleanupExternalId(existingCopy);
            externalIdChangedOnly = newCopy.equals(existingCopy);
        }
        return new CompareResult(updateNeeded, externalIdChangedOnly);
    }

    protected boolean isUpdateNeeded(EntitiesImportCtx ctx, D exportData, E prepared, E existing) {
        return !prepared.equals(existing);
    }

    protected abstract E deepCopy(E var1);

    protected void cleanupForComparison(E e) {
        e.setTenantId(null);
        e.setCreatedTime(0L);
        if (e instanceof HasVersion) {
            HasVersion hasVersion = (HasVersion)e;
            hasVersion.setVersion(null);
        }
    }

    protected void cleanupExternalId(E e) {
        e.setExternalId(null);
    }

    protected abstract E saveOrUpdate(EntitiesImportCtx var1, E var2, D var3, IdProvider var4, CompareResult var5) throws Exception;

    protected void processAfterSaved(EntitiesImportCtx ctx, EntityImportResult<E> importResult, D exportData, IdProvider idProvider) throws ThingsboardException {
        ExportableEntity savedEntity = importResult.getSavedEntity();
        ExportableEntity oldEntity = importResult.getOldEntity();
        if (importResult.isCreated() || importResult.isUpdated()) {
            importResult.addSendEventsCallback(() -> this.onEntitySaved(ctx.getUser(), savedEntity, oldEntity));
        }
        if (ctx.isUpdateRelations() && exportData.getRelations() != null) {
            this.importRelations(ctx, exportData.getRelations(), importResult, idProvider);
        }
        if (ctx.isSaveAttributes() && exportData.getAttributes() != null) {
            if (exportData.getAttributes().values().stream().anyMatch(d -> !d.isEmpty())) {
                importResult.setUpdatedRelatedEntities(true);
            }
            this.importAttributes(ctx.getUser(), exportData.getAttributes(), importResult);
        }
    }

    private void importRelations(EntitiesImportCtx ctx, List<EntityRelation> relations, EntityImportResult<E> importResult, IdProvider idProvider) {
        TenantId tenantId = ctx.getTenantId();
        ExportableEntity entity = importResult.getSavedEntity();
        importResult.addSaveReferencesCallback(() -> {
            for (EntityRelation relation : relations) {
                if (!relation.getTo().equals(entity.getId())) {
                    relation.setTo(idProvider.getInternalId(relation.getTo()));
                }
                if (relation.getFrom().equals(entity.getId())) continue;
                relation.setFrom(idProvider.getInternalId(relation.getFrom()));
            }
            LinkedHashMap relationsMap = new LinkedHashMap();
            relations.forEach(r -> relationsMap.put(r, r));
            if (importResult.getOldEntity() != null) {
                ArrayList existingRelations = new ArrayList();
                existingRelations.addAll(this.relationDao.findAllByTo(tenantId, (EntityId)entity.getId(), RelationTypeGroup.COMMON));
                existingRelations.addAll(this.relationDao.findAllByFrom(tenantId, (EntityId)entity.getId(), RelationTypeGroup.COMMON));
                for (EntityRelation existingRelation : existingRelations) {
                    EntityRelation relation = (EntityRelation)relationsMap.get(existingRelation);
                    if (relation == null) {
                        importResult.setUpdatedRelatedEntities(true);
                        this.relationService.deleteRelation(ctx.getTenantId(), existingRelation.getFrom(), existingRelation.getTo(), existingRelation.getType(), existingRelation.getTypeGroup());
                        importResult.addSendEventsCallback(() -> this.logEntityActionService.logEntityRelationAction(tenantId, null, existingRelation, ctx.getUser(), ActionType.RELATION_DELETED, null, new Object[]{existingRelation}));
                        continue;
                    }
                    if (!Objects.equal((Object)relation.getAdditionalInfo(), (Object)existingRelation.getAdditionalInfo())) continue;
                    relationsMap.remove(relation);
                }
            }
            if (!relationsMap.isEmpty()) {
                importResult.setUpdatedRelatedEntities(true);
                ctx.addRelations(relationsMap.values());
            }
        });
    }

    private void importAttributes(User user, Map<String, List<AttributeExportData>> attributes, EntityImportResult<E> importResult) {
        ExportableEntity entity = importResult.getSavedEntity();
        importResult.addSaveReferencesCallback(() -> attributes.forEach((scope, attributesExportData) -> {
            List attributeKvEntries = attributesExportData.stream().map(attributeExportData -> {
                StringDataEntry kvEntry;
                String key = attributeExportData.getKey();
                if (attributeExportData.getStrValue() != null) {
                    kvEntry = new StringDataEntry(key, attributeExportData.getStrValue());
                } else if (attributeExportData.getBooleanValue() != null) {
                    kvEntry = new BooleanDataEntry(key, attributeExportData.getBooleanValue());
                } else if (attributeExportData.getDoubleValue() != null) {
                    kvEntry = new DoubleDataEntry(key, attributeExportData.getDoubleValue());
                } else if (attributeExportData.getLongValue() != null) {
                    kvEntry = new LongDataEntry(key, attributeExportData.getLongValue());
                } else if (attributeExportData.getJsonValue() != null) {
                    kvEntry = new JsonDataEntry(key, attributeExportData.getJsonValue());
                } else {
                    throw new IllegalArgumentException("Invalid attribute export data");
                }
                return new BaseAttributeKvEntry((KvEntry)kvEntry, attributeExportData.getLastUpdateTs().longValue());
            }).collect(Collectors.toList());
            this.tsSubService.saveAttributes(AttributesSaveRequest.builder().tenantId(user.getTenantId()).entityId((EntityId)entity.getId()).scope(scope).entries(attributeKvEntries).callback((FutureCallback)new /* Unavailable Anonymous Inner Class!! */).build());
        }));
    }

    protected boolean importCalculatedFields(EntitiesImportCtx ctx, E savedEntity, D exportData, IdProvider idProvider) {
        boolean found;
        if (exportData.getCalculatedFields() == null || !ctx.isSaveCalculatedFields()) {
            return false;
        }
        boolean updated = false;
        List existing = this.calculatedFieldService.findCalculatedFieldsByEntityId(ctx.getTenantId(), (EntityId)savedEntity.getId());
        List<CalculatedField> fieldsToSave = exportData.getCalculatedFields().stream().peek(calculatedField -> {
            CalculatedFieldConfiguration patt19574$temp;
            calculatedField.setTenantId(ctx.getTenantId());
            calculatedField.setEntityId((EntityId)savedEntity.getId());
            CalculatedFieldConfiguration patt18456$temp = calculatedField.getConfiguration();
            if (patt18456$temp instanceof ArgumentsBasedCalculatedFieldConfiguration) {
                ArgumentsBasedCalculatedFieldConfiguration argBasedConfig = (ArgumentsBasedCalculatedFieldConfiguration)patt18456$temp;
                if (argBasedConfig instanceof GeofencingCalculatedFieldConfiguration) {
                    GeofencingCalculatedFieldConfiguration geofencingCfg = (GeofencingCalculatedFieldConfiguration)argBasedConfig;
                    geofencingCfg.getZoneGroups().values().forEach(zoneGroupConfiguration -> {
                        if (zoneGroupConfiguration.getRefEntityId() != null) {
                            zoneGroupConfiguration.setRefEntityId(idProvider.getInternalId(zoneGroupConfiguration.getRefEntityId(), ctx.isFinalImportAttempt()));
                        }
                    });
                } else {
                    argBasedConfig.getArguments().values().forEach(argument -> {
                        if (argument.getRefEntityId() != null) {
                            argument.setRefEntityId(idProvider.getInternalId(argument.getRefEntityId(), ctx.isFinalImportAttempt()));
                        }
                    });
                }
            }
            if ((patt19574$temp = calculatedField.getConfiguration()) instanceof AlarmCalculatedFieldConfiguration) {
                AlarmCalculatedFieldConfiguration alarmCfConfig = (AlarmCalculatedFieldConfiguration)patt19574$temp;
                alarmCfConfig.getAllRules().map(Pair::getValue).forEach(rule -> {
                    if (rule.getDashboardId() != null) {
                        rule.setDashboardId((DashboardId)idProvider.getInternalId((EntityId)rule.getDashboardId(), ctx.isFinalImportAttempt()));
                    }
                });
            }
        }).toList();
        for (CalculatedField existingField2 : existing) {
            found = fieldsToSave.stream().anyMatch(importedField -> this.compareCalculatedFields(existingField2, importedField));
            if (found) continue;
            this.calculatedFieldService.deleteCalculatedField(ctx.getTenantId(), existingField2.getId());
            updated = true;
        }
        for (CalculatedField calculatedField2 : fieldsToSave) {
            found = existing.stream().anyMatch(existingField -> this.compareCalculatedFields(existingField, calculatedField2));
            if (found) continue;
            this.calculatedFieldService.save(calculatedField2);
            updated = true;
        }
        return updated;
    }

    private boolean compareCalculatedFields(CalculatedField existingField, CalculatedField newField) {
        CalculatedField oldCopy = new CalculatedField(existingField);
        CalculatedField newCopy = new CalculatedField(newField);
        oldCopy.setId(null);
        newCopy.setId(null);
        oldCopy.setVersion(null);
        newCopy.setVersion(null);
        oldCopy.setCreatedTime(0L);
        newCopy.setCreatedTime(0L);
        return oldCopy.equals((Object)newCopy);
    }

    protected void onEntitySaved(User user, E savedEntity, E oldEntity) throws ThingsboardException {
        this.logEntityActionService.logEntityAction(user.getTenantId(), (EntityId)savedEntity.getId(), savedEntity, null, oldEntity == null ? ActionType.ADDED : ActionType.UPDATED, user, new Object[0]);
    }

    protected E findExistingEntity(EntitiesImportCtx ctx, E entity, IdProvider idProvider) {
        return (E)((ExportableEntity)Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndExternalId(ctx.getTenantId(), (EntityId)entity.getId())).or(() -> Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndId(ctx.getTenantId(), (EntityId)entity.getId()))).or(() -> {
            if (ctx.isFindExistingByName()) {
                return Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndName(ctx.getTenantId(), this.getEntityType(), entity.getName()));
            }
            return Optional.empty();
        }).or(() -> {
            HasDefaultOption hasDefaultOption;
            if (entity instanceof HasDefaultOption && (hasDefaultOption = (HasDefaultOption)entity).isDefault()) {
                return Optional.ofNullable(this.entitiesService.findDefaultEntityByTenantId(ctx.getTenantId(), this.getEntityType()));
            }
            return Optional.empty();
        }).orElse(null));
    }

    protected <ID extends EntityId> HasId<ID> findInternalEntity(TenantId tenantId, ID externalId) {
        return (HasId)Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndExternalId(tenantId, externalId)).or(() -> Optional.ofNullable(this.entitiesService.findEntityByTenantIdAndId(tenantId, externalId))).orElseThrow(() -> new MissingEntityException(externalId));
    }

    protected void replaceIdsRecursively(EntitiesImportCtx ctx, IdProvider idProvider, JsonNode json, Set<String> skippedRootFields, Pattern includedFieldsPattern, LinkedHashSet<EntityType> hints) {
        JacksonUtil.replaceUuidsRecursively((JsonNode)json, skippedRootFields, (Pattern)includedFieldsPattern, uuid -> idProvider.getInternalIdByUuid(uuid, ctx.isFinalImportAttempt(), (Set)hints).map(EntityId::getId).orElse((UUID)uuid), (boolean)true);
    }
}

