/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.importing.impl;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sync.ie.GroupEntityExportData;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseEntityImportService;
import org.thingsboard.server.service.sync.ie.importing.impl.BaseGroupEntityImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesImportCtx;

@Service
@TbCoreComponent
public class AssetImportService
extends BaseGroupEntityImportService<AssetId, Asset, GroupEntityExportData<Asset>> {
    private final AssetService assetService;

    protected void setOwner(TenantId tenantId, Asset asset, BaseEntityImportService.IdProvider idProvider) {
        asset.setTenantId(tenantId);
        asset.setCustomerId((CustomerId)idProvider.getInternalId((EntityId)asset.getCustomerId()));
    }

    protected Asset prepare(EntitiesImportCtx ctx, Asset asset, Asset old, GroupEntityExportData<Asset> exportData, BaseEntityImportService.IdProvider idProvider) {
        asset.setAssetProfileId((AssetProfileId)idProvider.getInternalId((EntityId)asset.getAssetProfileId()));
        return asset;
    }

    protected Asset saveOrUpdate(EntitiesImportCtx ctx, Asset asset, GroupEntityExportData<Asset> exportData, BaseEntityImportService.IdProvider idProvider, BaseEntityImportService.CompareResult compareResult) {
        Asset savedAsset = this.assetService.saveAsset(asset);
        if (ctx.isFinalImportAttempt() || ctx.getCurrentImportResult().isUpdatedAllExternalIds()) {
            this.importCalculatedFields(ctx, (ExportableEntity)savedAsset, exportData, idProvider);
        }
        return savedAsset;
    }

    protected Asset deepCopy(Asset asset) {
        return new Asset(asset);
    }

    protected void cleanupForComparison(Asset e) {
        super.cleanupForComparison((ExportableEntity)e);
        if (e.getCustomerId() != null && e.getCustomerId().isNullUid()) {
            e.setCustomerId(null);
        }
    }

    public EntityType getEntityType() {
        return EntityType.ASSET;
    }

    @ConstructorProperties(value={"assetService"})
    @Generated
    public AssetImportService(AssetService assetService) {
        this.assetService = assetService;
    }
}

