/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.ie.exporting.impl;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.sync.ie.RuleChainExportData;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.sync.ie.exporting.impl.BaseEntityExportService;
import org.thingsboard.server.service.sync.ie.importing.impl.RuleChainImportService;
import org.thingsboard.server.service.sync.vc.data.EntitiesExportCtx;

@Service
@TbCoreComponent
public class RuleChainExportService
extends BaseEntityExportService<RuleChainId, RuleChain, RuleChainExportData> {
    private final RuleChainService ruleChainService;

    protected void setRelatedEntities(EntitiesExportCtx<?> ctx, RuleChain ruleChain, RuleChainExportData exportData) {
        RuleChainMetaData metaData = this.ruleChainService.loadRuleChainMetaData(ctx.getTenantId(), ruleChain.getId());
        Optional.ofNullable(metaData.getNodes()).orElse(Collections.emptyList()).forEach(ruleNode -> {
            ruleNode.setRuleChainId(null);
            ctx.putExternalId((EntityId)ruleNode.getId(), (EntityId)ruleNode.getExternalId());
            ruleNode.setId((UUIDBased)((RuleNodeId)ctx.getExternalId((EntityId)ruleNode.getId())));
            ruleNode.setCreatedTime(0L);
            ruleNode.setExternalId(null);
            this.replaceUuidsRecursively(ctx, ruleNode.getConfiguration(), Collections.emptySet(), RuleChainImportService.PROCESSED_CONFIG_FIELDS_PATTERN);
        });
        Optional.ofNullable(metaData.getRuleChainConnections()).orElse(Collections.emptyList()).forEach(ruleChainConnectionInfo -> ruleChainConnectionInfo.setTargetRuleChainId((RuleChainId)this.getExternalIdOrElseInternal(ctx, (EntityId)ruleChainConnectionInfo.getTargetRuleChainId())));
        exportData.setMetaData(metaData);
        if (ruleChain.getFirstRuleNodeId() != null) {
            ruleChain.setFirstRuleNodeId((RuleNodeId)ctx.getExternalId((EntityId)ruleChain.getFirstRuleNodeId()));
        }
    }

    protected RuleChainExportData newExportData() {
        return new RuleChainExportData();
    }

    public Set<EntityType> getSupportedEntityTypes() {
        return Set.of(EntityType.RULE_CHAIN);
    }

    @ConstructorProperties(value={"ruleChainService"})
    @Generated
    public RuleChainExportService(RuleChainService ruleChainService) {
        this.ruleChainService = ruleChainService;
    }
}

