/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmCountQuery;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractEntityQuerySubCtx;
import org.thingsboard.server.service.subscription.TbAlarmsSubscription;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AlarmCountUpdate;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdate;

public class TbAlarmCountSubCtx
extends TbAbstractEntityQuerySubCtx<AlarmCountQuery> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAlarmCountSubCtx.class);
    private final AlarmService alarmService;
    protected final Map<Integer, EntityId> subToEntityIdMap;
    private LinkedHashSet<EntityId> entitiesIds;
    private final int maxEntitiesPerAlarmSubscription;
    private final int maxAlarmQueriesPerRefreshInterval;
    private volatile int result;
    private boolean tooManyEntities;
    private int alarmCountInvocationAttempts;

    public TbAlarmCountSubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, AlarmService alarmService, WebSocketSessionRef sessionRef, int cmdId, int maxEntitiesPerAlarmSubscription, int maxAlarmQueriesPerRefreshInterval) {
        super(serviceId, wsService, entityService, localSubscriptionService, attributesService, stats, sessionRef, cmdId);
        this.alarmService = alarmService;
        this.subToEntityIdMap = new ConcurrentHashMap();
        this.maxEntitiesPerAlarmSubscription = maxEntitiesPerAlarmSubscription;
        this.maxAlarmQueriesPerRefreshInterval = maxAlarmQueriesPerRefreshInterval;
        this.entitiesIds = null;
    }

    public void clearSubscriptions() {
        this.clearAlarmSubscriptions();
    }

    public void fetchData() {
        this.resetInvocationCounter();
        if (((AlarmCountQuery)this.query).getEntityFilter() != null) {
            this.entitiesIds = new LinkedHashSet();
            log.trace("[{}] Fetching data: {}", (Object)this.cmdId, (Object)this.alarmCountInvocationAttempts);
            PageData data = this.entityService.findEntityDataByQuery(this.getTenantId(), this.getCustomerId(), this.getMergedUserPermissions(), this.buildEntityDataQuery());
            this.entitiesIds.clear();
            this.tooManyEntities = data.hasNext();
            for (EntityData entityData : data.getData()) {
                this.entitiesIds.add(entityData.getEntityId());
            }
        }
    }

    protected void update() {
        this.resetInvocationCounter();
        this.fetchAlarmCount();
    }

    public boolean isDynamic() {
        return true;
    }

    public void fetchAlarmCount() {
        ++this.alarmCountInvocationAttempts;
        log.trace("[{}] Fetching alarms: {}", (Object)this.cmdId, (Object)this.alarmCountInvocationAttempts);
        if (this.alarmCountInvocationAttempts <= this.maxAlarmQueriesPerRefreshInterval) {
            int newCount = (int)this.alarmService.countAlarmsByQuery(this.getTenantId(), this.getCustomerId(), this.getMergedUserPermissions(), (AlarmCountQuery)this.query, (Collection)this.entitiesIds);
            if (newCount != this.result) {
                this.result = newCount;
                this.sendWsMsg((CmdUpdate)new AlarmCountUpdate(this.cmdId, this.result));
            }
        } else {
            log.trace("[{}] Ignore alarm count fetch due to rate limit: [{}] of maximum [{}]", new Object[]{this.cmdId, this.alarmCountInvocationAttempts, this.maxAlarmQueriesPerRefreshInterval});
        }
    }

    public void doFetchAlarmCount() {
        this.result = (int)this.alarmService.countAlarmsByQuery(this.getTenantId(), this.getCustomerId(), this.getMergedUserPermissions(), (AlarmCountQuery)this.query, (Collection)this.entitiesIds);
        this.sendWsMsg((CmdUpdate)new AlarmCountUpdate(this.cmdId, this.result));
    }

    private EntityDataQuery buildEntityDataQuery() {
        EntityDataPageLink edpl = new EntityDataPageLink(this.maxEntitiesPerAlarmSubscription, 0, null, new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "created_time")));
        return new EntityDataQuery(((AlarmCountQuery)this.query).getEntityFilter(), edpl, null, null, ((AlarmCountQuery)this.query).getKeyFilters());
    }

    private void resetInvocationCounter() {
        this.alarmCountInvocationAttempts = 0;
    }

    public void createAlarmSubscriptions() {
        for (EntityId entityId : this.entitiesIds) {
            this.createAlarmSubscriptionForEntity(entityId);
        }
    }

    private void createAlarmSubscriptionForEntity(EntityId entityId) {
        int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
        this.subToEntityIdMap.put(subIdx, entityId);
        log.trace("[{}][{}][{}] Creating alarms subscription for [{}] ", new Object[]{this.serviceId, this.cmdId, subIdx, entityId});
        TbAlarmsSubscription subscription = TbAlarmsSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityId).updateProcessor((sub, update) -> this.fetchAlarmCount()).build();
        this.localSubscriptionService.addSubscription((TbSubscription)subscription, this.sessionRef);
    }

    public void clearAlarmSubscriptions() {
        if (this.subToEntityIdMap != null) {
            for (Integer subId : this.subToEntityIdMap.keySet()) {
                this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.getSessionId(), subId.intValue());
            }
            this.subToEntityIdMap.clear();
        }
    }

    @Generated
    public String toString() {
        return "TbAlarmCountSubCtx(super=" + super.toString() + ", alarmService=" + String.valueOf(this.alarmService) + ", subToEntityIdMap=" + String.valueOf(this.subToEntityIdMap) + ", entitiesIds=" + String.valueOf(this.getEntitiesIds()) + ", maxEntitiesPerAlarmSubscription=" + this.maxEntitiesPerAlarmSubscription + ", maxAlarmQueriesPerRefreshInterval=" + this.maxAlarmQueriesPerRefreshInterval + ", result=" + this.getResult() + ", tooManyEntities=" + this.isTooManyEntities() + ", alarmCountInvocationAttempts=" + this.alarmCountInvocationAttempts + ")";
    }

    @Generated
    public LinkedHashSet<EntityId> getEntitiesIds() {
        return this.entitiesIds;
    }

    @Generated
    public int getResult() {
        return this.result;
    }

    @Generated
    public void setResult(int result) {
        this.result = result;
    }

    @Generated
    public boolean isTooManyEntities() {
        return this.tooManyEntities;
    }

    @Generated
    public void setTooManyEntities(boolean tooManyEntities) {
        this.tooManyEntities = tooManyEntities;
    }
}

