/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdate;

public abstract class TbAbstractSubCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAbstractSubCtx.class);
    protected final Lock wsLock = new ReentrantLock(true);
    protected final String serviceId;
    protected final SubscriptionServiceStatistics stats;
    private final WebSocketService wsService;
    protected final TbLocalSubscriptionService localSubscriptionService;
    protected final WebSocketSessionRef sessionRef;
    protected final int cmdId;
    protected volatile boolean stopped;
    protected long createdTime = System.currentTimeMillis();

    public TbAbstractSubCtx(String serviceId, WebSocketService wsService, TbLocalSubscriptionService localSubscriptionService, SubscriptionServiceStatistics stats, WebSocketSessionRef sessionRef, int cmdId) {
        this.serviceId = serviceId;
        this.wsService = wsService;
        this.localSubscriptionService = localSubscriptionService;
        this.stats = stats;
        this.sessionRef = sessionRef;
        this.cmdId = cmdId;
    }

    public abstract boolean isDynamic();

    public void stop() {
        this.stopped = true;
    }

    public String getSessionId() {
        return this.sessionRef.getSessionId();
    }

    public TenantId getTenantId() {
        return this.sessionRef.getSecurityCtx().getTenantId();
    }

    public CustomerId getCustomerId() {
        return this.sessionRef.getSecurityCtx().getCustomerId();
    }

    public UserId getUserId() {
        return this.sessionRef.getSecurityCtx().getId();
    }

    public EntityId getOwnerId() {
        return this.sessionRef.getSecurityCtx().getOwnerId();
    }

    public MergedUserPermissions getMergedUserPermissions() {
        return this.sessionRef.getSecurityCtx().getUserPermissions();
    }

    public void sendWsMsg(CmdUpdate update) {
        this.wsLock.lock();
        try {
            this.wsService.sendUpdate(this.sessionRef.getSessionId(), update);
        }
        finally {
            this.wsLock.unlock();
        }
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public SubscriptionServiceStatistics getStats() {
        return this.stats;
    }

    @Generated
    public WebSocketService getWsService() {
        return this.wsService;
    }

    @Generated
    public TbLocalSubscriptionService getLocalSubscriptionService() {
        return this.localSubscriptionService;
    }

    @Generated
    public WebSocketSessionRef getSessionRef() {
        return this.sessionRef;
    }

    @Generated
    public int getCmdId() {
        return this.cmdId;
    }

    @Generated
    public boolean isStopped() {
        return this.stopped;
    }

    @Generated
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Generated
    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbAbstractSubCtx)) {
            return false;
        }
        TbAbstractSubCtx other = (TbAbstractSubCtx)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCmdId() != other.getCmdId()) {
            return false;
        }
        if (this.isStopped() != other.isStopped()) {
            return false;
        }
        if (this.getCreatedTime() != other.getCreatedTime()) {
            return false;
        }
        Lock this$wsLock = this.getWsLock();
        Lock other$wsLock = other.getWsLock();
        if (this$wsLock == null ? other$wsLock != null : !this$wsLock.equals(other$wsLock)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        SubscriptionServiceStatistics this$stats = this.getStats();
        SubscriptionServiceStatistics other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !this$stats.equals(other$stats)) {
            return false;
        }
        WebSocketService this$wsService = this.getWsService();
        WebSocketService other$wsService = other.getWsService();
        if (this$wsService == null ? other$wsService != null : !this$wsService.equals(other$wsService)) {
            return false;
        }
        TbLocalSubscriptionService this$localSubscriptionService = this.getLocalSubscriptionService();
        TbLocalSubscriptionService other$localSubscriptionService = other.getLocalSubscriptionService();
        if (this$localSubscriptionService == null ? other$localSubscriptionService != null : !this$localSubscriptionService.equals(other$localSubscriptionService)) {
            return false;
        }
        WebSocketSessionRef this$sessionRef = this.getSessionRef();
        WebSocketSessionRef other$sessionRef = other.getSessionRef();
        return !(this$sessionRef == null ? other$sessionRef != null : !this$sessionRef.equals(other$sessionRef));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbAbstractSubCtx;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCmdId();
        result = result * 59 + (this.isStopped() ? 79 : 97);
        long $createdTime = this.getCreatedTime();
        result = result * 59 + (int)($createdTime >>> 32 ^ $createdTime);
        Lock $wsLock = this.getWsLock();
        result = result * 59 + ($wsLock == null ? 43 : $wsLock.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        SubscriptionServiceStatistics $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        WebSocketService $wsService = this.getWsService();
        result = result * 59 + ($wsService == null ? 43 : $wsService.hashCode());
        TbLocalSubscriptionService $localSubscriptionService = this.getLocalSubscriptionService();
        result = result * 59 + ($localSubscriptionService == null ? 43 : $localSubscriptionService.hashCode());
        WebSocketSessionRef $sessionRef = this.getSessionRef();
        result = result * 59 + ($sessionRef == null ? 43 : $sessionRef.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbAbstractSubCtx(wsLock=" + String.valueOf(this.getWsLock()) + ", serviceId=" + this.getServiceId() + ", stats=" + String.valueOf(this.getStats()) + ", wsService=" + String.valueOf(this.getWsService()) + ", localSubscriptionService=" + String.valueOf(this.getLocalSubscriptionService()) + ", sessionRef=" + String.valueOf(this.getSessionRef()) + ", cmdId=" + this.getCmdId() + ", stopped=" + this.isStopped() + ", createdTime=" + this.getCreatedTime() + ")";
    }

    @Generated
    public Lock getWsLock() {
        return this.wsLock;
    }

    @Generated
    public long getCreatedTime() {
        return this.createdTime;
    }
}

