/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.query.ComplexFilterPredicate;
import org.thingsboard.server.common.data.query.DynamicValue;
import org.thingsboard.server.common.data.query.EntityCountQuery;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.KeyFilter;
import org.thingsboard.server.common.data.query.KeyFilterPredicate;
import org.thingsboard.server.common.data.query.SimpleKeyFilterPredicate;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.entity.EntityService;
import org.thingsboard.server.service.subscription.SubscriptionServiceStatistics;
import org.thingsboard.server.service.subscription.TbAbstractEntityQuerySubCtx;
import org.thingsboard.server.service.subscription.TbAbstractSubCtx;
import org.thingsboard.server.service.subscription.TbAttributeSubscription;
import org.thingsboard.server.service.subscription.TbAttributeSubscriptionScope;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.telemetry.sub.TelemetrySubscriptionUpdate;

public abstract class TbAbstractEntityQuerySubCtx<T extends EntityCountQuery>
extends TbAbstractSubCtx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbAbstractEntityQuerySubCtx.class);
    protected final EntityService entityService;
    protected final AttributesService attributesService;
    protected final Set<Integer> subToDynamicValueKeySet;
    protected final Map<DynamicValueKey, List<DynamicValue>> dynamicValues;
    protected T query;
    protected volatile ScheduledFuture<?> refreshTask;

    public TbAbstractEntityQuerySubCtx(String serviceId, WebSocketService wsService, EntityService entityService, TbLocalSubscriptionService localSubscriptionService, AttributesService attributesService, SubscriptionServiceStatistics stats, WebSocketSessionRef sessionRef, int cmdId) {
        super(serviceId, wsService, localSubscriptionService, stats, sessionRef, cmdId);
        this.entityService = entityService;
        this.attributesService = attributesService;
        this.subToDynamicValueKeySet = ConcurrentHashMap.newKeySet();
        this.dynamicValues = new ConcurrentHashMap();
    }

    public abstract void fetchData();

    protected abstract void update();

    public void clearSubscriptions() {
        this.clearDynamicValueSubscriptions();
    }

    public void stop() {
        super.stop();
        this.cancelTasks();
        this.clearSubscriptions();
    }

    public void setAndResolveQuery(T query) {
        this.dynamicValues.clear();
        this.query = query;
        if (query != null) {
            if (query.getEntityFilter() != null) {
                EntityFilter.resolveEntityFilter((EntityFilter)query.getEntityFilter(), (TenantId)this.getTenantId(), (UserId)this.getUserId(), (EntityId)this.getOwnerId());
            }
            if (query.getKeyFilters() != null) {
                for (KeyFilter filter : query.getKeyFilters()) {
                    this.registerDynamicValues(filter.getPredicate());
                }
            }
        }
        this.resolve(this.getTenantId(), this.getCustomerId(), this.getUserId());
    }

    public void resolve(TenantId tenantId, CustomerId customerId, UserId userId) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (DynamicValueKey key : this.dynamicValues.keySet()) {
            switch (1.$SwitchMap$org$thingsboard$server$common$data$query$DynamicValueSourceType[key.getSourceType().ordinal()]) {
                case 1: {
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)tenantId, key));
                    break;
                }
                case 2: {
                    if (customerId == null || customerId.isNullUid()) break;
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)customerId, key));
                    break;
                }
                case 3: {
                    if (userId == null || userId.isNullUid()) break;
                    futures.add(this.resolveEntityValue(tenantId, (EntityId)userId, key));
                }
            }
        }
        try {
            HashMap<EntityId, Map> tmpSubMap = new HashMap<EntityId, Map>();
            for (DynamicValueKeySub sub : (List)Futures.successfulAsList(futures).get()) {
                tmpSubMap.computeIfAbsent(sub.getEntityId(), tmp -> new HashMap()).put(sub.getKey().getSourceAttribute(), sub);
            }
            for (EntityId entityId : tmpSubMap.keySet()) {
                HashMap keyStates = new HashMap();
                Map dynamicValueKeySubMap = (Map)tmpSubMap.get(entityId);
                dynamicValueKeySubMap.forEach((k, v) -> keyStates.put(k, v.getLastUpdateTs()));
                int subIdx = this.sessionRef.getSessionSubIdSeq().incrementAndGet();
                TbAttributeSubscription sub = TbAttributeSubscription.builder().serviceId(this.serviceId).sessionId(this.sessionRef.getSessionId()).subscriptionId(subIdx).tenantId(this.sessionRef.getSecurityCtx().getTenantId()).entityId(entityId).updateProcessor((subscription, subscriptionUpdate) -> this.dynamicValueSubUpdate(subscription.getSessionId(), subscriptionUpdate, dynamicValueKeySubMap)).queryTs(this.createdTime).allKeys(false).keyStates(keyStates).scope(TbAttributeSubscriptionScope.SERVER_SCOPE).build();
                this.subToDynamicValueKeySet.add(subIdx);
                this.localSubscriptionService.addSubscription((TbSubscription)sub, this.sessionRef);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.info("[{}][{}][{}] Failed to resolve dynamic values: {}", new Object[]{tenantId, customerId, userId, this.dynamicValues.keySet()});
        }
    }

    private void dynamicValueSubUpdate(String sessionId, TelemetrySubscriptionUpdate subscriptionUpdate, Map<String, DynamicValueKeySub> dynamicValueKeySubMap) {
        HashMap latestUpdate = new HashMap();
        subscriptionUpdate.getValues().forEach((key, values) -> latestUpdate.put(key, this.getLatest(values)));
        boolean invalidateFilter = false;
        for (Map.Entry entry : latestUpdate.entrySet()) {
            String k = (String)entry.getKey();
            TsValue tsValue = (TsValue)entry.getValue();
            DynamicValueKeySub sub = dynamicValueKeySubMap.get(k);
            if (!sub.updateValue(tsValue)) continue;
            invalidateFilter = true;
            this.updateDynamicValuesByKey(sub, tsValue);
        }
        if (invalidateFilter) {
            this.update();
        }
    }

    private ListenableFuture<DynamicValueKeySub> resolveEntityValue(TenantId tenantId, EntityId entityId, DynamicValueKey key) {
        ListenableFuture entry = this.attributesService.find(tenantId, entityId, AttributeScope.SERVER_SCOPE, key.getSourceAttribute());
        return Futures.transform((ListenableFuture)entry, attributeOpt -> {
            DynamicValueKeySub sub = new DynamicValueKeySub(key, entityId);
            if (attributeOpt.isPresent()) {
                AttributeKvEntry attribute = (AttributeKvEntry)attributeOpt.get();
                sub.setLastUpdateTs(attribute.getLastUpdateTs());
                sub.setLastUpdateValue(attribute.getValueAsString());
                this.updateDynamicValuesByKey(sub, new TsValue(attribute.getLastUpdateTs(), attribute.getValueAsString()));
            }
            return sub;
        }, (Executor)MoreExecutors.directExecutor());
    }

    protected void updateDynamicValuesByKey(DynamicValueKeySub sub, TsValue tsValue) {
        DynamicValueKey dvk = sub.getKey();
        switch (1.$SwitchMap$org$thingsboard$server$common$data$query$FilterPredicateType[dvk.getPredicateType().ordinal()]) {
            case 1: {
                ((List)this.dynamicValues.get(dvk)).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)tsValue.getValue()));
                break;
            }
            case 2: {
                try {
                    Double dValue = Double.parseDouble(tsValue.getValue());
                    ((List)this.dynamicValues.get(dvk)).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)dValue));
                }
                catch (NumberFormatException e) {
                    ((List)this.dynamicValues.get(dvk)).forEach(dynamicValue -> dynamicValue.setResolvedValue(null));
                }
                break;
            }
            case 3: {
                Boolean bValue = Boolean.parseBoolean(tsValue.getValue());
                ((List)this.dynamicValues.get(dvk)).forEach(dynamicValue -> dynamicValue.setResolvedValue((Object)bValue));
            }
        }
    }

    private void registerDynamicValues(KeyFilterPredicate predicate) {
        switch (1.$SwitchMap$org$thingsboard$server$common$data$query$FilterPredicateType[predicate.getType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                Optional value = this.getDynamicValueFromSimplePredicate((SimpleKeyFilterPredicate)predicate);
                if (!value.isPresent()) break;
                DynamicValue dynamicValue = (DynamicValue)value.get();
                DynamicValueKey key = new DynamicValueKey(predicate.getType(), dynamicValue.getSourceType(), dynamicValue.getSourceAttribute());
                this.dynamicValues.computeIfAbsent(key, tmp -> new ArrayList()).add(dynamicValue);
                break;
            }
            case 4: {
                ((ComplexFilterPredicate)predicate).getPredicates().forEach(arg_0 -> this.registerDynamicValues(arg_0));
            }
        }
    }

    private Optional<DynamicValue<T>> getDynamicValueFromSimplePredicate(SimpleKeyFilterPredicate<T> predicate) {
        if (predicate.getValue().getUserValue() == null) {
            return Optional.ofNullable(predicate.getValue().getDynamicValue());
        }
        return Optional.empty();
    }

    protected void clearDynamicValueSubscriptions() {
        if (this.subToDynamicValueKeySet != null) {
            for (Integer subId : this.subToDynamicValueKeySet) {
                this.localSubscriptionService.cancelSubscription(this.getTenantId(), this.sessionRef.getSessionId(), subId.intValue());
            }
            this.subToDynamicValueKeySet.clear();
        }
    }

    public void setRefreshTask(ScheduledFuture<?> task) {
        if (!this.stopped) {
            this.refreshTask = task;
        } else {
            task.cancel(true);
        }
    }

    public void cancelTasks() {
        if (this.refreshTask != null) {
            log.trace("[{}][{}] Canceling old refresh task", (Object)this.sessionRef.getSessionId(), (Object)this.cmdId);
            this.refreshTask.cancel(true);
        }
    }

    protected TsValue getLatest(List<TsValue> values) {
        return values.stream().max(Comparator.comparing(TsValue::getTs)).orElse(null);
    }

    @Generated
    public Map<DynamicValueKey, List<DynamicValue>> getDynamicValues() {
        return this.dynamicValues;
    }

    @Generated
    public T getQuery() {
        return (T)this.query;
    }

    @Generated
    public void setQuery(T query) {
        this.query = query;
    }
}

