/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.stats;

import com.google.common.util.concurrent.FutureCallback;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.QueueStatsId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.queue.QueueStats;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.dao.queue.QueueStatsService;
import org.thingsboard.server.dao.usagerecord.ApiLimitService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.queue.TbRuleEngineConsumerStats;
import org.thingsboard.server.service.stats.DefaultRuleEngineStatisticsService;
import org.thingsboard.server.service.stats.RuleEngineStatisticsService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@TbRuleEngineComponent
@Service
public class DefaultRuleEngineStatisticsService
implements RuleEngineStatisticsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleEngineStatisticsService.class);
    public static final String RULE_ENGINE_EXCEPTION = "ruleEngineException";
    public static final FutureCallback<Void> CALLBACK = new /* Unavailable Anonymous Inner Class!! */;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TelemetrySubscriptionService tsService;
    private final QueueStatsService queueStatsService;
    private final ApiLimitService apiLimitService;
    private final Lock lock = new ReentrantLock();
    private final ConcurrentMap<TenantQueueKey, QueueStatsId> tenantQueueStats = new ConcurrentHashMap();
    @Value(value="${queue.rule-engine.stats.max-error-message-length:4096}")
    private int maxErrorMessageLength;

    public void reportQueueStats(long ts, TbRuleEngineConsumerStats ruleEngineStats) {
        String queueName = ruleEngineStats.getQueueName();
        ruleEngineStats.getTenantStats().forEach((id, stats) -> {
            block3: {
                try {
                    List tsList;
                    TenantId tenantId = TenantId.fromUUID((UUID)id);
                    QueueStatsId queueStatsId = this.getQueueStatsId(tenantId, queueName);
                    if (stats.getTotalMsgCounter().get() > 0 && !(tsList = stats.getCounters().entrySet().stream().map(kv -> new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry((String)kv.getKey(), Long.valueOf(((AtomicInteger)kv.getValue()).get())))).collect(Collectors.toList())).isEmpty()) {
                        long ttl = this.apiLimitService.getLimit(tenantId, DefaultTenantProfileConfiguration::getQueueStatsTtlDays);
                        ttl = TimeUnit.DAYS.toSeconds(ttl);
                        this.tsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)queueStatsId).entries(tsList).ttl(ttl).callback(CALLBACK).build());
                    }
                }
                catch (Exception e) {
                    if ("Asset is referencing to non-existent tenant!".equalsIgnoreCase(e.getMessage())) break block3;
                    log.debug("[{}] Failed to store the statistics", id, (Object)e);
                }
            }
        });
        ruleEngineStats.getTenantExceptions().forEach((tenantId, e) -> {
            block2: {
                try {
                    BasicTsKvEntry tsKv = new BasicTsKvEntry(e.getTs(), (KvEntry)new JsonDataEntry(RULE_ENGINE_EXCEPTION, e.toJsonString(this.maxErrorMessageLength)));
                    long ttl = this.apiLimitService.getLimit(tenantId, DefaultTenantProfileConfiguration::getRuleEngineExceptionsTtlDays);
                    ttl = TimeUnit.DAYS.toSeconds(ttl);
                    this.tsService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)this.getQueueStatsId(tenantId, queueName)).entry((TsKvEntry)tsKv).ttl(ttl).callback(CALLBACK).build());
                }
                catch (Exception e2) {
                    if ("Asset is referencing to non-existent tenant!".equalsIgnoreCase(e2.getMessage())) break block2;
                    log.debug("[{}] Failed to store the statistics", tenantId, (Object)e2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueStatsId getQueueStatsId(TenantId tenantId, String queueName) {
        TenantQueueKey key = new TenantQueueKey(tenantId, queueName);
        QueueStatsId queueStatsId = (QueueStatsId)this.tenantQueueStats.get(key);
        if (queueStatsId == null) {
            this.lock.lock();
            try {
                queueStatsId = (QueueStatsId)this.tenantQueueStats.get(key);
                if (queueStatsId == null) {
                    QueueStats queueStats = this.queueStatsService.findByTenantIdAndNameAndServiceId(tenantId, queueName, this.serviceInfoProvider.getServiceId());
                    if (queueStats == null) {
                        queueStats = new QueueStats();
                        queueStats.setTenantId(tenantId);
                        queueStats.setQueueName(queueName);
                        queueStats.setServiceId(this.serviceInfoProvider.getServiceId());
                        queueStats = this.queueStatsService.save(tenantId, queueStats);
                    }
                    queueStatsId = (QueueStatsId)queueStats.getId();
                    this.tenantQueueStats.put(key, queueStatsId);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return queueStatsId;
    }

    @ConstructorProperties(value={"serviceInfoProvider", "tsService", "queueStatsService", "apiLimitService"})
    @Generated
    public DefaultRuleEngineStatisticsService(TbServiceInfoProvider serviceInfoProvider, TelemetrySubscriptionService tsService, QueueStatsService queueStatsService, ApiLimitService apiLimitService) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.tsService = tsService;
        this.queueStatsService = queueStatsService;
        this.apiLimitService = apiLimitService;
    }
}

