/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.solution;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityGroupId;

@Schema
public class TenantSolutionTemplateInstructions {
    @Schema(description="Id of the group that contains main dashboard of the solution")
    private EntityGroupId dashboardGroupId;
    @Schema(description="Id of the main dashboard of the solution")
    private DashboardId dashboardId;
    @Schema(description="Id of the public customer if solution has public entities")
    private CustomerId publicId;
    @Schema(description="Is the main dashboard public")
    private boolean mainDashboardPublic;
    @Schema(description="Markdown with solution usage instructions")
    private String details;

    public TenantSolutionTemplateInstructions(TenantSolutionTemplateInstructions instructions) {
        this.dashboardGroupId = instructions.getDashboardGroupId();
        this.dashboardId = instructions.getDashboardId();
        this.publicId = instructions.getPublicId();
        this.mainDashboardPublic = instructions.isMainDashboardPublic();
        this.details = instructions.getDetails();
    }

    @Generated
    public EntityGroupId getDashboardGroupId() {
        return this.dashboardGroupId;
    }

    @Generated
    public DashboardId getDashboardId() {
        return this.dashboardId;
    }

    @Generated
    public CustomerId getPublicId() {
        return this.publicId;
    }

    @Generated
    public boolean isMainDashboardPublic() {
        return this.mainDashboardPublic;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }

    @Generated
    public void setDashboardGroupId(EntityGroupId dashboardGroupId) {
        this.dashboardGroupId = dashboardGroupId;
    }

    @Generated
    public void setDashboardId(DashboardId dashboardId) {
        this.dashboardId = dashboardId;
    }

    @Generated
    public void setPublicId(CustomerId publicId) {
        this.publicId = publicId;
    }

    @Generated
    public void setMainDashboardPublic(boolean mainDashboardPublic) {
        this.mainDashboardPublic = mainDashboardPublic;
    }

    @Generated
    public void setDetails(String details) {
        this.details = details;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantSolutionTemplateInstructions)) {
            return false;
        }
        TenantSolutionTemplateInstructions other = (TenantSolutionTemplateInstructions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isMainDashboardPublic() != other.isMainDashboardPublic()) {
            return false;
        }
        EntityGroupId this$dashboardGroupId = this.getDashboardGroupId();
        EntityGroupId other$dashboardGroupId = other.getDashboardGroupId();
        if (this$dashboardGroupId == null ? other$dashboardGroupId != null : !this$dashboardGroupId.equals(other$dashboardGroupId)) {
            return false;
        }
        DashboardId this$dashboardId = this.getDashboardId();
        DashboardId other$dashboardId = other.getDashboardId();
        if (this$dashboardId == null ? other$dashboardId != null : !this$dashboardId.equals(other$dashboardId)) {
            return false;
        }
        CustomerId this$publicId = this.getPublicId();
        CustomerId other$publicId = other.getPublicId();
        if (this$publicId == null ? other$publicId != null : !this$publicId.equals(other$publicId)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TenantSolutionTemplateInstructions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMainDashboardPublic() ? 79 : 97);
        EntityGroupId $dashboardGroupId = this.getDashboardGroupId();
        result = result * 59 + ($dashboardGroupId == null ? 43 : $dashboardGroupId.hashCode());
        DashboardId $dashboardId = this.getDashboardId();
        result = result * 59 + ($dashboardId == null ? 43 : $dashboardId.hashCode());
        CustomerId $publicId = this.getPublicId();
        result = result * 59 + ($publicId == null ? 43 : $publicId.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TenantSolutionTemplateInstructions(dashboardGroupId=" + String.valueOf(this.getDashboardGroupId()) + ", dashboardId=" + String.valueOf(this.getDashboardId()) + ", publicId=" + String.valueOf(this.getPublicId()) + ", mainDashboardPublic=" + this.isMainDashboardPublic() + ", details=" + this.getDetails() + ")";
    }

    @ConstructorProperties(value={"dashboardGroupId", "dashboardId", "publicId", "mainDashboardPublic", "details"})
    @Generated
    public TenantSolutionTemplateInstructions(EntityGroupId dashboardGroupId, DashboardId dashboardId, CustomerId publicId, boolean mainDashboardPublic, String details) {
        this.dashboardGroupId = dashboardGroupId;
        this.dashboardId = dashboardId;
        this.publicId = publicId;
        this.mainDashboardPublic = mainDashboardPublic;
        this.details = details;
    }

    @Generated
    public TenantSolutionTemplateInstructions() {
    }
}

