/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.service.solutions.data.SolutionInstallContext;
import org.thingsboard.server.service.solutions.data.definition.TelemetryProfile;

public class EmulatorDefinition {
    private String name;
    private String extendz;
    private String clazz;
    private int publishPeriodInDays;
    private int publishFrequencyInSeconds;
    private int publishPauseInMillis;
    private long activityPeriodInMillis;
    private List<TelemetryProfile> telemetryProfiles = Collections.emptyList();

    public void enrich(EmulatorDefinition parent) {
        if (StringUtils.isEmpty((String)this.clazz)) {
            this.clazz = parent.getClazz();
        }
        if (this.publishPeriodInDays == 0) {
            this.publishPeriodInDays = parent.getPublishPeriodInDays();
        }
        if (this.publishFrequencyInSeconds == 0) {
            this.publishFrequencyInSeconds = parent.getPublishFrequencyInSeconds();
        }
        if (this.publishPauseInMillis == 0) {
            this.publishPauseInMillis = parent.getPublishPauseInMillis();
        }
        if (this.activityPeriodInMillis == 0L) {
            this.activityPeriodInMillis = parent.getActivityPeriodInMillis();
        }
        Map profilesMap = this.telemetryProfiles.stream().collect(Collectors.toMap(TelemetryProfile::getKey, Function.identity()));
        parent.getTelemetryProfiles().forEach(tp -> profilesMap.putIfAbsent(tp.getKey(), tp));
        this.telemetryProfiles = new ArrayList(profilesMap.values());
    }

    public long getOldestTs(SolutionInstallContext ctx) {
        return this.getOldestTs(ctx.getInstallTs());
    }

    public long getOldestTs(long startTs) {
        return startTs - TimeUnit.DAYS.toMillis(this.publishPeriodInDays) - (long)this.publishFrequencyInSeconds;
    }

    @Generated
    public EmulatorDefinition() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getExtendz() {
        return this.extendz;
    }

    @Generated
    public String getClazz() {
        return this.clazz;
    }

    @Generated
    public int getPublishPeriodInDays() {
        return this.publishPeriodInDays;
    }

    @Generated
    public int getPublishFrequencyInSeconds() {
        return this.publishFrequencyInSeconds;
    }

    @Generated
    public int getPublishPauseInMillis() {
        return this.publishPauseInMillis;
    }

    @Generated
    public long getActivityPeriodInMillis() {
        return this.activityPeriodInMillis;
    }

    @Generated
    public List<TelemetryProfile> getTelemetryProfiles() {
        return this.telemetryProfiles;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setExtendz(String extendz) {
        this.extendz = extendz;
    }

    @Generated
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Generated
    public void setPublishPeriodInDays(int publishPeriodInDays) {
        this.publishPeriodInDays = publishPeriodInDays;
    }

    @Generated
    public void setPublishFrequencyInSeconds(int publishFrequencyInSeconds) {
        this.publishFrequencyInSeconds = publishFrequencyInSeconds;
    }

    @Generated
    public void setPublishPauseInMillis(int publishPauseInMillis) {
        this.publishPauseInMillis = publishPauseInMillis;
    }

    @Generated
    public void setActivityPeriodInMillis(long activityPeriodInMillis) {
        this.activityPeriodInMillis = activityPeriodInMillis;
    }

    @Generated
    public void setTelemetryProfiles(List<TelemetryProfile> telemetryProfiles) {
        this.telemetryProfiles = telemetryProfiles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmulatorDefinition)) {
            return false;
        }
        EmulatorDefinition other = (EmulatorDefinition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPublishPeriodInDays() != other.getPublishPeriodInDays()) {
            return false;
        }
        if (this.getPublishFrequencyInSeconds() != other.getPublishFrequencyInSeconds()) {
            return false;
        }
        if (this.getPublishPauseInMillis() != other.getPublishPauseInMillis()) {
            return false;
        }
        if (this.getActivityPeriodInMillis() != other.getActivityPeriodInMillis()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$extendz = this.getExtendz();
        String other$extendz = other.getExtendz();
        if (this$extendz == null ? other$extendz != null : !this$extendz.equals(other$extendz)) {
            return false;
        }
        String this$clazz = this.getClazz();
        String other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        List this$telemetryProfiles = this.getTelemetryProfiles();
        List other$telemetryProfiles = other.getTelemetryProfiles();
        return !(this$telemetryProfiles == null ? other$telemetryProfiles != null : !((Object)this$telemetryProfiles).equals(other$telemetryProfiles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmulatorDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPublishPeriodInDays();
        result = result * 59 + this.getPublishFrequencyInSeconds();
        result = result * 59 + this.getPublishPauseInMillis();
        long $activityPeriodInMillis = this.getActivityPeriodInMillis();
        result = result * 59 + (int)($activityPeriodInMillis >>> 32 ^ $activityPeriodInMillis);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $extendz = this.getExtendz();
        result = result * 59 + ($extendz == null ? 43 : $extendz.hashCode());
        String $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        List $telemetryProfiles = this.getTelemetryProfiles();
        result = result * 59 + ($telemetryProfiles == null ? 43 : ((Object)$telemetryProfiles).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmulatorDefinition(name=" + this.getName() + ", extendz=" + this.getExtendz() + ", clazz=" + this.getClazz() + ", publishPeriodInDays=" + this.getPublishPeriodInDays() + ", publishFrequencyInSeconds=" + this.getPublishFrequencyInSeconds() + ", publishPauseInMillis=" + this.getPublishPauseInMillis() + ", activityPeriodInMillis=" + this.getActivityPeriodInMillis() + ", telemetryProfiles=" + String.valueOf(this.getTelemetryProfiles()) + ")";
    }
}

