/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.service.solutions.data.CreatedAlarmRuleInfo;
import org.thingsboard.server.service.solutions.data.CreatedCalculatedFieldInfo;
import org.thingsboard.server.service.solutions.data.CreatedEntityInfo;
import org.thingsboard.server.service.solutions.data.CreatedRuleChainInfo;
import org.thingsboard.server.service.solutions.data.DashboardLinkInfo;
import org.thingsboard.server.service.solutions.data.DeviceCredentialsInfo;
import org.thingsboard.server.service.solutions.data.EdgeLinkInfo;
import org.thingsboard.server.service.solutions.data.UserCredentialsInfo;
import org.thingsboard.server.service.solutions.data.definition.AssetDefinition;
import org.thingsboard.server.service.solutions.data.definition.AssetProfileDefinition;
import org.thingsboard.server.service.solutions.data.definition.CustomerDefinition;
import org.thingsboard.server.service.solutions.data.definition.DashboardDefinition;
import org.thingsboard.server.service.solutions.data.definition.DeviceDefinition;
import org.thingsboard.server.service.solutions.data.definition.DeviceProfileDefinition;
import org.thingsboard.server.service.solutions.data.definition.EdgeDefinition;
import org.thingsboard.server.service.solutions.data.definition.EmulatorDefinition;
import org.thingsboard.server.service.solutions.data.definition.EntityDefinition;
import org.thingsboard.server.service.solutions.data.definition.EntitySearchKey;
import org.thingsboard.server.service.solutions.data.definition.RelationDefinition;
import org.thingsboard.server.service.solutions.data.definition.SchedulerEventDefinition;
import org.thingsboard.server.service.solutions.data.definition.UserDefinition;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInstructions;

public class SolutionInstallContext {
    private final TenantId tenantId;
    private final String solutionId;
    private final User user;
    private final TenantSolutionTemplateInstructions solutionInstructions;
    private final List<EntityId> createdEntitiesList = new ArrayList();
    private final Map<String, String> realIds = new HashMap();
    private final Map<EntitySearchKey, EntityId> entityIdMap = new HashMap();
    private final Map<EntityId, List<RelationDefinition>> relationDefinitions = new LinkedHashMap();
    private final Map<String, DeviceCredentialsInfo> createdDevices = new LinkedHashMap();
    private final Map<String, UserCredentialsInfo> createdUsers = new LinkedHashMap();
    private final Map<UUID, CreatedEntityInfo> createdEntities = new LinkedHashMap();
    private final Map<UUID, CreatedAlarmRuleInfo> createdAlarmRules = new LinkedHashMap();
    private final Map<UUID, CreatedCalculatedFieldInfo> createdCalculatedFields = new LinkedHashMap();
    private final List<DashboardLinkInfo> dashboardLinks = new ArrayList();
    private final Map<String, EdgeLinkInfo> createdEdges = new LinkedHashMap();
    private final long installTs;
    private long oldestTelemetryTs;
    private Map<String, EmulatorDefinition> deviceEmulators;
    private Map<String, EmulatorDefinition> assetEmulators;

    public SolutionInstallContext(TenantId tenantId, String solutionId, User user, TenantSolutionTemplateInstructions solutionInstructions) {
        this.tenantId = tenantId;
        this.solutionId = solutionId;
        this.user = user;
        this.solutionInstructions = solutionInstructions;
        this.put(new EntitySearchKey((EntityId)tenantId, EntityType.TENANT, null, false), (EntityId)tenantId);
        this.installTs = System.currentTimeMillis();
    }

    public void registerReferenceOnly(String referenceId, EntityId entityId) {
        if (!StringUtils.isEmpty((String)referenceId)) {
            this.realIds.put(referenceId, entityId.getId().toString());
        }
    }

    public void register(String referenceId, EntityId entityId) {
        this.registerReferenceOnly(referenceId, entityId);
        this.register(entityId);
    }

    public void register(EntityId entityId) {
        this.createdEntitiesList.add(entityId);
    }

    public void register(CustomerDefinition definition, Customer customer) {
        this.register(definition.getJsonId(), (EntityId)customer.getId());
        this.createdEntities.put(customer.getUuidId(), new CreatedEntityInfo(customer.getName(), EntityType.CUSTOMER, "Tenant"));
    }

    public void register(CustomerDefinition cDef, UserDefinition definition, User user) {
        this.register(definition.getJsonId(), (EntityId)user.getId());
        this.createdEntities.put(user.getUuidId(), new CreatedEntityInfo(user.getName(), EntityType.USER, StringUtils.isEmpty((String)cDef.getName()) ? "Tenant" : cDef.getName()));
    }

    public void register(AssetDefinition definition, Asset asset) {
        this.register(definition.getJsonId(), (EntityId)asset.getId());
        this.createdEntities.put(asset.getUuidId(), new CreatedEntityInfo(asset.getName(), EntityType.ASSET, StringUtils.isEmpty((String)definition.getCustomer()) ? "Tenant" : definition.getCustomer()));
    }

    public void register(DeviceDefinition definition, Device device) {
        this.register(definition.getJsonId(), (EntityId)device.getId());
        this.createdEntities.put(device.getUuidId(), new CreatedEntityInfo(device.getName(), EntityType.DEVICE, StringUtils.isEmpty((String)definition.getCustomer()) ? "Tenant" : definition.getCustomer()));
    }

    public void register(DashboardDefinition definition, Dashboard dashboard) {
        this.register(definition.getJsonId(), (EntityId)dashboard.getId());
        this.createdEntities.put(dashboard.getUuidId(), new CreatedEntityInfo(dashboard.getName(), EntityType.DASHBOARD, StringUtils.isEmpty((String)definition.getCustomer()) ? "Tenant" : definition.getCustomer()));
    }

    public void register(String referenceId, RuleChain ruleChain) {
        this.register(referenceId, (EntityId)ruleChain.getId());
        this.createdEntities.put(ruleChain.getUuidId(), new CreatedRuleChainInfo(ruleChain.getName(), ruleChain.getType(), "Tenant"));
    }

    public void register(Role role) {
        this.register((EntityId)role.getId());
        this.createdEntities.put(role.getUuidId(), new CreatedEntityInfo(role.getName(), EntityType.ROLE, "Tenant"));
    }

    public void register(DeviceProfileDefinition definition, DeviceProfile deviceProfile) {
        this.register(definition.getJsonId(), (EntityId)deviceProfile.getId());
        this.createdEntities.put(deviceProfile.getUuidId(), new CreatedEntityInfo(deviceProfile.getName(), EntityType.DEVICE_PROFILE, "Tenant"));
    }

    public void register(AssetProfileDefinition definition, AssetProfile assetProfile) {
        this.register(definition.getJsonId(), (EntityId)assetProfile.getId());
        this.createdEntities.put(assetProfile.getUuidId(), new CreatedEntityInfo(assetProfile.getName(), EntityType.ASSET_PROFILE, "Tenant"));
    }

    public void register(EdgeDefinition definition, Edge edge) {
        this.register(definition.getJsonId(), (EntityId)edge.getId());
        this.createdEntities.put(edge.getUuidId(), new CreatedEntityInfo(edge.getName(), EntityType.EDGE, StringUtils.isEmpty((String)definition.getCustomer()) ? "Tenant" : definition.getCustomer()));
    }

    public void register(SchedulerEventDefinition definition, SchedulerEvent schedulerEvent) {
        this.register(definition.getJsonId(), (EntityId)schedulerEvent.getId());
    }

    public void register(CalculatedField calculatedField) {
        boolean alarmRule;
        this.register((EntityId)calculatedField.getId());
        EntityId entityId = calculatedField.getEntityId();
        CreatedEntityInfo entityInfo = (CreatedEntityInfo)this.createdEntities.get(entityId.getId());
        boolean bl = alarmRule = calculatedField.getType() == CalculatedFieldType.ALARM;
        if (entityInfo == null) {
            String target = alarmRule ? "Alarm rule" : "Calculated field";
            throw new IllegalStateException("Failed to register " + target + " with name: " + calculatedField.getName() + " for non-existing entity with id: " + String.valueOf(entityId));
        }
        if (alarmRule) {
            this.createdAlarmRules.put(calculatedField.getUuidId(), CreatedAlarmRuleInfo.from((EntityId)entityId, (String)entityInfo.getName(), (CalculatedField)calculatedField));
            return;
        }
        this.createdCalculatedFields.put(calculatedField.getUuidId(), CreatedCalculatedFieldInfo.from((EntityId)entityId, (String)entityInfo.getName(), (CalculatedField)calculatedField));
    }

    public void put(EntitySearchKey entitySearchKey, EntityId entityId) {
        this.entityIdMap.put(entitySearchKey, entityId);
    }

    public void putIdToMap(EntityDefinition entityDefinition, EntityId entityId) {
        this.putIdToMap(entityDefinition.getEntityType(), entityDefinition.getName(), entityId);
    }

    public void putIdToMap(EntityType entityType, String entityName, EntityId entityId) {
        this.putIdToMap((EntityId)this.tenantId, entityType, entityName, entityId);
    }

    public void putIdToMap(EntityId ownerId, EntityType entityType, String entityName, EntityId entityId) {
        this.entityIdMap.put(new EntitySearchKey(ownerId, entityType, entityName, EntityType.ENTITY_GROUP.equals((Object)entityId.getEntityType())), entityId);
    }

    public <T extends EntityId> T getIdFromMap(EntityType entityType, String entityName) {
        return (T)((EntityId)this.entityIdMap.get(new EntitySearchKey((EntityId)this.tenantId, entityType, entityName, false)));
    }

    public <T extends EntityId> T getGroupIdFromMap(EntityType entityType, String entityName) {
        return (T)this.getGroupIdFromMap((EntityId)this.tenantId, entityType, entityName);
    }

    public <T extends EntityId> T getGroupIdFromMap(EntityId ownerId, EntityType entityType, String entityName) {
        return (T)((EntityId)this.entityIdMap.get(new EntitySearchKey(ownerId, entityType, entityName, true)));
    }

    public void put(EntityId entityId, List<RelationDefinition> relations) {
        this.relationDefinitions.put(entityId, relations);
    }

    public void addDeviceCredentials(DeviceCredentialsInfo deviceCredentialsInfo) {
        this.createdDevices.put(deviceCredentialsInfo.getName(), deviceCredentialsInfo);
    }

    public void addUserCredentials(UserCredentialsInfo userCredentialsInfo) {
        this.createdUsers.put(userCredentialsInfo.getName(), userCredentialsInfo);
    }

    public void addEdgeLinkInfo(String edgeName, EdgeLinkInfo edgeLinkInfo) {
        this.createdEdges.put(edgeName, edgeLinkInfo);
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getSolutionId() {
        return this.solutionId;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public TenantSolutionTemplateInstructions getSolutionInstructions() {
        return this.solutionInstructions;
    }

    @Generated
    public List<EntityId> getCreatedEntitiesList() {
        return this.createdEntitiesList;
    }

    @Generated
    public Map<String, String> getRealIds() {
        return this.realIds;
    }

    @Generated
    public Map<EntitySearchKey, EntityId> getEntityIdMap() {
        return this.entityIdMap;
    }

    @Generated
    public Map<EntityId, List<RelationDefinition>> getRelationDefinitions() {
        return this.relationDefinitions;
    }

    @Generated
    public Map<String, DeviceCredentialsInfo> getCreatedDevices() {
        return this.createdDevices;
    }

    @Generated
    public Map<String, UserCredentialsInfo> getCreatedUsers() {
        return this.createdUsers;
    }

    @Generated
    public Map<UUID, CreatedEntityInfo> getCreatedEntities() {
        return this.createdEntities;
    }

    @Generated
    public Map<UUID, CreatedAlarmRuleInfo> getCreatedAlarmRules() {
        return this.createdAlarmRules;
    }

    @Generated
    public Map<UUID, CreatedCalculatedFieldInfo> getCreatedCalculatedFields() {
        return this.createdCalculatedFields;
    }

    @Generated
    public List<DashboardLinkInfo> getDashboardLinks() {
        return this.dashboardLinks;
    }

    @Generated
    public Map<String, EdgeLinkInfo> getCreatedEdges() {
        return this.createdEdges;
    }

    @Generated
    public long getInstallTs() {
        return this.installTs;
    }

    @Generated
    public long getOldestTelemetryTs() {
        return this.oldestTelemetryTs;
    }

    @Generated
    public Map<String, EmulatorDefinition> getDeviceEmulators() {
        return this.deviceEmulators;
    }

    @Generated
    public Map<String, EmulatorDefinition> getAssetEmulators() {
        return this.assetEmulators;
    }

    @Generated
    public void setOldestTelemetryTs(long oldestTelemetryTs) {
        this.oldestTelemetryTs = oldestTelemetryTs;
    }

    @Generated
    public void setDeviceEmulators(Map<String, EmulatorDefinition> deviceEmulators) {
        this.deviceEmulators = deviceEmulators;
    }

    @Generated
    public void setAssetEmulators(Map<String, EmulatorDefinition> assetEmulators) {
        this.assetEmulators = assetEmulators;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolutionInstallContext)) {
            return false;
        }
        SolutionInstallContext other = (SolutionInstallContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getInstallTs() != other.getInstallTs()) {
            return false;
        }
        if (this.getOldestTelemetryTs() != other.getOldestTelemetryTs()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$solutionId = this.getSolutionId();
        String other$solutionId = other.getSolutionId();
        if (this$solutionId == null ? other$solutionId != null : !this$solutionId.equals(other$solutionId)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        TenantSolutionTemplateInstructions this$solutionInstructions = this.getSolutionInstructions();
        TenantSolutionTemplateInstructions other$solutionInstructions = other.getSolutionInstructions();
        if (this$solutionInstructions == null ? other$solutionInstructions != null : !this$solutionInstructions.equals(other$solutionInstructions)) {
            return false;
        }
        List this$createdEntitiesList = this.getCreatedEntitiesList();
        List other$createdEntitiesList = other.getCreatedEntitiesList();
        if (this$createdEntitiesList == null ? other$createdEntitiesList != null : !((Object)this$createdEntitiesList).equals(other$createdEntitiesList)) {
            return false;
        }
        Map this$realIds = this.getRealIds();
        Map other$realIds = other.getRealIds();
        if (this$realIds == null ? other$realIds != null : !((Object)this$realIds).equals(other$realIds)) {
            return false;
        }
        Map this$entityIdMap = this.getEntityIdMap();
        Map other$entityIdMap = other.getEntityIdMap();
        if (this$entityIdMap == null ? other$entityIdMap != null : !((Object)this$entityIdMap).equals(other$entityIdMap)) {
            return false;
        }
        Map this$relationDefinitions = this.getRelationDefinitions();
        Map other$relationDefinitions = other.getRelationDefinitions();
        if (this$relationDefinitions == null ? other$relationDefinitions != null : !((Object)this$relationDefinitions).equals(other$relationDefinitions)) {
            return false;
        }
        Map this$createdDevices = this.getCreatedDevices();
        Map other$createdDevices = other.getCreatedDevices();
        if (this$createdDevices == null ? other$createdDevices != null : !((Object)this$createdDevices).equals(other$createdDevices)) {
            return false;
        }
        Map this$createdUsers = this.getCreatedUsers();
        Map other$createdUsers = other.getCreatedUsers();
        if (this$createdUsers == null ? other$createdUsers != null : !((Object)this$createdUsers).equals(other$createdUsers)) {
            return false;
        }
        Map this$createdEntities = this.getCreatedEntities();
        Map other$createdEntities = other.getCreatedEntities();
        if (this$createdEntities == null ? other$createdEntities != null : !((Object)this$createdEntities).equals(other$createdEntities)) {
            return false;
        }
        Map this$createdAlarmRules = this.getCreatedAlarmRules();
        Map other$createdAlarmRules = other.getCreatedAlarmRules();
        if (this$createdAlarmRules == null ? other$createdAlarmRules != null : !((Object)this$createdAlarmRules).equals(other$createdAlarmRules)) {
            return false;
        }
        Map this$createdCalculatedFields = this.getCreatedCalculatedFields();
        Map other$createdCalculatedFields = other.getCreatedCalculatedFields();
        if (this$createdCalculatedFields == null ? other$createdCalculatedFields != null : !((Object)this$createdCalculatedFields).equals(other$createdCalculatedFields)) {
            return false;
        }
        List this$dashboardLinks = this.getDashboardLinks();
        List other$dashboardLinks = other.getDashboardLinks();
        if (this$dashboardLinks == null ? other$dashboardLinks != null : !((Object)this$dashboardLinks).equals(other$dashboardLinks)) {
            return false;
        }
        Map this$createdEdges = this.getCreatedEdges();
        Map other$createdEdges = other.getCreatedEdges();
        if (this$createdEdges == null ? other$createdEdges != null : !((Object)this$createdEdges).equals(other$createdEdges)) {
            return false;
        }
        Map this$deviceEmulators = this.getDeviceEmulators();
        Map other$deviceEmulators = other.getDeviceEmulators();
        if (this$deviceEmulators == null ? other$deviceEmulators != null : !((Object)this$deviceEmulators).equals(other$deviceEmulators)) {
            return false;
        }
        Map this$assetEmulators = this.getAssetEmulators();
        Map other$assetEmulators = other.getAssetEmulators();
        return !(this$assetEmulators == null ? other$assetEmulators != null : !((Object)this$assetEmulators).equals(other$assetEmulators));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolutionInstallContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $installTs = this.getInstallTs();
        result = result * 59 + (int)($installTs >>> 32 ^ $installTs);
        long $oldestTelemetryTs = this.getOldestTelemetryTs();
        result = result * 59 + (int)($oldestTelemetryTs >>> 32 ^ $oldestTelemetryTs);
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $solutionId = this.getSolutionId();
        result = result * 59 + ($solutionId == null ? 43 : $solutionId.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        TenantSolutionTemplateInstructions $solutionInstructions = this.getSolutionInstructions();
        result = result * 59 + ($solutionInstructions == null ? 43 : $solutionInstructions.hashCode());
        List $createdEntitiesList = this.getCreatedEntitiesList();
        result = result * 59 + ($createdEntitiesList == null ? 43 : ((Object)$createdEntitiesList).hashCode());
        Map $realIds = this.getRealIds();
        result = result * 59 + ($realIds == null ? 43 : ((Object)$realIds).hashCode());
        Map $entityIdMap = this.getEntityIdMap();
        result = result * 59 + ($entityIdMap == null ? 43 : ((Object)$entityIdMap).hashCode());
        Map $relationDefinitions = this.getRelationDefinitions();
        result = result * 59 + ($relationDefinitions == null ? 43 : ((Object)$relationDefinitions).hashCode());
        Map $createdDevices = this.getCreatedDevices();
        result = result * 59 + ($createdDevices == null ? 43 : ((Object)$createdDevices).hashCode());
        Map $createdUsers = this.getCreatedUsers();
        result = result * 59 + ($createdUsers == null ? 43 : ((Object)$createdUsers).hashCode());
        Map $createdEntities = this.getCreatedEntities();
        result = result * 59 + ($createdEntities == null ? 43 : ((Object)$createdEntities).hashCode());
        Map $createdAlarmRules = this.getCreatedAlarmRules();
        result = result * 59 + ($createdAlarmRules == null ? 43 : ((Object)$createdAlarmRules).hashCode());
        Map $createdCalculatedFields = this.getCreatedCalculatedFields();
        result = result * 59 + ($createdCalculatedFields == null ? 43 : ((Object)$createdCalculatedFields).hashCode());
        List $dashboardLinks = this.getDashboardLinks();
        result = result * 59 + ($dashboardLinks == null ? 43 : ((Object)$dashboardLinks).hashCode());
        Map $createdEdges = this.getCreatedEdges();
        result = result * 59 + ($createdEdges == null ? 43 : ((Object)$createdEdges).hashCode());
        Map $deviceEmulators = this.getDeviceEmulators();
        result = result * 59 + ($deviceEmulators == null ? 43 : ((Object)$deviceEmulators).hashCode());
        Map $assetEmulators = this.getAssetEmulators();
        result = result * 59 + ($assetEmulators == null ? 43 : ((Object)$assetEmulators).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolutionInstallContext(tenantId=" + String.valueOf(this.getTenantId()) + ", solutionId=" + this.getSolutionId() + ", user=" + String.valueOf(this.getUser()) + ", solutionInstructions=" + String.valueOf(this.getSolutionInstructions()) + ", createdEntitiesList=" + String.valueOf(this.getCreatedEntitiesList()) + ", realIds=" + String.valueOf(this.getRealIds()) + ", entityIdMap=" + String.valueOf(this.getEntityIdMap()) + ", relationDefinitions=" + String.valueOf(this.getRelationDefinitions()) + ", createdDevices=" + String.valueOf(this.getCreatedDevices()) + ", createdUsers=" + String.valueOf(this.getCreatedUsers()) + ", createdEntities=" + String.valueOf(this.getCreatedEntities()) + ", createdAlarmRules=" + String.valueOf(this.getCreatedAlarmRules()) + ", createdCalculatedFields=" + String.valueOf(this.getCreatedCalculatedFields()) + ", dashboardLinks=" + String.valueOf(this.getDashboardLinks()) + ", createdEdges=" + String.valueOf(this.getCreatedEdges()) + ", installTs=" + this.getInstallTs() + ", oldestTelemetryTs=" + this.getOldestTelemetryTs() + ", deviceEmulators=" + String.valueOf(this.getDeviceEmulators()) + ", assetEmulators=" + String.valueOf(this.getAssetEmulators()) + ")";
    }
}

