/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.solutions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmQuery;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.configuration.ArgumentsBasedCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RoleId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.SchedulerEventId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.job.task.CfReprocessingTask;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseDeleteTsKvQuery;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.scheduler.SchedulerEvent;
import org.thingsboard.server.common.data.scheduler.SchedulerEventInfo;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.common.data.subscription.SubscriptionErrorCode;
import org.thingsboard.server.common.data.subscription.SubscriptionException;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.dao.asset.AssetProfileService;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.dashboard.DashboardService;
import org.thingsboard.server.dao.device.DeviceConnectivityService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.DockerComposeParams;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.dao.scheduler.SchedulerEventService;
import org.thingsboard.server.dao.subscription.SubscriptionService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.user.UserService;
import org.thingsboard.server.exception.EntitiesLimitExceededException;
import org.thingsboard.server.exception.ThingsboardRuntimeException;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.action.EntityActionService;
import org.thingsboard.server.service.cf.CalculatedFieldReprocessingService;
import org.thingsboard.server.service.entitiy.asset.TbAssetService;
import org.thingsboard.server.service.entitiy.cf.TbCalculatedFieldService;
import org.thingsboard.server.service.entitiy.device.TbDeviceService;
import org.thingsboard.server.service.entitiy.edge.TbEdgeService;
import org.thingsboard.server.service.entitiy.entity.group.TbEntityGroupService;
import org.thingsboard.server.service.entitiy.entity.relation.TbEntityRelationService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.rule.TbRuleChainService;
import org.thingsboard.server.service.scheduler.SchedulerService;
import org.thingsboard.server.service.security.system.SystemSecurityService;
import org.thingsboard.server.service.solutions.DefaultSolutionService;
import org.thingsboard.server.service.solutions.SolutionService;
import org.thingsboard.server.service.solutions.data.CreatedAlarmRuleInfo;
import org.thingsboard.server.service.solutions.data.CreatedCalculatedFieldInfo;
import org.thingsboard.server.service.solutions.data.CreatedEntityInfo;
import org.thingsboard.server.service.solutions.data.DashboardLinkInfo;
import org.thingsboard.server.service.solutions.data.DeviceCredentialsInfo;
import org.thingsboard.server.service.solutions.data.EdgeLinkInfo;
import org.thingsboard.server.service.solutions.data.SolutionInstallContext;
import org.thingsboard.server.service.solutions.data.UserCredentialsInfo;
import org.thingsboard.server.service.solutions.data.definition.AssetDefinition;
import org.thingsboard.server.service.solutions.data.definition.AssetProfileDefinition;
import org.thingsboard.server.service.solutions.data.definition.CalculatedFieldDefinition;
import org.thingsboard.server.service.solutions.data.definition.CustomerDefinition;
import org.thingsboard.server.service.solutions.data.definition.CustomerEntityDefinition;
import org.thingsboard.server.service.solutions.data.definition.DashboardDefinition;
import org.thingsboard.server.service.solutions.data.definition.DashboardUserDetailsDefinition;
import org.thingsboard.server.service.solutions.data.definition.DeviceDefinition;
import org.thingsboard.server.service.solutions.data.definition.DeviceProfileDefinition;
import org.thingsboard.server.service.solutions.data.definition.EdgeDefinition;
import org.thingsboard.server.service.solutions.data.definition.EdgeEntityGroupDefinition;
import org.thingsboard.server.service.solutions.data.definition.EmulatorDefinition;
import org.thingsboard.server.service.solutions.data.definition.EntityDefinition;
import org.thingsboard.server.service.solutions.data.definition.GroupRoleDefinition;
import org.thingsboard.server.service.solutions.data.definition.ReferenceableEntityDefinition;
import org.thingsboard.server.service.solutions.data.definition.RelationDefinition;
import org.thingsboard.server.service.solutions.data.definition.RoleDefinition;
import org.thingsboard.server.service.solutions.data.definition.SchedulerEventDefinition;
import org.thingsboard.server.service.solutions.data.definition.TenantDefinition;
import org.thingsboard.server.service.solutions.data.definition.UserDefinition;
import org.thingsboard.server.service.solutions.data.definition.UserGroupDefinition;
import org.thingsboard.server.service.solutions.data.emulator.AssetEmulatorLauncher;
import org.thingsboard.server.service.solutions.data.emulator.DeviceEmulatorLauncher;
import org.thingsboard.server.service.solutions.data.names.RandomNameData;
import org.thingsboard.server.service.solutions.data.names.RandomNameUtil;
import org.thingsboard.server.service.solutions.data.solution.SolutionDescriptor;
import org.thingsboard.server.service.solutions.data.solution.SolutionInstallResponse;
import org.thingsboard.server.service.solutions.data.solution.SolutionTemplate;
import org.thingsboard.server.service.solutions.data.solution.SolutionTemplateDetails;
import org.thingsboard.server.service.solutions.data.solution.SolutionTemplateInfo;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateDetails;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInfo;
import org.thingsboard.server.service.solutions.data.solution.TenantSolutionTemplateInstructions;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

/*
 * Exception performing whole class analysis ignored.
 */
@TbCoreComponent
@Service
public class DefaultSolutionService
implements SolutionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSolutionService.class);
    public static final String SOLUTIONS_DIR = "solutions";
    @Value(value="${ui.solution_templates.docs_base_url:https://thingsboard.io/docs/pe}")
    private String docsBaseUrl;
    private final List<SolutionTemplateInfo> solutions = new ArrayList();
    private final Map<String, SolutionTemplateDetails> solutionsMap = new HashMap();
    private final InstallScripts installScripts;
    private final DeviceProfileService deviceProfileService;
    private final AssetProfileService assetProfileService;
    private final TbRuleChainService tbRuleChainService;
    private final RuleChainService ruleChainService;
    private final AttributesService attributesService;
    private final TimeseriesService tsService;
    private final DashboardService dashboardService;
    private final TbEntityRelationService relationService;
    private final DeviceService deviceService;
    private final TbDeviceService tbDeviceService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final AssetService assetService;
    private final TbAssetService tbAssetService;
    private final CustomerService customerService;
    private final UserService userService;
    private final CalculatedFieldService calculatedFieldService;
    private final TbCalculatedFieldService tbCalculatedFieldService;
    private final CalculatedFieldReprocessingService calculatedFieldReprocessingService;
    private final TbEdgeService tbEdgeService;
    private final EntityGroupService entityGroupService;
    private final TbEntityGroupService tbEntityGroupService;
    private final GroupPermissionService groupPermissionService;
    private final RoleService roleService;
    private final SystemSecurityService systemSecurityService;
    private final TbClusterService tbClusterService;
    private final BCryptPasswordEncoder passwordEncoder;
    private final TbQueueProducerProvider tbQueueProducerProvider;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final PartitionService partitionService;
    private final TelemetrySubscriptionService tsSubService;
    private final EntityActionService entityActionService;
    private final AlarmService alarmService;
    private final SchedulerEventService schedulerEventService;
    private final SchedulerService schedulerService;
    private final DeviceConnectivityService deviceConnectivityService;
    private final ExecutorService emulatorExecutor = ThingsBoardExecutors.newWorkStealingPool((int)10, (String)"solution-emulators-executor");
    private final ExecutorService cfsReprocessingExecutor = ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)"solution-cfs-reprocessing-executor");
    private final SubscriptionService subscriptionService;

    @PostConstruct
    public void init() {
        Path solutionsDescriptorsFile = this.resolve("solutions.json", new String[0]);
        List descriptors = (List)JacksonUtil.readValue((File)solutionsDescriptorsFile.toFile(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (SolutionDescriptor descriptor : descriptors) {
            SolutionTemplateInfo templateInfo = new SolutionTemplateInfo();
            templateInfo.setId(descriptor.getId());
            templateInfo.setTitle(descriptor.getTitle());
            templateInfo.setLevel(descriptor.getLevel());
            templateInfo.setInstallTimeoutMs(descriptor.getInstallTimeoutMs());
            templateInfo.setPreviewImageUrl(descriptor.getPreviewImageUrl());
            templateInfo.setVideoPreviewImageUrl(descriptor.getVideoPreviewImageUrl());
            templateInfo.setPreviewMp4Url(descriptor.getPreviewMp4Url());
            templateInfo.setPreviewWebmUrl(descriptor.getPreviewWebmUrl());
            templateInfo.setTenantTelemetryKeys(descriptor.getTenantTelemetryKeys());
            templateInfo.setTenantAttributeKeys(descriptor.getTenantAttributeKeys());
            this.solutions.add(templateInfo);
            SolutionTemplateDetails templateDetails = new SolutionTemplateDetails();
            templateDetails.setId(descriptor.getId());
            templateDetails.setTitle(descriptor.getTitle());
            templateDetails.setLevel(descriptor.getLevel());
            templateDetails.setInstallTimeoutMs(descriptor.getInstallTimeoutMs());
            templateDetails.setHighlights(this.readFile(this.resolve(descriptor.getId(), new String[]{"highlights.md"})));
            templateDetails.setDescription(this.readFile(this.resolve(descriptor.getId(), new String[]{"description.md"})));
            templateDetails.setImageUrls(descriptor.getImageUrls());
            templateDetails.setTenantTelemetryKeys(descriptor.getTenantTelemetryKeys());
            templateDetails.setTenantAttributeKeys(descriptor.getTenantAttributeKeys());
            this.solutionsMap.put(descriptor.getId(), templateDetails);
        }
    }

    @PreDestroy
    private void destroy() {
        this.emulatorExecutor.shutdownNow();
    }

    private Path resolve(String subdir, String ... subdirs) {
        return this.getSolutionsDir().resolve(Paths.get(subdir, subdirs));
    }

    private Path getSolutionsDir() {
        return Paths.get(this.installScripts.getDataDir(), "json", "solutions");
    }

    private String readFile(Path file) {
        try {
            return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Failed to read file: {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public List<TenantSolutionTemplateInfo> getSolutionInfos(TenantId tenantId) throws ThingsboardException {
        try {
            List solutionIds = this.solutions.stream().map(SolutionTemplate::getId).collect(Collectors.toList());
            List stateList = (List)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, (Collection)solutionIds.stream().map(arg_0 -> this.toStatusKey(arg_0)).collect(Collectors.toList())).get();
            ArrayList<TenantSolutionTemplateInfo> result = new ArrayList<TenantSolutionTemplateInfo>();
            this.solutions.forEach(solution -> {
                boolean installed = stateList.stream().filter(attr -> attr.getKey().equals(this.toStatusKey(solution.getId())) && attr.getBooleanValue().isPresent()).map(attr -> (Boolean)attr.getBooleanValue().get()).findFirst().orElse(Boolean.FALSE);
                result.add(new TenantSolutionTemplateInfo(solution, installed));
            });
            return result;
        }
        catch (Exception e) {
            log.error("[{}] Failed to fetch solution list", (Object)tenantId, (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    public TenantSolutionTemplateDetails getSolutionDetails(TenantId tenantId, String id) throws ThingsboardException {
        try {
            SolutionTemplateDetails details = (SolutionTemplateDetails)this.solutionsMap.get(id);
            Optional state = (Optional)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, this.toStatusKey(id)).get();
            return new TenantSolutionTemplateDetails(details, state.isPresent() && ((AttributeKvEntry)state.get()).getBooleanValue().orElse(Boolean.FALSE) != false);
        }
        catch (Exception e) {
            log.error("[{}] Failed to fetch solution list", (Object)tenantId, (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    public TenantSolutionTemplateInstructions getSolutionInstructions(TenantId tenantId, String id) throws ThingsboardException {
        try {
            Optional state = (Optional)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, this.toInstructionsKey(id)).get();
            String body = (String)((AttributeKvEntry)state.orElseThrow(() -> new ThingsboardRuntimeException(ThingsboardErrorCode.ITEM_NOT_FOUND))).getStrValue().orElseThrow(() -> new ThingsboardRuntimeException(ThingsboardErrorCode.ITEM_NOT_FOUND));
            return (TenantSolutionTemplateInstructions)JacksonUtil.fromString((String)body, TenantSolutionTemplateInstructions.class);
        }
        catch (ThingsboardRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("[{}] Failed to fetch solution list", (Object)tenantId, (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    public SolutionInstallResponse installSolution(User user, TenantId tenantId, String solutionId, HttpServletRequest request) throws ThingsboardException {
        if (!this.solutionsMap.containsKey(solutionId)) {
            throw new ThingsboardException("Solution does not exist", ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        SolutionInstallResponse validateResult = this.validateSolution(tenantId, solutionId);
        if (validateResult != null && !validateResult.isSuccess()) {
            return validateResult;
        }
        return this.doInstallSolution(user, tenantId, solutionId, request);
    }

    public void deleteSolution(TenantId tenantId, String solutionId, User user) throws ThingsboardException {
        try {
            Optional entitiesOpt = (Optional)this.attributesService.find(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, this.toCreatedEntitiesKey(solutionId)).get();
            if (entitiesOpt.isPresent()) {
                String entitiesListSrc = ((AttributeKvEntry)entitiesOpt.get()).getValueAsString();
                ArrayList entityIds = new ArrayList(Objects.requireNonNull((List)JacksonUtil.fromString((String)entitiesListSrc, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)));
                Collections.reverse(entityIds);
                for (EntityId entityId : entityIds) {
                    try {
                        this.deleteEntity(tenantId, entityId, user);
                    }
                    catch (RuntimeException e) {
                        log.error("[{}][{}] Failed to delete the entity: {}", new Object[]{tenantId, solutionId, entityId, e});
                    }
                }
                this.attributesService.removeAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, Arrays.asList(this.toCreatedEntitiesKey(solutionId), this.toStatusKey(solutionId), this.toInstructionsKey(solutionId))).get();
                SolutionTemplateDetails solutionTemplate = (SolutionTemplateDetails)this.solutionsMap.get(solutionId);
                List tsKeys = solutionTemplate.getTenantTelemetryKeys();
                if (tsKeys != null && !tsKeys.isEmpty()) {
                    ArrayList<BaseDeleteTsKvQuery> queries = new ArrayList<BaseDeleteTsKvQuery>(tsKeys.size());
                    for (String tsKey : tsKeys) {
                        queries.add(new BaseDeleteTsKvQuery(tsKey, 0L, System.currentTimeMillis(), false));
                    }
                    this.tsService.remove(tenantId, (EntityId)tenantId, queries).get();
                }
                List attrKeys = solutionTemplate.getTenantAttributeKeys();
                if (tsKeys != null && !tsKeys.isEmpty()) {
                    this.attributesService.removeAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, attrKeys).get();
                }
            }
        }
        catch (Exception e) {
            log.error("[{}][{}] Failed to delete the solution", new Object[]{tenantId, solutionId, e});
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    private SolutionInstallResponse validateSolution(TenantId tenantId, String solutionId) {
        List dashboards;
        SolutionTemplateDetails solutionTemplate = (SolutionTemplateDetails)this.solutionsMap.get(solutionId);
        if (!this.subscriptionService.solutionTemplateLevelAllowed(tenantId, solutionTemplate.getLevel().name())) {
            ObjectNode value = JacksonUtil.newObjectNode();
            value.put("solutionTemplateName", solutionTemplate.getTitle());
            value.put("solutionTemplateLevel", solutionTemplate.getLevel().name());
            throw new SubscriptionException(String.format("Failed to install solution template '%s' - unsupported subscription plan", solutionTemplate.getTitle()), SubscriptionErrorCode.UNSUPPORTED_SOLUTION_TEMPLATE_PLAN, (JsonNode)value);
        }
        HashMap<EntityType, List> alreadyExistingEntities = new HashMap<EntityType, List>();
        List ruleChains = this.loadListOfEntitiesIfFileExists(solutionId, "rule_chains.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (!ruleChains.isEmpty()) {
            for (Object ruleChain : ruleChains) {
                List savedRuleChains = this.ruleChainService.findTenantRuleChainsByType(tenantId, RuleChainType.CORE, new PageLink(1, 0, ruleChain.getName())).getData();
                if (savedRuleChains == null || savedRuleChains.isEmpty()) continue;
                alreadyExistingEntities.computeIfAbsent(EntityType.RULE_CHAIN, key -> new ArrayList()).add((HasName)savedRuleChains.get(0));
            }
        }
        List deviceProfiles = this.loadListOfEntitiesIfFileExists(solutionId, "device_profiles.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        deviceProfiles.addAll(this.loadListOfEntitiesFromDirectory(solutionId, "device_profiles", DeviceProfileDefinition.class));
        if (!deviceProfiles.isEmpty()) {
            for (Object deviceProfile : deviceProfiles) {
                DeviceProfile savedProfile = this.deviceProfileService.findDeviceProfileByName(tenantId, deviceProfile.getName());
                if (savedProfile == null) continue;
                alreadyExistingEntities.computeIfAbsent(EntityType.DEVICE_PROFILE, key -> new ArrayList()).add(savedProfile);
            }
        }
        List assetProfiles = this.loadListOfEntitiesIfFileExists(solutionId, "asset_profiles.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        assetProfiles.addAll(this.loadListOfEntitiesFromDirectory(solutionId, "asset_profiles", AssetProfileDefinition.class));
        if (!assetProfiles.isEmpty()) {
            for (Object assetProfile : assetProfiles) {
                AssetProfile savedProfile = this.assetProfileService.findAssetProfileByName(tenantId, assetProfile.getName());
                if (savedProfile == null) continue;
                alreadyExistingEntities.computeIfAbsent(EntityType.ASSET_PROFILE, key -> new ArrayList()).add(savedProfile);
            }
        }
        if (!(dashboards = this.loadListOfEntitiesIfFileExists(solutionId, "dashboards.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).isEmpty()) {
            for (DashboardDefinition dashboard : dashboards) {
                List savedDashboards = this.dashboardService.findDashboardsByTenantId(tenantId, new PageLink(1, 0, dashboard.getName())).getData();
                if (savedDashboards == null || savedDashboards.isEmpty()) continue;
                alreadyExistingEntities.computeIfAbsent(EntityType.DASHBOARD, key -> new ArrayList()).add((HasName)savedDashboards.get(0));
            }
        }
        if (!alreadyExistingEntities.isEmpty()) {
            SolutionInstallResponse solutionInstallResponse = new SolutionInstallResponse();
            StringBuilder detailsBuilder = new StringBuilder();
            detailsBuilder.append("## Validation failed").append(System.lineSeparator()).append(System.lineSeparator());
            alreadyExistingEntities.forEach((type, list) -> detailsBuilder.append("The following **").append(this.getTypeLabel(type)).append("** entities already exist: ").append(list.stream().map(HasName::getName).map(name -> "'" + name + "'").collect(Collectors.joining(","))).append(";").append(System.lineSeparator()).append(System.lineSeparator()));
            solutionInstallResponse.setSuccess(false);
            solutionInstallResponse.setDetails(detailsBuilder.toString());
            return solutionInstallResponse;
        }
        return null;
    }

    private SolutionInstallResponse doInstallSolution(User user, TenantId tenantId, String solutionId, HttpServletRequest request) {
        SolutionInstallContext ctx = new SolutionInstallContext(tenantId, solutionId, user, new TenantSolutionTemplateInstructions());
        try {
            this.registerEmulatorsAndComputeOldestTelemetryTs(ctx);
            this.provisionRoles(ctx);
            this.provisionTenantDetails(ctx);
            this.provisionRuleChains(ctx);
            this.provisionDeviceProfiles(ctx);
            this.provisionAssetProfiles(ctx);
            List customers = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "customers.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.provisionCustomers(ctx, customers);
            Map assets = this.provisionAssets(ctx);
            Map devices = this.provisionDevices(user, ctx);
            this.provisionDashboards(ctx);
            this.provisionCustomerUsers(ctx, customers);
            this.provisionRelations(ctx);
            this.provisionSchedulerEvents(ctx);
            this.updateRuleChains(ctx);
            this.provisionEdges(user, ctx, request);
            this.provisionAlarmRules(ctx);
            Set telemetryLoading = this.launchEmulators(ctx, devices, assets);
            this.waitForTelemetryCompletion(telemetryLoading);
            this.provisionCalculatedFields(ctx);
            ctx.getSolutionInstructions().setDetails(this.prepareInstructions(ctx, request));
            long ts = System.currentTimeMillis();
            BaseAttributeKvEntry createdEntitiesAttribute = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(this.toCreatedEntitiesKey(solutionId), JacksonUtil.toString((Object)ctx.getCreatedEntitiesList())), ts);
            BaseAttributeKvEntry statusAttribute = new BaseAttributeKvEntry((KvEntry)new BooleanDataEntry(this.toStatusKey(solutionId), Boolean.valueOf(true)), ts);
            TenantSolutionTemplateInstructions instructions = new TenantSolutionTemplateInstructions(ctx.getSolutionInstructions());
            BaseAttributeKvEntry instructionAttribute = new BaseAttributeKvEntry((KvEntry)new StringDataEntry(this.toInstructionsKey(solutionId), JacksonUtil.toString((Object)instructions)), ts);
            this.attributesService.save(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, Arrays.asList(createdEntitiesAttribute, statusAttribute, instructionAttribute));
            List ruleChains = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "rule_chains.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (ruleChains.stream().anyMatch(r -> StringUtils.isNotEmpty((String)r.getUpdate()))) {
                long timeout = this.solutions.stream().filter(s -> s.getId().equals(solutionId)).map(SolutionTemplate::getInstallTimeoutMs).findFirst().orElseThrow(RuntimeException::new);
                Thread.sleep(timeout);
                this.finalUpdateRuleChains(ctx);
            }
            return new SolutionInstallResponse(ctx.getSolutionInstructions(), true);
        }
        catch (SubscriptionException | EntitiesLimitExceededException se) {
            log.error("[{}][{}] Failed to provision", new Object[]{tenantId, solutionId, se});
            this.rollback(tenantId, solutionId, ctx, se);
            throw se;
        }
        catch (Throwable e) {
            log.error("[{}][{}] Failed to provision", new Object[]{tenantId, solutionId, e});
            this.rollback(tenantId, solutionId, ctx, e);
            return new SolutionInstallResponse(ctx.getSolutionInstructions(), false);
        }
    }

    private void waitForTelemetryCompletion(Set<CompletableFuture<Void>> futures) throws InterruptedException {
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            all.get();
            Thread.sleep((long)futures.size() * 100L);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Telemetry processing failed", e.getCause());
        }
    }

    private void rollback(TenantId tenantId, String solutionId, SolutionInstallContext ctx, Throwable e) {
        List createdEntities = ctx.getCreatedEntitiesList();
        Collections.reverse(createdEntities);
        for (EntityId entityId : createdEntities) {
            try {
                this.deleteEntity(tenantId, entityId, ctx.getUser());
            }
            catch (RuntimeException re) {
                log.error("[{}][{}] Failed to delete the entity: {}", new Object[]{tenantId, solutionId, entityId, re});
            }
        }
        this.attributesService.removeAll(tenantId, (EntityId)tenantId, AttributeScope.SERVER_SCOPE, Arrays.asList(this.toCreatedEntitiesKey(solutionId), this.toStatusKey(solutionId), this.toInstructionsKey(solutionId)));
        ctx.getSolutionInstructions().setDetails(e.getMessage());
    }

    private String prepareInstructions(SolutionInstallContext ctx, HttpServletRequest request) {
        String template = this.readFile(this.resolve(ctx.getSolutionId(), new String[]{"instructions.md"}));
        String baseUrl = this.systemSecurityService.getBaseUrl(ctx.getTenantId(), null, request);
        if (template.contains("${edge_instructions}")) {
            if (ctx.getCreatedEdges().isEmpty()) {
                template = template.replace("${edge_instructions}", "");
            } else {
                Path edgeFile = this.resolve(ctx.getSolutionId(), new String[]{"edge_instructions.md"});
                String edgeTemplate = Files.exists(edgeFile, new LinkOption[0]) ? this.readFile(edgeFile) : "";
                template = template.replace("${edge_instructions}", edgeTemplate);
            }
        }
        template = template.replace("${DOCS_BASE_URL}", this.docsBaseUrl);
        template = template.replace("${BASE_URL}", baseUrl);
        TenantSolutionTemplateInstructions solutionInstructions = ctx.getSolutionInstructions();
        template = template.replace("${MAIN_DASHBOARD_URL}", this.getDashboardLink(solutionInstructions, solutionInstructions.getDashboardGroupId(), solutionInstructions.getDashboardId(), false));
        if (solutionInstructions.isMainDashboardPublic()) {
            template = template.replace("${MAIN_DASHBOARD_PUBLIC_URL}", this.getDashboardLink(solutionInstructions, solutionInstructions.getDashboardGroupId(), solutionInstructions.getDashboardId(), true));
        }
        for (Object dashboardLinkInfo : ctx.getDashboardLinks()) {
            template = template.replace("${" + dashboardLinkInfo.getName() + "DASHBOARD_URL}", this.getDashboardLink(solutionInstructions, dashboardLinkInfo.getEntityGroupId(), dashboardLinkInfo.getDashboardId(), false));
            if (!dashboardLinkInfo.isPublic()) continue;
            template = template.replace("${" + dashboardLinkInfo.getName() + "DASHBOARD_PUBLIC_URL}", this.getDashboardLink(solutionInstructions, dashboardLinkInfo.getEntityGroupId(), dashboardLinkInfo.getDashboardId(), true));
        }
        if (template.contains("${GATEWAYS_URL}")) {
            template = template.replace("${GATEWAYS_URL}", "/entities/gateways");
        }
        StringBuilder devList = new StringBuilder();
        devList.append("| Device name | Access token | Owner |");
        devList.append(System.lineSeparator());
        devList.append("| :---   | :---  | :---  |");
        devList.append(System.lineSeparator());
        for (DeviceCredentialsInfo credentialsInfo : ctx.getCreatedDevices().values()) {
            devList.append("|").append(credentialsInfo.getName()).append("|").append(credentialsInfo.getCredentials().getCredentialsId()).append("{:copy-code}").append("|").append(credentialsInfo.getCustomerName() != null ? credentialsInfo.getCustomerName() : "Tenant");
            devList.append(System.lineSeparator());
            template = template.replace("${" + credentialsInfo.getName() + "ACCESS_TOKEN}", credentialsInfo.getCredentials().getCredentialsId());
            if (!credentialsInfo.isGateway()) continue;
            template = template.replace("${DOCKER_CONFIG}", this.prepareDockerComposeFile(ctx.getTenantId(), ctx.getSolutionId(), baseUrl, credentialsInfo.getCredentials().getDeviceId()));
        }
        template = template.replace("${device_list_and_credentials}", devList.toString());
        StringBuilder userList = new StringBuilder();
        userList.append("| Name | Login | Password | Customer name | User group |");
        userList.append(System.lineSeparator());
        userList.append("| :---  | :---  | :---  | :---  | :---  |");
        userList.append(System.lineSeparator());
        for (UserCredentialsInfo userCredentialsInfo : ctx.getCreatedUsers().values()) {
            userList.append("|").append(userCredentialsInfo.getName()).append("|").append(userCredentialsInfo.getLogin()).append("{:copy-code}").append("|").append(userCredentialsInfo.getPassword()).append("{:copy-code}").append("|").append(userCredentialsInfo.getCustomerName() != null ? userCredentialsInfo.getCustomerName() : "").append("|").append(userCredentialsInfo.getCustomerGroup() != null ? userCredentialsInfo.getCustomerGroup() : "");
            userList.append(System.lineSeparator());
        }
        template = template.replace("${user_list}", userList.toString());
        for (Map.Entry entry : ctx.getCreatedEdges().entrySet()) {
            EdgeLinkInfo edgeLinkInfo = (EdgeLinkInfo)entry.getValue();
            StringBuilder edgeDetailsUrl = new StringBuilder();
            if (EntityType.CUSTOMER.equals((Object)edgeLinkInfo.getOwnerId().getEntityType())) {
                edgeDetailsUrl.append("/customers/all/").append(edgeLinkInfo.getOwnerId().getId());
            }
            edgeDetailsUrl.append("/edgeManagement/instances/all/").append(edgeLinkInfo.getEdgeId().getId());
            String edgeName = (String)entry.getKey();
            String edgeDetailsPlaceholder = "${" + edgeName + "EDGE_DETAILS_URL}";
            template = template.replace(edgeDetailsPlaceholder, edgeDetailsUrl.toString());
        }
        template = DefaultSolutionService.replaceAlarmRules((SolutionInstallContext)ctx, (String)template);
        template = DefaultSolutionService.replaceCalculatedFields((SolutionInstallContext)ctx, (String)template);
        template = DefaultSolutionService.replaceCreatedEntities((SolutionInstallContext)ctx, (String)template);
        return template;
    }

    private static String replaceAlarmRules(SolutionInstallContext ctx, String template) {
        StringBuilder alarmRules = new StringBuilder();
        alarmRules.append("| Entity Profile Name | Alarm Type | Severities |").append(System.lineSeparator());
        alarmRules.append("| :--- | :--- | :--- |").append(System.lineSeparator());
        ctx.getCreatedAlarmRules().entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(CreatedAlarmRuleInfo::entityName, String.CASE_INSENSITIVE_ORDER).thenComparing(CreatedAlarmRuleInfo::alarmType, String.CASE_INSENSITIVE_ORDER))).forEach(entry -> {
            UUID key = (UUID)entry.getKey();
            CreatedAlarmRuleInfo alarmRuleInfo = (CreatedAlarmRuleInfo)entry.getValue();
            String alarmType = alarmRuleInfo.alarmType();
            String link = alarmRuleInfo.getCfPageLink(key);
            String alarmTypeWithLink = "<a href=\"" + link + "\" target=\"_blank\">" + alarmType + "</a>";
            String profileName = alarmRuleInfo.entityId() != null ? "<a href=\"" + alarmRuleInfo.getEntityPageLink() + "\" target=\"_blank\">" + alarmRuleInfo.entityName() + "</a>" : alarmRuleInfo.entityName();
            alarmRules.append("|").append(profileName).append("|").append(alarmTypeWithLink).append("|").append(alarmRuleInfo.severities()).append("|").append(System.lineSeparator());
        });
        return template.replace("${alarm_rules}", alarmRules.toString());
    }

    private static String replaceCalculatedFields(SolutionInstallContext ctx, String template) {
        StringBuilder calculatedFields = new StringBuilder();
        calculatedFields.append("| Entity Profile Name | Field Name | Field Type |").append(System.lineSeparator());
        calculatedFields.append("| :--- | :--- | :--- |").append(System.lineSeparator());
        ctx.getCreatedCalculatedFields().entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(CreatedCalculatedFieldInfo::entityName, String.CASE_INSENSITIVE_ORDER).thenComparing(CreatedCalculatedFieldInfo::name, String.CASE_INSENSITIVE_ORDER))).forEach(entry -> {
            UUID key = (UUID)entry.getKey();
            CreatedCalculatedFieldInfo cfInfo = (CreatedCalculatedFieldInfo)entry.getValue();
            String cfTitle = cfInfo.name();
            String link = cfInfo.getCfPageLink(key);
            String cfTitleWithLink = "<a href=\"" + link + "\" target=\"_blank\">" + cfTitle + "</a>";
            String profileName = cfInfo.entityId() != null ? "<a href=\"" + cfInfo.getEntityPageLink() + "\" target=\"_blank\">" + cfInfo.entityName() + "</a>" : cfInfo.entityName();
            calculatedFields.append("|").append(profileName).append("|").append(cfTitleWithLink).append("|").append(cfInfo.type()).append("|").append(System.lineSeparator());
        });
        return template.replace("${calculated_fields}", calculatedFields.toString());
    }

    private static String replaceCreatedEntities(SolutionInstallContext ctx, String template) {
        StringBuilder entityList = new StringBuilder();
        entityList.append("| Name | Type | Owner |").append(System.lineSeparator());
        entityList.append("| :--- | :--- | :--- |").append(System.lineSeparator());
        for (Map.Entry entry : ctx.getCreatedEntities().entrySet()) {
            UUID key = (UUID)entry.getKey();
            CreatedEntityInfo entityInfo = (CreatedEntityInfo)entry.getValue();
            String link = entityInfo.getEntityPageLink(key);
            String entityName = entityInfo.getName();
            String name = link != null ? "<a href=\"" + link + "\" target=\"_blank\">" + entityName + "</a>" : entityName;
            entityList.append("|").append(name).append("|").append(entityInfo.getType().getNormalName()).append("|").append(entityInfo.getOwner()).append("|").append(System.lineSeparator());
        }
        return template.replace("${all_entities}", entityList.toString());
    }

    private String getDashboardLink(TenantSolutionTemplateInstructions solutionInstructions, EntityGroupId dashboardGroupId, DashboardId dashboardId, boolean isPublic) {
        String dashboardLink = isPublic ? "/dashboard/" + String.valueOf(dashboardId.getId()) + "?publicId=" + String.valueOf(solutionInstructions.getPublicId()) : "/dashboardGroups/" + String.valueOf(dashboardGroupId.getId()) + "/" + String.valueOf(dashboardId.getId());
        return dashboardLink;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String prepareDockerComposeFile(TenantId tenantId, String solutionId, String baseUrl, DeviceId deviceId) {
        Device device = new Device(deviceId);
        device.setTenantId(tenantId);
        String containerName = "tb-gateway-" + solutionId.replace('_', '-');
        DockerComposeParams params = new DockerComposeParams(false, containerName, false, true, false, false);
        try (InputStream inputStream = this.deviceConnectivityService.createGatewayDockerComposeFile(baseUrl, device, params).getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read or process the docker-compose.yml file.", e);
        }
    }

    private void provisionRoles(SolutionInstallContext ctx) {
        List roleDefinitions = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "roles.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (RoleDefinition roleDef : roleDefinitions) {
            Role role = new Role();
            role.setTenantId(ctx.getTenantId());
            role.setName(roleDef.getName());
            role.setType(roleDef.getType());
            role.setPermissions(roleDef.getOperations());
            role = this.roleService.saveRole(ctx.getTenantId(), role);
            ctx.register(role);
            ctx.putIdToMap((EntityDefinition)roleDef, (EntityId)role.getId());
        }
    }

    private void provisionRuleChains(SolutionInstallContext ctx) {
        boolean edgeAllowed = this.subscriptionService.isCreateEdgeAllowed(ctx.getTenantId());
        List ruleChains = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "rule_chains.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (ReferenceableEntityDefinition entityDefinition : ruleChains) {
            Path ruleChainPath = this.resolve(ctx.getSolutionId(), new String[]{"rule_chains", entityDefinition.getFile()});
            JsonNode ruleChainJson = this.replaceIds(ctx, JacksonUtil.toJsonNode((Path)ruleChainPath));
            RuleChain ruleChain = (RuleChain)JacksonUtil.treeToValue((JsonNode)ruleChainJson.get("ruleChain"), RuleChain.class);
            if (!edgeAllowed && RuleChainType.EDGE.equals((Object)ruleChain.getType())) {
                log.warn("[{}][{}] Skipping EDGE rule chain provisioning due to subscription limitations: {}", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), ruleChain.getName()});
                continue;
            }
            ruleChain.setTenantId(ctx.getTenantId());
            String metadataStr = JacksonUtil.toString((Object)ruleChainJson.get("metadata"));
            RuleChainMetaData ruleChainMetaData = (RuleChainMetaData)JacksonUtil.treeToValue((JsonNode)JacksonUtil.toJsonNode((String)metadataStr), RuleChainMetaData.class);
            RuleChain savedRuleChain = this.ruleChainService.saveRuleChain(ruleChain);
            ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
            this.ruleChainService.saveRuleChainMetaData(ctx.getTenantId(), ruleChainMetaData, arg_0 -> ((TbRuleChainService)this.tbRuleChainService).updateRuleNodeConfiguration(arg_0));
            if (ruleChain.isRoot()) {
                this.ruleChainService.setRootRuleChain(ctx.getTenantId(), savedRuleChain.getId());
            }
            ctx.register(entityDefinition.getJsonId(), savedRuleChain);
        }
    }

    private void updateRuleChains(SolutionInstallContext ctx) {
        List ruleChains = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "rule_chains.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (ReferenceableEntityDefinition entityDefinition : ruleChains) {
            String metadataStr;
            Path ruleChainPath = this.resolve(ctx.getSolutionId(), new String[]{"rule_chains", entityDefinition.getFile()});
            JsonNode ruleChainJson = JacksonUtil.toJsonNode((Path)ruleChainPath);
            RuleChain ruleChain = (RuleChain)JacksonUtil.treeToValue((JsonNode)ruleChainJson.get("ruleChain"), RuleChain.class);
            ruleChain.setTenantId(ctx.getTenantId());
            String oldMetadataStr = metadataStr = JacksonUtil.toString((Object)ruleChainJson.get("metadata"));
            for (Map.Entry entry : ctx.getRealIds().entrySet()) {
                metadataStr = metadataStr.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            if (metadataStr.equals(oldMetadataStr)) continue;
            RuleChainMetaData ruleChainMetaData = (RuleChainMetaData)JacksonUtil.treeToValue((JsonNode)JacksonUtil.toJsonNode((String)metadataStr), RuleChainMetaData.class);
            String realRuleChainId = (String)ctx.getRealIds().get(entityDefinition.getJsonId());
            if (StringUtils.isEmpty((String)realRuleChainId)) continue;
            RuleChainId ruleChainId = (RuleChainId)EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.RULE_CHAIN, (String)realRuleChainId);
            RuleChain savedRuleChain = this.ruleChainService.findRuleChainById(ctx.getTenantId(), ruleChainId);
            ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
            this.ruleChainService.saveRuleChainMetaData(ctx.getTenantId(), ruleChainMetaData, arg_0 -> ((TbRuleChainService)this.tbRuleChainService).updateRuleNodeConfiguration(arg_0));
        }
    }

    private void finalUpdateRuleChains(SolutionInstallContext ctx) {
        List ruleChains = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "rule_chains.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (ReferenceableEntityDefinition entityDefinition : ruleChains) {
            String metadataStr;
            if (StringUtils.isEmpty((String)entityDefinition.getUpdate())) continue;
            Path ruleChainPath = this.resolve(ctx.getSolutionId(), new String[]{"rule_chains", entityDefinition.getUpdate()});
            JsonNode ruleChainJson = JacksonUtil.toJsonNode((Path)ruleChainPath);
            RuleChain ruleChain = (RuleChain)JacksonUtil.treeToValue((JsonNode)ruleChainJson.get("ruleChain"), RuleChain.class);
            ruleChain.setTenantId(ctx.getTenantId());
            String oldMetadataStr = metadataStr = JacksonUtil.toString((Object)ruleChainJson.get("metadata"));
            for (Map.Entry entry : ctx.getRealIds().entrySet()) {
                metadataStr = metadataStr.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            RuleChainMetaData ruleChainMetaData = (RuleChainMetaData)JacksonUtil.treeToValue((JsonNode)JacksonUtil.toJsonNode((String)metadataStr), RuleChainMetaData.class);
            String realRuleChainId = (String)ctx.getRealIds().get(entityDefinition.getJsonId());
            if (StringUtils.isEmpty((String)realRuleChainId)) continue;
            RuleChainId ruleChainId = (RuleChainId)EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.RULE_CHAIN, (String)realRuleChainId);
            RuleChain savedRuleChain = this.ruleChainService.findRuleChainById(ctx.getTenantId(), ruleChainId);
            ruleChainMetaData.setRuleChainId(savedRuleChain.getId());
            this.ruleChainService.saveRuleChainMetaData(ctx.getTenantId(), ruleChainMetaData, arg_0 -> ((TbRuleChainService)this.tbRuleChainService).updateRuleNodeConfiguration(arg_0));
        }
    }

    private void provisionDeviceProfiles(SolutionInstallContext ctx) {
        List deviceProfiles = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "device_profiles.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        deviceProfiles.addAll(this.loadListOfEntitiesFromDirectory(ctx.getSolutionId(), "device_profiles", DeviceProfileDefinition.class));
        deviceProfiles.forEach(deviceProfile -> {
            String newId;
            deviceProfile.setId(null);
            deviceProfile.setCreatedTime(0L);
            deviceProfile.setTenantId(ctx.getTenantId());
            if (deviceProfile.getDefaultRuleChainId() != null) {
                newId = (String)ctx.getRealIds().get(deviceProfile.getDefaultRuleChainId().getId().toString());
                if (newId != null) {
                    deviceProfile.setDefaultRuleChainId(new RuleChainId(UUID.fromString(newId)));
                } else {
                    log.error("[{}][{}] Device profile: {} references non existing rule chain.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), deviceProfile.getName()});
                    throw new ThingsboardRuntimeException();
                }
            }
            if (deviceProfile.getDefaultEdgeRuleChainId() != null) {
                newId = (String)ctx.getRealIds().get(deviceProfile.getDefaultEdgeRuleChainId().getId().toString());
                if (StringUtils.isEmpty((String)newId)) {
                    deviceProfile.setDefaultEdgeRuleChainId(null);
                } else {
                    deviceProfile.setDefaultEdgeRuleChainId(new RuleChainId(UUID.fromString(newId)));
                }
            }
        });
        deviceProfiles.forEach(deviceProfileDefinition -> {
            DeviceProfile deviceProfile = new DeviceProfile((DeviceProfile)deviceProfileDefinition);
            deviceProfile = this.deviceProfileService.saveDeviceProfile(deviceProfile);
            ctx.register(deviceProfileDefinition, deviceProfile);
        });
    }

    private void provisionAssetProfiles(SolutionInstallContext ctx) {
        List assetProfiles = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "asset_profiles.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        assetProfiles.addAll(this.loadListOfEntitiesFromDirectory(ctx.getSolutionId(), "asset_profiles", AssetProfileDefinition.class));
        assetProfiles.forEach(assetProfile -> {
            String newId;
            assetProfile.setId(null);
            assetProfile.setCreatedTime(0L);
            assetProfile.setTenantId(ctx.getTenantId());
            if (assetProfile.getDefaultRuleChainId() != null) {
                newId = (String)ctx.getRealIds().get(assetProfile.getDefaultRuleChainId().getId().toString());
                if (newId != null) {
                    assetProfile.setDefaultRuleChainId(new RuleChainId(UUID.fromString(newId)));
                } else {
                    log.error("[{}][{}] Asset profile: {} references non existing rule chain.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), assetProfile.getName()});
                    throw new ThingsboardRuntimeException();
                }
            }
            if (assetProfile.getDefaultEdgeRuleChainId() != null) {
                newId = (String)ctx.getRealIds().get(assetProfile.getDefaultEdgeRuleChainId().getId().toString());
                if (StringUtils.isEmpty((String)newId)) {
                    assetProfile.setDefaultEdgeRuleChainId(null);
                } else {
                    assetProfile.setDefaultEdgeRuleChainId(new RuleChainId(UUID.fromString(newId)));
                }
            }
        });
        assetProfiles.forEach(assetProfileDefinition -> {
            AssetProfile assetProfile = new AssetProfile((AssetProfile)assetProfileDefinition);
            assetProfile = this.assetProfileService.saveAssetProfile(assetProfile);
            ctx.register(assetProfileDefinition, assetProfile);
        });
    }

    private void provisionSchedulerEvents(SolutionInstallContext ctx) {
        List schedulerEvents = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "scheduler_events.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        schedulerEvents.addAll(this.loadListOfEntitiesFromDirectory(ctx.getSolutionId(), "scheduler_events", SchedulerEventDefinition.class));
        schedulerEvents.forEach(entityDef -> {
            SchedulerEvent schedulerEvent = this.getSchedulerEvent(ctx, entityDef);
            SchedulerEvent savedSchedulerEvent = this.schedulerEventService.saveSchedulerEvent(schedulerEvent);
            if (schedulerEvent.getId() == null) {
                this.schedulerService.onSchedulerEventAdded((SchedulerEventInfo)savedSchedulerEvent);
            } else {
                this.schedulerService.onSchedulerEventUpdated((SchedulerEventInfo)savedSchedulerEvent);
            }
            log.info("[{}] Saved scheduler event: {}", (Object)schedulerEvent.getId(), (Object)schedulerEvent);
            ctx.register(entityDef, savedSchedulerEvent);
        });
    }

    private SchedulerEvent getSchedulerEvent(SolutionInstallContext ctx, SchedulerEventDefinition entityDef) {
        SchedulerEvent schedulerEvent = new SchedulerEvent();
        schedulerEvent.setTenantId(ctx.getTenantId());
        schedulerEvent.setName(entityDef.getName());
        schedulerEvent.setType(entityDef.getType());
        schedulerEvent.setConfiguration(entityDef.getConfiguration());
        schedulerEvent.setSchedule(entityDef.getSchedule());
        schedulerEvent.setCustomerId((CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer()));
        if (entityDef.getOriginatorId() != null) {
            String newIdStr = (String)ctx.getRealIds().get(entityDef.getOriginatorId().getId().toString());
            if (newIdStr != null) {
                EntityId newId = EntityIdFactory.getByTypeAndUuid((EntityType)entityDef.getOriginatorId().getEntityType(), (UUID)UUID.fromString(newIdStr));
                schedulerEvent.setOriginatorId(newId);
            } else {
                log.error("[{}][{}] Scheduler event: {} references non existing entity.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entityDef.getName()});
                throw new ThingsboardRuntimeException(String.format("[{}][{}] Scheduler event: {} references non existing entity.", ctx.getTenantId(), ctx.getSolutionId(), entityDef.getName()), ThingsboardErrorCode.GENERAL);
            }
        }
        return schedulerEvent;
    }

    private void provisionDashboards(SolutionInstallContext ctx) throws ThingsboardException {
        List dashboards = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "dashboards.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DashboardDefinition entityDef : dashboards) {
            CustomerId customerId = (CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer());
            Path dashboardsPath = this.resolve(ctx.getSolutionId(), new String[]{"dashboards", entityDef.getFile()});
            JsonNode dashboardJson = this.replaceIds(ctx, JacksonUtil.toJsonNode((Path)dashboardsPath));
            Dashboard dashboardTemplate = (Dashboard)JacksonUtil.treeToValue((JsonNode)dashboardJson, Dashboard.class);
            Dashboard dashboard = new Dashboard();
            dashboard.setTenantId(ctx.getTenantId());
            dashboard.setTitle(entityDef.getName());
            dashboard.setConfiguration(dashboardTemplate.getConfiguration());
            dashboard.setCustomerId(customerId);
            dashboard.setImage(dashboardTemplate.getImage());
            dashboard.setResources(dashboardTemplate.getResources());
            dashboard = this.dashboardService.saveDashboard(dashboard);
            ctx.register(entityDef, dashboard);
            ctx.putIdToMap(EntityType.DASHBOARD, entityDef.getName(), (EntityId)dashboard.getId());
            EntityGroupId entityGroupId = this.addEntityToGroup(ctx, (CustomerEntityDefinition)entityDef, (EntityId)dashboard.getId());
            if (entityGroupId == null) {
                entityGroupId = ((EntityGroup)this.entityGroupService.findEntityGroupByTypeAndName(ctx.getTenantId(), dashboard.getOwnerId(), EntityType.DASHBOARD, "All").get()).getId();
            }
            if (entityDef.isMain()) {
                ctx.getSolutionInstructions().setDashboardGroupId(entityGroupId);
                ctx.getSolutionInstructions().setDashboardId(dashboard.getId());
                ctx.getSolutionInstructions().setMainDashboardPublic(entityDef.isMakePublic());
            }
            ctx.getDashboardLinks().add(new DashboardLinkInfo(dashboard.getName(), entityGroupId, dashboard.getId(), entityDef.isMakePublic()));
        }
    }

    protected void provisionRelations(SolutionInstallContext ctx) {
        ctx.getRelationDefinitions().forEach((id, relations) -> {
            for (RelationDefinition relationDef : relations) {
                log.info("[{}] Saving relation: {}", id, (Object)relationDef);
                EntityRelation entityRelation = new EntityRelation();
                EntityId otherId = this.resolveRelatedEntityId(relationDef, ctx);
                if (EntitySearchDirection.FROM.equals((Object)relationDef.getDirection())) {
                    entityRelation.setFrom(otherId);
                    entityRelation.setTo(id);
                } else {
                    entityRelation.setFrom(id);
                    entityRelation.setTo(otherId);
                }
                entityRelation.setTypeGroup(RelationTypeGroup.COMMON);
                entityRelation.setType(relationDef.getType());
                try {
                    this.relationService.save(ctx.getTenantId(), null, entityRelation, null);
                }
                catch (Exception e) {
                    log.info("[{}] Failed to save relation: {}, cause: {}", new Object[]{id, relationDef, e.getMessage()});
                }
            }
        });
    }

    private EntityId resolveRelatedEntityId(RelationDefinition relationDef, SolutionInstallContext ctx) {
        if (EntityType.TENANT == relationDef.getEntityType()) {
            return ctx.getTenantId();
        }
        return ctx.getIdFromMap(relationDef.getEntityType(), relationDef.getEntityName());
    }

    protected Map<Device, DeviceDefinition> provisionDevices(User user, SolutionInstallContext ctx) throws Exception {
        HashMap<Device, DeviceDefinition> result = new HashMap<Device, DeviceDefinition>();
        HashSet deviceTypeSet = new HashSet();
        List devices = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "devices.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DeviceDefinition entityDef : devices) {
            CustomerId customerId = (CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer());
            Device entity = new Device();
            entity.setTenantId(ctx.getTenantId());
            entity.setName(entityDef.getName());
            entity.setLabel(entityDef.getLabel());
            this.ensureDeviceProfileExists(ctx, deviceTypeSet, entityDef);
            entity.setType(entityDef.getType());
            entity.setCustomerId(customerId);
            entity.setAdditionalInfo(entityDef.getAdditionalInfo());
            entity = this.deviceService.saveDevice(entity);
            this.entityActionService.logEntityAction(user, (EntityId)entity.getId(), (HasName)entity, customerId, ActionType.ADDED, null, new Object[0]);
            ctx.register(entityDef, entity);
            log.info("[{}] Saved device: {}", (Object)entity.getId(), (Object)entity);
            DeviceId entityId = entity.getId();
            ctx.putIdToMap((EntityDefinition)entityDef, (EntityId)entityId);
            this.saveServerSideAttributes(ctx, (EntityId)entityId, entityDef.getAttributes());
            this.saveSharedAttributes(ctx, (EntityId)entityId, entityDef.getSharedAttributes());
            ctx.put((EntityId)entityId, entityDef.getRelations());
            this.addEntityToGroup(ctx, (CustomerEntityDefinition)entityDef, (EntityId)entityId);
            DeviceCredentialsInfo deviceCredentialsInfo = new DeviceCredentialsInfo();
            deviceCredentialsInfo.setName(entity.getName());
            deviceCredentialsInfo.setType(entity.getType());
            deviceCredentialsInfo.setCustomerName(entityDef.getCustomer());
            deviceCredentialsInfo.setCredentials(this.deviceCredentialsService.findDeviceCredentialsByDeviceId(ctx.getTenantId(), entityId));
            JsonNode additionalInfo = entity.getAdditionalInfo();
            boolean isGateway = additionalInfo != null && additionalInfo.hasNonNull("gateway") && additionalInfo.get("gateway").asBoolean();
            deviceCredentialsInfo.setGateway(isGateway);
            ctx.addDeviceCredentials(deviceCredentialsInfo);
            result.put(entity, entityDef);
        }
        return result;
    }

    private void ensureDeviceProfileExists(SolutionInstallContext ctx, Set<String> deviceTypeSet, DeviceDefinition entityDef) {
        DeviceProfile deviceProfile;
        if (!deviceTypeSet.contains(entityDef.getType()) && (deviceProfile = this.deviceProfileService.findDeviceProfileByName(ctx.getTenantId(), entityDef.getType())) == null) {
            DeviceProfile created = this.deviceProfileService.findOrCreateDeviceProfile(ctx.getTenantId(), entityDef.getType());
            ctx.register((EntityId)created.getId());
            log.info("Saved device profile: {}", (Object)created.getId());
            deviceTypeSet.add(entityDef.getType());
        }
    }

    private void registerEmulatorsAndComputeOldestTelemetryTs(SolutionInstallContext ctx) {
        List emulatorDefinitions = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "device_emulators.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map deviceEmulators = emulatorDefinitions.stream().collect(Collectors.toMap(EmulatorDefinition::getName, Function.identity()));
        emulatorDefinitions.stream().filter(ed -> StringUtils.isNotEmpty((String)ed.getExtendz())).forEach(ed -> {
            EmulatorDefinition parent = (EmulatorDefinition)deviceEmulators.get(ed.getExtendz());
            if (parent != null) {
                ed.enrich(parent);
            }
        });
        Map assetEmulators = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "asset_emulators.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */).stream().collect(Collectors.toMap(EmulatorDefinition::getName, Function.identity()));
        ctx.setDeviceEmulators(deviceEmulators);
        ctx.setAssetEmulators(assetEmulators);
        long solutionInstallTs = ctx.getInstallTs();
        long oldestDeviceEmulatorsTs = deviceEmulators.values().stream().mapToLong(value -> value.getOldestTs(ctx)).min().orElse(solutionInstallTs);
        long oldestAssetEmulatorsTs = assetEmulators.values().stream().mapToLong(value -> value.getOldestTs(ctx)).min().orElse(solutionInstallTs);
        long solutionOldestTs = Math.min(oldestDeviceEmulatorsTs, oldestAssetEmulatorsTs);
        ctx.setOldestTelemetryTs(solutionOldestTs);
    }

    private Set<CompletableFuture<Void>> launchEmulators(SolutionInstallContext ctx, Map<Device, DeviceDefinition> devicesMap, Map<Asset, AssetDefinition> assets) throws Exception {
        HashSet<CompletableFuture<Void>> results = new HashSet<CompletableFuture<Void>>();
        for (Map.Entry entry : devicesMap.entrySet().stream().filter(e -> StringUtils.isNotBlank((String)((DeviceDefinition)e.getValue()).getEmulator())).collect(Collectors.toSet())) {
            results.add(DeviceEmulatorLauncher.builder().entity((Device)entry.getKey()).emulatorDefinition((EmulatorDefinition)ctx.getDeviceEmulators().get(((DeviceDefinition)entry.getValue()).getEmulator())).oldTelemetryExecutor(this.emulatorExecutor).tbClusterService(this.tbClusterService).partitionService(this.partitionService).tbQueueProducerProvider(this.tbQueueProducerProvider).serviceInfoProvider(this.serviceInfoProvider).tsSubService(this.tsSubService).build().launch());
        }
        for (Map.Entry entry : assets.entrySet().stream().filter(e -> StringUtils.isNotBlank((String)((AssetDefinition)e.getValue()).getEmulator())).collect(Collectors.toSet())) {
            results.add(AssetEmulatorLauncher.builder().entity((Asset)entry.getKey()).emulatorDefinition((EmulatorDefinition)ctx.getAssetEmulators().get(((AssetDefinition)entry.getValue()).getEmulator())).oldTelemetryExecutor(this.emulatorExecutor).tbClusterService(this.tbClusterService).partitionService(this.partitionService).tbQueueProducerProvider(this.tbQueueProducerProvider).serviceInfoProvider(this.serviceInfoProvider).tsSubService(this.tsSubService).build().launch());
        }
        return results;
    }

    protected void provisionTenantDetails(SolutionInstallContext ctx) throws Exception {
        TenantDefinition tenant = (TenantDefinition)this.loadEntityIfFileExists(ctx.getSolutionId(), "tenant.json", TenantDefinition.class);
        if (tenant != null) {
            this.saveServerSideAttributes(ctx, (EntityId)ctx.getTenantId(), tenant.getAttributes());
            ctx.put((EntityId)ctx.getTenantId(), tenant.getRelations());
            for (UserGroupDefinition ugDef : tenant.getUserGroups()) {
                RoleId roleId;
                EntityGroup ugEntity = this.getUserGroupInfo(ctx, (EntityId)ctx.getTenantId(), ugDef.getName());
                ctx.registerReferenceOnly(ugDef.getJsonId(), (EntityId)ugEntity.getId());
                for (String genericRoleName : ugDef.getGenericRoles()) {
                    roleId = (RoleId)ctx.getIdFromMap(EntityType.ROLE, genericRoleName);
                    GroupPermission gp = new GroupPermission();
                    gp.setRoleId(roleId);
                    gp.setTenantId(ctx.getTenantId());
                    gp.setUserGroupId(ugEntity.getId());
                    log.info("[{}] Saving group permission: {}", (Object)ctx.getTenantId(), (Object)gp);
                    this.groupPermissionService.saveGroupPermission(ctx.getTenantId(), gp);
                }
                for (GroupRoleDefinition grDef : ugDef.getGroupRoles()) {
                    roleId = (RoleId)ctx.getIdFromMap(EntityType.ROLE, grDef.getRoleName());
                    EntityGroupId entityGroupId = (EntityGroupId)ctx.getGroupIdFromMap(grDef.getGroupType(), grDef.getGroupName());
                    if (entityGroupId == null) {
                        throw new RuntimeException("Invalid solution configuration. EntityGroup does not exist:" + String.valueOf(grDef.getGroupType()) + grDef.getGroupName());
                    }
                    GroupPermission gp = new GroupPermission();
                    gp.setRoleId(roleId);
                    gp.setTenantId(ctx.getTenantId());
                    gp.setUserGroupId(ugEntity.getId());
                    gp.setEntityGroupId(entityGroupId);
                    gp.setEntityGroupType(grDef.getGroupType());
                    log.info("[{}] Saving group permission: {}", (Object)ctx.getTenantId(), (Object)gp);
                    this.groupPermissionService.saveGroupPermission(ctx.getTenantId(), gp);
                }
            }
        }
    }

    protected Map<Asset, AssetDefinition> provisionAssets(SolutionInstallContext ctx) throws ThingsboardException {
        HashMap<Asset, AssetDefinition> result = new HashMap<Asset, AssetDefinition>();
        HashSet assetTypeSet = new HashSet();
        List assets = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "assets.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (AssetDefinition entityDef : assets) {
            Asset entity = new Asset();
            entity.setTenantId(ctx.getTenantId());
            entity.setName(entityDef.getName());
            entity.setLabel(entityDef.getLabel());
            entity.setType(entityDef.getType());
            entity.setCustomerId((CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer()));
            this.ensureAssetProfileExists(ctx, assetTypeSet, entityDef);
            entity = this.assetService.saveAsset(entity);
            ctx.register(entityDef, entity);
            log.info("[{}] Saved asset: {}", (Object)entity.getId(), (Object)entity);
            AssetId entityId = entity.getId();
            ctx.putIdToMap((EntityDefinition)entityDef, (EntityId)entityId);
            this.saveServerSideAttributes(ctx, (EntityId)entityId, entityDef.getAttributes());
            ctx.put((EntityId)entityId, entityDef.getRelations());
            this.addEntityToGroup(ctx, (CustomerEntityDefinition)entityDef, (EntityId)entityId);
            result.put(entity, entityDef);
        }
        return result;
    }

    private void ensureAssetProfileExists(SolutionInstallContext ctx, Set<String> assetTypeSet, AssetDefinition entityDef) {
        AssetProfile assetProfile;
        if (!assetTypeSet.contains(entityDef.getType()) && (assetProfile = this.assetProfileService.findAssetProfileByName(ctx.getTenantId(), entityDef.getType())) == null) {
            AssetProfile created = this.assetProfileService.findOrCreateAssetProfile(ctx.getTenantId(), entityDef.getType());
            ctx.register((EntityId)created.getId());
            log.info("Saved asset profile: {}", (Object)created.getId());
            assetTypeSet.add(entityDef.getType());
        }
    }

    private void provisionCustomers(SolutionInstallContext ctx, List<CustomerDefinition> customers) throws ExecutionException, InterruptedException {
        for (CustomerDefinition entityDef : customers) {
            EntityGroup groupEntity = null;
            if (!StringUtils.isEmpty((String)entityDef.getGroup())) {
                groupEntity = this.getCustomerGroupInfo(ctx, (EntityId)ctx.getTenantId(), entityDef.getGroup());
            }
            entityDef.setRandomNameData(this.generateRandomName(ctx));
            Customer entity = new Customer();
            entity.setTenantId(ctx.getTenantId());
            entity.setTitle(this.randomize(entityDef.getName(), entityDef.getRandomNameData()));
            entity.setEmail(this.randomize(entityDef.getEmail(), entityDef.getRandomNameData()));
            entity.setCountry(entityDef.getCountry());
            entity.setCity(entityDef.getCity());
            entity.setState(entityDef.getState());
            entity.setZip(entityDef.getZip());
            entity.setAddress(entityDef.getAddress());
            entity = this.customerService.saveCustomer(entity);
            log.info("[{}] Saved customer: {}", (Object)entity.getId(), (Object)entity);
            ctx.register(entityDef, entity);
            CustomerId entityId = entity.getId();
            ctx.putIdToMap((EntityDefinition)entityDef, (EntityId)entityId);
            this.saveServerSideAttributes(ctx, (EntityId)entityId, entityDef.getAttributes(), entityDef.getRandomNameData());
            ctx.put((EntityId)entityId, entityDef.getRelations());
            entityDef.getAssetGroups().forEach(name -> this.createEntityGroup(ctx, (EntityId)entityId, name, EntityType.ASSET));
            entityDef.getDeviceGroups().forEach(name -> this.createEntityGroup(ctx, (EntityId)entityId, name, EntityType.DEVICE));
            entityDef.setName(entity.getName());
            if (groupEntity == null) continue;
            this.entityGroupService.addEntitiesToEntityGroup(ctx.getTenantId(), groupEntity.getId(), Collections.singletonList(entity.getId()));
        }
    }

    private void provisionCustomerUsers(SolutionInstallContext ctx, List<CustomerDefinition> customers) throws ExecutionException, InterruptedException {
        for (CustomerDefinition entityDef : customers) {
            Customer entity = (Customer)this.customerService.findCustomerByTenantIdAndTitle(ctx.getTenantId(), entityDef.getName()).get();
            for (UserGroupDefinition ugDef : entityDef.getUserGroups()) {
                RoleId roleId;
                EntityGroup ugEntity = this.getUserGroupInfo(ctx, (EntityId)entity.getId(), ugDef.getName());
                ctx.registerReferenceOnly(ugDef.getJsonId(), (EntityId)ugEntity.getId());
                for (String genericRoleName : ugDef.getGenericRoles()) {
                    roleId = (RoleId)ctx.getIdFromMap(EntityType.ROLE, genericRoleName);
                    GroupPermission gp = new GroupPermission();
                    gp.setRoleId(roleId);
                    gp.setTenantId(ctx.getTenantId());
                    gp.setUserGroupId(ugEntity.getId());
                    log.info("[{}] Saving group permission: {}", (Object)entity.getId(), (Object)gp);
                    this.groupPermissionService.saveGroupPermission(ctx.getTenantId(), gp);
                }
                for (GroupRoleDefinition grDef : ugDef.getGroupRoles()) {
                    roleId = (RoleId)ctx.getIdFromMap(EntityType.ROLE, grDef.getRoleName());
                    EntityGroupId entityGroupId = (EntityGroupId)ctx.getGroupIdFromMap(grDef.getGroupType(), grDef.getGroupName());
                    if (entityGroupId == null) {
                        throw new RuntimeException("Invalid solution configuration. EntityGroup does not exist:" + String.valueOf(grDef.getGroupType()) + grDef.getGroupName());
                    }
                    GroupPermission gp = new GroupPermission();
                    gp.setRoleId(roleId);
                    gp.setTenantId(ctx.getTenantId());
                    gp.setUserGroupId(ugEntity.getId());
                    gp.setEntityGroupId(entityGroupId);
                    gp.setEntityGroupType(grDef.getGroupType());
                    log.info("[{}] Saving group permission: {}", (Object)entity.getId(), (Object)gp);
                    this.groupPermissionService.saveGroupPermission(ctx.getTenantId(), gp);
                }
            }
            for (UserDefinition uDef : entityDef.getUsers()) {
                String originalName = uDef.getName();
                EntityGroup ugEntity = this.getUserGroupInfo(ctx, (EntityId)entity.getId(), uDef.getGroup());
                User user = this.createUser(ctx, entity, uDef, entityDef);
                UserCredentials credentials = this.userService.findUserCredentialsByUserId(user.getTenantId(), user.getId());
                credentials.setEnabled(true);
                credentials.setActivateToken(null);
                credentials.setPassword(this.passwordEncoder.encode((CharSequence)uDef.getPassword()));
                this.userService.saveUserCredentials(ctx.getTenantId(), credentials);
                this.entityGroupService.addEntitiesToEntityGroup(ctx.getTenantId(), ugEntity.getId(), Collections.singletonList(user.getId()));
                DashboardUserDetailsDefinition dd = uDef.getDashboard();
                if (dd != null) {
                    DashboardId dashboardId = (DashboardId)ctx.getIdFromMap(EntityType.DASHBOARD, dd.getName());
                    ObjectNode additionalInfo = JacksonUtil.newObjectNode();
                    additionalInfo.put("defaultDashboardId", dashboardId.getId().toString());
                    additionalInfo.put("defaultDashboardFullscreen", dd.isFullScreen());
                    user.setAdditionalInfo((JsonNode)additionalInfo);
                    this.userService.saveUser(ctx.getTenantId(), user);
                    log.info("[{}] Added default dashboard for user {}", (Object)entity.getId(), (Object)user.getEmail());
                }
                UserCredentialsInfo credentialsInfo = new UserCredentialsInfo();
                credentialsInfo.setName(user.getFirstName() + " " + user.getLastName());
                credentialsInfo.setLogin(uDef.getName());
                credentialsInfo.setPassword(uDef.getPassword());
                credentialsInfo.setCustomerName(entityDef.getName());
                credentialsInfo.setCustomerGroup(uDef.getGroup());
                ctx.addUserCredentials(credentialsInfo);
                ctx.register(entityDef, uDef, user);
                ctx.put((EntityId)user.getId(), uDef.getRelations());
                ctx.putIdToMap(EntityType.USER, originalName, (EntityId)user.getId());
                ctx.putIdToMap(EntityType.USER, uDef.getName(), (EntityId)user.getId());
                this.saveServerSideAttributes(ctx, (EntityId)user.getId(), uDef.getAttributes());
            }
        }
    }

    private User createUser(SolutionInstallContext ctx, Customer entity, UserDefinition uDef, CustomerDefinition cDef) {
        int maxAttempts = 10;
        Exception finalE = null;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            try {
                boolean lastAttempt = maxAttempts == attempts + 1;
                RandomNameData randomName = lastAttempt ? RandomNameUtil.nextSuperRandom() : RandomNameUtil.next();
                User user = new User();
                if (!StringUtils.isEmpty((String)uDef.getFirstname())) {
                    user.setFirstName(this.randomize(uDef.getFirstname(), randomName, cDef.getRandomNameData()));
                } else {
                    user.setFirstName(randomName.getFirstName());
                }
                if (!StringUtils.isEmpty((String)uDef.getLastname())) {
                    user.setLastName(this.randomize(uDef.getLastname(), randomName, cDef.getRandomNameData()));
                } else {
                    user.setLastName(randomName.getLastName());
                }
                user.setAuthority(Authority.CUSTOMER_USER);
                user.setEmail(this.randomize(uDef.getName(), randomName, cDef.getRandomNameData()));
                user.setCustomerId(entity.getId());
                user.setTenantId(ctx.getTenantId());
                log.info("[{}] Saving user: {}", (Object)entity.getId(), (Object)user);
                user = this.userService.saveUser(ctx.getTenantId(), user);
                uDef.setName(user.getEmail());
                return user;
            }
            catch (Exception e) {
                finalE = e;
                continue;
            }
        }
        throw new RuntimeException(finalE);
    }

    private void provisionEdges(User user, SolutionInstallContext ctx, HttpServletRequest request) throws Exception {
        List edges = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "edges.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        RuleChain edgeTemplateRootRuleChain = this.ruleChainService.getEdgeTemplateRootRuleChain(ctx.getTenantId());
        for (EdgeDefinition entityDef : edges) {
            if (!this.subscriptionService.isCreateEdgeAllowed(ctx.getTenantId())) {
                log.warn("Skipping edge provisioning for tenant {}", (Object)ctx.getTenantId());
                break;
            }
            Edge entity = new Edge();
            entity.setTenantId(ctx.getTenantId());
            entity.setName(entityDef.getName());
            entity.setLabel(entityDef.getLabel());
            entity.setType(entityDef.getType());
            entity.setCustomerId((CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer()));
            entity.setRoutingKey(UUID.randomUUID().toString());
            entity.setSecret(StringUtils.randomAlphanumeric((int)20));
            entity.setEdgeLicenseKey("6qcGys6gz4M2ZuIqZ6hRDjWT");
            entity.setCloudEndpoint(this.systemSecurityService.getBaseUrl(ctx.getTenantId(), null, request));
            RuleChainId rootRuleChainId = edgeTemplateRootRuleChain.getId();
            if (StringUtils.isNotBlank((String)entityDef.getRootRuleChainId())) {
                String newId = (String)ctx.getRealIds().get(entityDef.getRootRuleChainId());
                if (newId != null) {
                    rootRuleChainId = new RuleChainId(UUID.fromString(newId));
                } else {
                    log.error("[{}][{}] Edge: {} references non existing rule chain.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entity.getName()});
                    throw new ThingsboardRuntimeException();
                }
            }
            entity.setRootRuleChainId(rootRuleChainId);
            RuleChain rootRuleChain = this.ruleChainService.findRuleChainById(ctx.getTenantId(), rootRuleChainId);
            entity = this.tbEdgeService.save(entity, rootRuleChain, Collections.emptyList(), user);
            ctx.register(entityDef, entity);
            this.assignRuleChainsToEdge(ctx, entityDef.getRuleChainIds(), entity);
            this.assignEntityGroupsToEdge(ctx, EntityType.ASSET, entityDef.getAssetGroups(), entity);
            this.assignEntityGroupsToEdge(ctx, EntityType.DEVICE, entityDef.getDeviceGroups(), entity);
            this.assignEntityGroupsToEdge(ctx, EntityType.USER, entityDef.getUserGroups(), entity);
            this.assignEntityGroupsToEdge(ctx, EntityType.DASHBOARD, entityDef.getDashboardGroups(), entity);
            this.assignAssetsToEdge(ctx, entityDef.getAssetIds(), entity);
            this.assignDevicesToEdge(ctx, entityDef.getDeviceIds(), entity);
            this.assignSchedulerEventsToEdge(ctx, entityDef.getSchedulerEventIds(), entity);
            log.info("[{}] Saved edge: {}", (Object)entity.getId(), (Object)entity);
            EdgeId entityId = entity.getId();
            ctx.putIdToMap((EntityDefinition)entityDef, (EntityId)entityId);
            this.saveServerSideAttributes(ctx, (EntityId)entityId, entityDef.getAttributes());
            ctx.put((EntityId)entityId, entityDef.getRelations());
            this.addEntityToGroup(ctx, (CustomerEntityDefinition)entityDef, (EntityId)entityId);
            EdgeLinkInfo edgeLinkInfo = new EdgeLinkInfo(entity.getId(), entity.getOwnerId());
            ctx.addEdgeLinkInfo(entity.getName(), edgeLinkInfo);
        }
    }

    private void assignRuleChainsToEdge(SolutionInstallContext ctx, List<String> ruleChainIds, Edge entity) {
        if (ruleChainIds == null || ruleChainIds.isEmpty()) {
            return;
        }
        for (String strRuleChainId : ruleChainIds) {
            String newId = (String)ctx.getRealIds().get(strRuleChainId);
            if (newId != null) {
                RuleChainId ruleChainId = new RuleChainId(UUID.fromString(newId));
                this.ruleChainService.assignRuleChainToEdge(ctx.getTenantId(), ruleChainId, entity.getId());
                continue;
            }
            log.error("[{}][{}] Edge: {} references non existing edge rule chain.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entity.getName()});
            throw new ThingsboardRuntimeException();
        }
    }

    private void assignEntityGroupsToEdge(SolutionInstallContext ctx, EntityType entityType, List<EdgeEntityGroupDefinition> entityGroupDefinitions, Edge edge) {
        for (EdgeEntityGroupDefinition entityGroupDefinition : entityGroupDefinitions) {
            TenantId parentEntityId = ctx.getTenantId();
            if (entityGroupDefinition.getCustomer() != null) {
                parentEntityId = ctx.getIdFromMap(EntityType.CUSTOMER, entityGroupDefinition.getCustomer());
            }
            Optional entityGroupOptional = this.entityGroupService.findEntityGroupByTypeAndName(ctx.getTenantId(), (EntityId)parentEntityId, entityType, entityGroupDefinition.getName());
            entityGroupOptional.ifPresent(entityGroup -> this.entityGroupService.assignEntityGroupToEdge(ctx.getTenantId(), entityGroup.getId(), edge.getId(), entityType));
        }
    }

    private void assignSchedulerEventsToEdge(SolutionInstallContext ctx, List<String> schedulerEventIds, Edge entity) {
        if (schedulerEventIds == null || schedulerEventIds.isEmpty()) {
            return;
        }
        for (String strSchedulerEventId : schedulerEventIds) {
            String newId = (String)ctx.getRealIds().get(strSchedulerEventId);
            if (newId != null) {
                SchedulerEventId schedulerEventId = new SchedulerEventId(UUID.fromString(newId));
                this.schedulerEventService.assignSchedulerEventToEdge(ctx.getTenantId(), schedulerEventId, entity.getId());
                continue;
            }
            log.error("[{}][{}] Edge: {} references non existing scheduler event.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entity.getName()});
            throw new ThingsboardRuntimeException();
        }
    }

    private void assignAssetsToEdge(SolutionInstallContext ctx, List<String> assetIds, Edge entity) throws ThingsboardException {
        EntityGroup edgeAssetGroup;
        if (assetIds == null || assetIds.isEmpty()) {
            return;
        }
        try {
            edgeAssetGroup = (EntityGroup)this.entityGroupService.findOrCreateEdgeAllGroupAsync(ctx.getTenantId(), entity, entity.getName(), EntityType.TENANT, EntityType.ASSET).get();
            ctx.register((EntityId)edgeAssetGroup.getId());
            ctx.putIdToMap(edgeAssetGroup.getOwnerId(), EntityType.ASSET, edgeAssetGroup.getName(), (EntityId)edgeAssetGroup.getId());
        }
        catch (Exception e) {
            log.error("[{}] Failed to find or create edge all asset group", (Object)ctx.getTenantId(), (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
        for (String strAssetId : assetIds) {
            String newId = (String)ctx.getRealIds().get(strAssetId);
            if (newId != null) {
                AssetId assetId = new AssetId(UUID.fromString(newId));
                this.entityGroupService.addEntityToEntityGroup(ctx.getTenantId(), edgeAssetGroup.getId(), (EntityId)assetId);
                continue;
            }
            log.error("[{}][{}] Edge: {} references non existing asset.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entity.getName()});
            throw new ThingsboardRuntimeException();
        }
    }

    private void assignDevicesToEdge(SolutionInstallContext ctx, List<String> deviceIds, Edge entity) throws ThingsboardException {
        EntityGroup edgeDeviceGroup;
        if (deviceIds == null || deviceIds.isEmpty()) {
            return;
        }
        try {
            edgeDeviceGroup = (EntityGroup)this.entityGroupService.findOrCreateEdgeAllGroupAsync(ctx.getTenantId(), entity, entity.getName(), EntityType.TENANT, EntityType.DEVICE).get();
            ctx.register((EntityId)edgeDeviceGroup.getId());
            ctx.putIdToMap(edgeDeviceGroup.getOwnerId(), EntityType.DEVICE, edgeDeviceGroup.getName(), (EntityId)edgeDeviceGroup.getId());
        }
        catch (Exception e) {
            log.error("[{}] Failed to find or create edge all device group", (Object)ctx.getTenantId(), (Object)e);
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
        for (String strDeviceId : deviceIds) {
            String newId = (String)ctx.getRealIds().get(strDeviceId);
            if (newId != null) {
                DeviceId deviceId = new DeviceId(UUID.fromString(newId));
                this.entityGroupService.addEntityToEntityGroup(ctx.getTenantId(), edgeDeviceGroup.getId(), (EntityId)deviceId);
                continue;
            }
            log.error("[{}][{}] Edge: {} references non existing device.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), entity.getName()});
            throw new ThingsboardRuntimeException();
        }
    }

    private void provisionAlarmRules(SolutionInstallContext ctx) {
        List cfs = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "alarm_rules.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        cfs.addAll(this.loadListOfEntitiesFromDirectory(ctx.getSolutionId(), "alarm_rules", CalculatedField.class));
        cfs.forEach(cf -> ctx.register(this.createCalculatedField(cf, ctx)));
    }

    private void provisionCalculatedFields(SolutionInstallContext ctx) {
        List cfs = this.loadListOfEntitiesIfFileExists(ctx.getSolutionId(), "calculated_fields.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        cfs.addAll(this.loadListOfEntitiesFromDirectory(ctx.getSolutionId(), "calculated_fields", CalculatedFieldDefinition.class));
        ArrayList<CalculatedFieldDefinition> createOnly = new ArrayList<CalculatedFieldDefinition>();
        TreeMap<Integer, List> ordered = new TreeMap<Integer, List>();
        for (CalculatedFieldDefinition calculatedFieldDefinition : cfs) {
            if (calculatedFieldDefinition.getReprocessingOrder() == null || calculatedFieldDefinition.getReprocessingOrder() < 0) {
                createOnly.add(calculatedFieldDefinition);
                continue;
            }
            ordered.computeIfAbsent(calculatedFieldDefinition.getReprocessingOrder(), integer -> new ArrayList()).add(calculatedFieldDefinition);
        }
        createOnly.forEach(cf -> ctx.register(this.createCalculatedField((CalculatedField)cf, ctx)));
        for (Map.Entry entry : ordered.entrySet()) {
            Integer order = (Integer)entry.getKey();
            List cfDefs = (List)entry.getValue();
            log.debug("Starting reprocessing calculated fields for order: {}", (Object)order);
            ArrayList futures = new ArrayList();
            log.debug("Start reprocessing calculated fields for order {}", (Object)order);
            for (CalculatedFieldDefinition cfDef : cfDefs) {
                CalculatedField calculatedField = this.createCalculatedField((CalculatedField)cfDef, ctx);
                ctx.register(calculatedField);
                Iterable targetEntities = this.resolveTargetEntities(calculatedField);
                targetEntities.forEach(entityInfo -> futures.add(CompletableFuture.runAsync(() -> {
                    log.debug("Reprocessing calculated field: {}", (Object)calculatedField.getName());
                    this.reprocessCf(ctx, entityInfo, calculatedField);
                }, this.cfsReprocessingExecutor)));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            log.debug("Finished reprocessing calculated fields for order: {}", (Object)order);
        }
    }

    private Iterable<EntityInfo> resolveTargetEntities(CalculatedField cf) {
        EntityId cfEntityId = cf.getEntityId();
        TenantId tenantId = cf.getTenantId();
        return switch (24.$SwitchMap$org$thingsboard$server$common$data$EntityType[cfEntityId.getEntityType().ordinal()]) {
            case 1 -> List.of(this.deviceService.findDeviceEntityInfoById(tenantId, new DeviceId(cfEntityId.getId())));
            case 2 -> List.of(this.assetService.findAssetEntityInfoById(tenantId, new AssetId(cfEntityId.getId())));
            case 3 -> new PageDataIterable(pageLink -> this.deviceService.findDeviceEntityInfosByTenantIdAndDeviceProfileId(tenantId, new DeviceProfileId(cfEntityId.getId()), pageLink), 512);
            case 4 -> new PageDataIterable(pageLink -> this.assetService.findAssetEntityInfosByTenantIdAndAssetProfileId(tenantId, new AssetProfileId(cfEntityId.getId()), pageLink), 512);
            default -> throw new IllegalArgumentException("Unsupported CF entity type " + String.valueOf(cfEntityId.getEntityType()));
        };
    }

    private void reprocessCf(SolutionInstallContext ctx, EntityInfo entityInfo, CalculatedField cf) {
        try {
            long reprocessingStartTs = ctx.getOldestTelemetryTs();
            CfReprocessingTask task = this.createTask(ctx.getTenantId(), entityInfo, cf, reprocessingStartTs, System.currentTimeMillis());
            this.calculatedFieldReprocessingService.reprocess(task);
        }
        catch (Exception e) {
            log.error("Failed to reprocess calculated field {}", (Object)cf.getName(), (Object)e);
        }
    }

    private CfReprocessingTask createTask(TenantId tenantId, EntityInfo entityInfo, CalculatedField calculatedField, long startTs, long endTs) {
        return ((CfReprocessingTask.CfReprocessingTaskBuilder)((CfReprocessingTask.CfReprocessingTaskBuilder)CfReprocessingTask.builder().tenantId(tenantId)).retries(0)).calculatedField(calculatedField).entityInfo(entityInfo).startTs(startTs).endTs(endTs).build();
    }

    private CalculatedField createCalculatedField(CalculatedField cf, SolutionInstallContext ctx) {
        CalculatedFieldConfiguration calculatedFieldConfiguration;
        cf.setId(null);
        cf.setCreatedTime(0L);
        cf.setTenantId(ctx.getTenantId());
        cf.setDebugSettings(new DebugSettings(true, System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(15L)));
        Map realIds = ctx.getRealIds();
        EntityId entityId = cf.getEntityId();
        if (entityId != null) {
            String newEntityId = (String)realIds.get(entityId.getId().toString());
            if (newEntityId != null) {
                cf.setEntityId(EntityIdFactory.getByTypeAndUuid((EntityType)entityId.getEntityType(), (String)newEntityId));
            } else {
                log.error("[{}][{}] Calculated field: {} references non existing entity.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), cf.getName()});
                throw new ThingsboardRuntimeException();
            }
        }
        if ((calculatedFieldConfiguration = cf.getConfiguration()) instanceof ArgumentsBasedCalculatedFieldConfiguration) {
            ArgumentsBasedCalculatedFieldConfiguration argBasedCfg = (ArgumentsBasedCalculatedFieldConfiguration)calculatedFieldConfiguration;
            argBasedCfg.getArguments().forEach((key, argument) -> {
                EntityId refEntityId = argument.getRefEntityId();
                if (refEntityId != null) {
                    if (refEntityId.getEntityType() == EntityType.TENANT) {
                        argument.setRefEntityId((EntityId)ctx.getTenantId());
                    } else {
                        String newId = (String)realIds.get(refEntityId.getId().toString());
                        if (newId != null) {
                            argument.setRefEntityId(EntityIdFactory.getByTypeAndUuid((EntityType)refEntityId.getEntityType(), (String)newId));
                        } else {
                            log.error("[{}][{}] Calculated field: {} references non existing entity.", new Object[]{ctx.getTenantId(), ctx.getSolutionId(), cf.getName()});
                            throw new ThingsboardRuntimeException();
                        }
                    }
                }
            });
        }
        CalculatedField calculatedField = new CalculatedField(cf);
        return this.calculatedFieldService.save(calculatedField);
    }

    private RandomNameData generateRandomName(SolutionInstallContext ctx) {
        for (int i = 0; i < 10; ++i) {
            RandomNameData randomName = RandomNameUtil.next();
            User user = this.userService.findUserByEmail(ctx.getTenantId(), randomName.getEmail());
            if (user != null) continue;
            return randomName;
        }
        String firstName = StringUtils.randomAlphanumeric((int)5);
        String lastName = StringUtils.randomAlphanumeric((int)5);
        return new RandomNameData(firstName, lastName, firstName + "." + lastName + "@thingsboard.io");
    }

    private String randomize(String src, RandomNameData name) {
        return this.randomize(src, name, null);
    }

    private String randomize(String src, RandomNameData name, RandomNameData customer) {
        if (src == null) {
            return null;
        }
        String result = src.replace("$randomFirstName", name.getFirstName()).replace("$randomLastName", name.getLastName()).replace("$randomEmail", name.getEmail());
        if (customer != null) {
            result = result.replace("$customerFirstName", customer.getFirstName()).replace("$customerLastName", customer.getLastName()).replace("$customerEmail", customer.getEmail());
        }
        return result.replace("$random", StringUtils.randomAlphanumeric((int)10).toLowerCase());
    }

    private EntityGroup getCustomerGroupInfo(SolutionInstallContext ctx, EntityId entityId, String ugName) throws ExecutionException, InterruptedException {
        return this.getGroupInfo(ctx, entityId, EntityType.CUSTOMER, ugName);
    }

    private EntityGroup getUserGroupInfo(SolutionInstallContext ctx, EntityId entityId, String ugName) throws ExecutionException, InterruptedException {
        return this.getGroupInfo(ctx, entityId, EntityType.USER, ugName);
    }

    private EntityGroup getGroupInfo(SolutionInstallContext ctx, EntityId entityId, EntityType entityType, String ugName) throws ExecutionException, InterruptedException {
        EntityGroup ugEntity;
        Optional ugEntityOpt = this.entityGroupService.findEntityGroupByTypeAndName(ctx.getTenantId(), entityId, entityType, ugName);
        if (ugEntityOpt.isPresent()) {
            ugEntity = (EntityGroup)ugEntityOpt.get();
        } else {
            EntityGroup entityGroup = new EntityGroup();
            entityGroup.setName(ugName);
            entityGroup.setType(entityType);
            ugEntity = this.entityGroupService.saveEntityGroup(ctx.getTenantId(), entityId, entityGroup);
            ctx.register((EntityId)ugEntity.getId());
        }
        return ugEntity;
    }

    private void saveServerSideAttributes(SolutionInstallContext ctx, EntityId entityId, JsonNode attributes) {
        this.saveServerSideAttributes(ctx, entityId, attributes, null);
    }

    private void saveServerSideAttributes(SolutionInstallContext ctx, EntityId entityId, JsonNode attributes, RandomNameData randomNameData) {
        this.saveAttributes(ctx, entityId, attributes, randomNameData, AttributeScope.SERVER_SCOPE);
    }

    private void saveSharedAttributes(SolutionInstallContext ctx, EntityId entityId, JsonNode attributes) {
        if (!EntityType.DEVICE.equals((Object)entityId.getEntityType())) {
            throw new IllegalArgumentException(String.valueOf(entityId.getEntityType()) + " cannot have shared attributes.");
        }
        this.saveAttributes(ctx, entityId, attributes, null, AttributeScope.SHARED_SCOPE);
    }

    private void saveAttributes(SolutionInstallContext ctx, EntityId entityId, JsonNode attributes, RandomNameData randomNameData, AttributeScope attributeScope) {
        if (attributes != null && !attributes.isNull() && !attributes.isEmpty()) {
            attributes = this.prepareAttributes(attributes);
            log.info("[{}] Saving attributes: {}", (Object)entityId, (Object)attributes);
            if (randomNameData != null) {
                attributes = JacksonUtil.toJsonNode((String)this.randomize(JacksonUtil.toString((Object)attributes), randomNameData, null));
            }
            this.attributesService.save(ctx.getTenantId(), entityId, attributeScope, new ArrayList(JsonConverter.convertToAttributes((JsonElement)JsonParser.parseString((String)JacksonUtil.toString((Object)attributes)), (long)ctx.getOldestTelemetryTs())));
        }
    }

    private JsonNode prepareAttributes(JsonNode attributes) {
        ObjectNode attributesObj = (ObjectNode)attributes;
        attributes.fields().forEachRemaining(entry -> {
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isTextual() && this.isTimeExpression(value.asText())) {
                value = JacksonUtil.toJsonNode((String)this.parseTimeExpression(value.asText()));
            }
            attributesObj.set((String)entry.getKey(), value);
        });
        return attributesObj;
    }

    private boolean isTimeExpression(String text) {
        return Pattern.matches("\\$\\{currentTime(?:([+-])(\\d+)([mwdh]|min))?}", text);
    }

    private String parseTimeExpression(String timeExpression) {
        Matcher matcher = Pattern.compile("\\$\\{currentTime(?:([+-])(\\d+)([mwdh]|min))?}").matcher(timeExpression);
        if (!matcher.matches()) {
            return timeExpression;
        }
        String operator = matcher.group(1);
        String amountStr = matcher.group(2);
        String unit = matcher.group(3);
        ZonedDateTime now = ZonedDateTime.now();
        if (operator != null && amountStr != null && unit != null) {
            int amount = Integer.parseInt(amountStr);
            now = switch (unit) {
                case "m" -> {
                    if (operator.equals("+")) {
                        yield now.plusMonths(amount);
                    }
                    yield now.minusMonths(amount);
                }
                case "w" -> {
                    if (operator.equals("+")) {
                        yield now.plusWeeks(amount);
                    }
                    yield now.minusWeeks(amount);
                }
                case "d" -> {
                    if (operator.equals("+")) {
                        yield now.plusDays(amount);
                    }
                    yield now.minusDays(amount);
                }
                case "h" -> {
                    if (operator.equals("+")) {
                        yield now.plusHours(amount);
                    }
                    yield now.minusHours(amount);
                }
                case "min" -> {
                    if (operator.equals("+")) {
                        yield now.plusMinutes(amount);
                    }
                    yield now.minusMinutes(amount);
                }
                default -> throw new IllegalArgumentException("Unsupported time unit: " + unit);
            };
        }
        return String.valueOf(now.toInstant().toEpochMilli());
    }

    protected EntityGroup createEntityGroup(SolutionInstallContext ctx, EntityId ownerId, String name, EntityType type) {
        EntityGroup eg = new EntityGroup();
        eg.setName(name);
        eg.setType(type);
        eg.setOwnerId(ownerId);
        eg = this.entityGroupService.saveEntityGroup(ctx.getTenantId(), ownerId, eg);
        ctx.register((EntityId)eg.getId());
        ctx.putIdToMap(eg.getOwnerId(), type, name, (EntityId)eg.getId());
        log.info("[{}] Created entityGroup {}", (Object)ownerId, (Object)eg);
        return eg;
    }

    private EntityGroupId addEntityToGroup(SolutionInstallContext ctx, CustomerEntityDefinition entityDef, EntityId entityId) throws ThingsboardException {
        CustomerId customerId = (CustomerId)ctx.getIdFromMap(EntityType.CUSTOMER, entityDef.getCustomer());
        if (!StringUtils.isEmpty((String)entityDef.getGroup())) {
            Object ownerId = customerId == null ? ctx.getTenantId() : customerId;
            EntityGroupId egId = (EntityGroupId)ctx.getGroupIdFromMap((EntityId)ownerId, entityId.getEntityType(), entityDef.getGroup());
            if (egId == null) {
                if (EntityType.TENANT.equals((Object)ownerId.getEntityType())) {
                    log.info("Creating tenant {} group: {}", (Object)entityId.getEntityType(), (Object)entityDef.getGroup());
                    egId = this.createEntityGroup(ctx, (EntityId)ctx.getTenantId(), entityDef.getGroup(), entityId.getEntityType()).getId();
                } else {
                    log.info("[{}] Creating customer {} group: {}", new Object[]{entityDef.getCustomer(), entityId.getEntityType(), entityDef.getGroup()});
                    egId = this.createEntityGroup(ctx, (EntityId)customerId, entityDef.getGroup(), entityId.getEntityType()).getId();
                }
            }
            this.entityGroupService.addEntitiesToEntityGroup(ctx.getTenantId(), egId, Collections.singletonList(entityId));
            if (entityDef.isMakePublic()) {
                EntityGroup eg = this.entityGroupService.findEntityGroupById(ctx.getTenantId(), egId);
                TenantSolutionTemplateInstructions solutionInstructions = ctx.getSolutionInstructions();
                if (!eg.isPublic()) {
                    EntityId publicId = this.tbEntityGroupService.makePublic(ctx.getTenantId(), eg, ctx.getUser());
                    solutionInstructions.setPublicId(new CustomerId(publicId.getId()));
                } else if (solutionInstructions.getPublicId() == null) {
                    solutionInstructions.setPublicId(new CustomerId(this.customerService.findOrCreatePublicUserGroup(ctx.getTenantId(), ctx.getUser().getOwnerId()).getOwnerId().getId()));
                }
            }
            return egId;
        }
        if (entityDef.isMakePublic()) {
            throw new IllegalArgumentException("Entity is assigned to group 'All' only. Can't make entity public!");
        }
        return null;
    }

    private String getTypeLabel(EntityType type) {
        return type.name().toLowerCase().replace('_', ' ');
    }

    private <T> T loadEntityIfFileExists(String solutionId, String fileName, Class<T> clazz) {
        Path filePath = this.resolve(solutionId, new String[]{"entities", fileName});
        if (Files.exists(filePath, new LinkOption[0])) {
            return (T)JacksonUtil.readValue((File)filePath.toFile(), clazz);
        }
        return null;
    }

    private <T> List<T> loadListOfEntitiesIfFileExists(String solutionId, String fileName, TypeReference<List<T>> typeReference) {
        Path filePath = this.resolve(solutionId, new String[]{"entities", fileName});
        if (Files.exists(filePath, new LinkOption[0])) {
            return (List)JacksonUtil.readValue((File)filePath.toFile(), typeReference);
        }
        return new ArrayList();
    }

    private <T> List<T> loadListOfEntitiesFromDirectory(String solutionId, String dirName, Class<T> clazz) {
        Path dirPath = this.resolve(solutionId, new String[]{dirName});
        if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                for (Path filePath : Files.list(dirPath).collect(Collectors.toList())) {
                    result.add(JacksonUtil.readValue((File)filePath.toFile(), clazz));
                }
            }
            catch (IOException e) {
                log.warn("[{}] Failed to read directory: {}", new Object[]{solutionId, dirName, e});
                throw new RuntimeException(e);
            }
            return result;
        }
        return new ArrayList();
    }

    private void deleteEntity(TenantId tenantId, EntityId entityId, User user) {
        try {
            List<AlarmId> alarmIds = this.alarmService.findAlarms(tenantId, new AlarmQuery(entityId, new TimePageLink(Integer.MAX_VALUE), null, null, null, Boolean.valueOf(false))).getData().stream().map(Alarm::getId).collect(Collectors.toList());
            HashSet typesToRemove = new HashSet();
            alarmIds.forEach(alarmId -> {
                AlarmApiCallResult result = this.alarmService.delAlarm(tenantId, alarmId, false);
                if (result.isSuccessful()) {
                    typesToRemove.add(result.getAlarm().getType());
                }
            });
            this.alarmService.delAlarmTypes(tenantId, typesToRemove);
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete alarms for entity", (Object)entityId.getId(), (Object)e);
        }
        switch (24.$SwitchMap$org$thingsboard$server$common$data$EntityType[entityId.getEntityType().ordinal()]) {
            case 5: {
                this.tbCalculatedFieldService.delete(new CalculatedFieldId(entityId.getId()), user);
                break;
            }
            case 6: {
                RuleChainId ruleChainId = new RuleChainId(entityId.getId());
                this.ruleChainService.deleteRuleChainById(tenantId, ruleChainId);
                break;
            }
            case 3: {
                this.deviceProfileService.deleteDeviceProfile(tenantId, new DeviceProfileId(entityId.getId()));
                break;
            }
            case 4: {
                this.assetProfileService.deleteAssetProfile(tenantId, new AssetProfileId(entityId.getId()));
                break;
            }
            case 7: {
                this.dashboardService.deleteDashboard(tenantId, new DashboardId(entityId.getId()));
                break;
            }
            case 8: {
                this.roleService.deleteRole(tenantId, new RoleId(entityId.getId()));
                break;
            }
            case 9: {
                this.userService.deleteUser(tenantId, new UserId(entityId.getId()));
                break;
            }
            case 2: {
                this.tbAssetService.delete(new AssetId(entityId.getId()), user);
                break;
            }
            case 1: {
                this.tbDeviceService.delete(new DeviceId(entityId.getId()), user);
                break;
            }
            case 10: {
                this.customerService.deleteCustomer(tenantId, new CustomerId(entityId.getId()));
                break;
            }
            case 11: {
                this.entityGroupService.deleteEntityGroup(tenantId, new EntityGroupId(entityId.getId()));
                break;
            }
            case 12: {
                this.schedulerEventService.deleteSchedulerEvent(tenantId, new SchedulerEventId(entityId.getId()));
                break;
            }
            case 13: {
                this.tbEdgeService.delete(new EdgeId(entityId.getId()), user);
            }
        }
    }

    private JsonNode replaceIds(SolutionInstallContext ctx, JsonNode dashboardJson) {
        String jsonStr = JacksonUtil.toString((Object)dashboardJson);
        for (Map.Entry e : ctx.getRealIds().entrySet()) {
            jsonStr = jsonStr.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
        }
        return JacksonUtil.toJsonNode((String)jsonStr);
    }

    private String toCreatedEntitiesKey(String solutionId) {
        return solutionId + "_entities";
    }

    private String toStatusKey(String solutionId) {
        return solutionId + "_status";
    }

    private String toInstructionsKey(String solutionId) {
        return solutionId + "_instructions";
    }

    @ConstructorProperties(value={"installScripts", "deviceProfileService", "assetProfileService", "tbRuleChainService", "ruleChainService", "attributesService", "tsService", "dashboardService", "relationService", "deviceService", "tbDeviceService", "deviceCredentialsService", "assetService", "tbAssetService", "customerService", "userService", "calculatedFieldService", "tbCalculatedFieldService", "calculatedFieldReprocessingService", "tbEdgeService", "entityGroupService", "tbEntityGroupService", "groupPermissionService", "roleService", "systemSecurityService", "tbClusterService", "passwordEncoder", "tbQueueProducerProvider", "serviceInfoProvider", "partitionService", "tsSubService", "entityActionService", "alarmService", "schedulerEventService", "schedulerService", "deviceConnectivityService", "subscriptionService"})
    @Generated
    public DefaultSolutionService(InstallScripts installScripts, DeviceProfileService deviceProfileService, AssetProfileService assetProfileService, TbRuleChainService tbRuleChainService, RuleChainService ruleChainService, AttributesService attributesService, TimeseriesService tsService, DashboardService dashboardService, TbEntityRelationService relationService, DeviceService deviceService, TbDeviceService tbDeviceService, DeviceCredentialsService deviceCredentialsService, AssetService assetService, TbAssetService tbAssetService, CustomerService customerService, UserService userService, CalculatedFieldService calculatedFieldService, TbCalculatedFieldService tbCalculatedFieldService, CalculatedFieldReprocessingService calculatedFieldReprocessingService, TbEdgeService tbEdgeService, EntityGroupService entityGroupService, TbEntityGroupService tbEntityGroupService, GroupPermissionService groupPermissionService, RoleService roleService, SystemSecurityService systemSecurityService, TbClusterService tbClusterService, BCryptPasswordEncoder passwordEncoder, TbQueueProducerProvider tbQueueProducerProvider, TbServiceInfoProvider serviceInfoProvider, PartitionService partitionService, TelemetrySubscriptionService tsSubService, EntityActionService entityActionService, AlarmService alarmService, SchedulerEventService schedulerEventService, SchedulerService schedulerService, DeviceConnectivityService deviceConnectivityService, SubscriptionService subscriptionService) {
        this.installScripts = installScripts;
        this.deviceProfileService = deviceProfileService;
        this.assetProfileService = assetProfileService;
        this.tbRuleChainService = tbRuleChainService;
        this.ruleChainService = ruleChainService;
        this.attributesService = attributesService;
        this.tsService = tsService;
        this.dashboardService = dashboardService;
        this.relationService = relationService;
        this.deviceService = deviceService;
        this.tbDeviceService = tbDeviceService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.assetService = assetService;
        this.tbAssetService = tbAssetService;
        this.customerService = customerService;
        this.userService = userService;
        this.calculatedFieldService = calculatedFieldService;
        this.tbCalculatedFieldService = tbCalculatedFieldService;
        this.calculatedFieldReprocessingService = calculatedFieldReprocessingService;
        this.tbEdgeService = tbEdgeService;
        this.entityGroupService = entityGroupService;
        this.tbEntityGroupService = tbEntityGroupService;
        this.groupPermissionService = groupPermissionService;
        this.roleService = roleService;
        this.systemSecurityService = systemSecurityService;
        this.tbClusterService = tbClusterService;
        this.passwordEncoder = passwordEncoder;
        this.tbQueueProducerProvider = tbQueueProducerProvider;
        this.serviceInfoProvider = serviceInfoProvider;
        this.partitionService = partitionService;
        this.tsSubService = tsSubService;
        this.entityActionService = entityActionService;
        this.alarmService = alarmService;
        this.schedulerEventService = schedulerEventService;
        this.schedulerService = schedulerService;
        this.deviceConnectivityService = deviceConnectivityService;
        this.subscriptionService = subscriptionService;
    }
}

