/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sms;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.NestedRuntimeException;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.sms.SmsSender;
import org.thingsboard.rule.engine.api.sms.SmsSenderFactory;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.sms.config.SmsProviderConfiguration;
import org.thingsboard.server.common.data.sms.config.TestSmsRequest;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.sms.DefaultSmsService;

@Service
public class DefaultSmsService
implements SmsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSmsService.class);
    private static final String SMS_SETTINGS_KEY = "sms";
    @Value(value="${actors.rule.allow_system_sms_service}")
    private boolean allowSystemSmsService;
    private final SmsSenderFactory smsSenderFactory;
    private final AdminSettingsService adminSettingsService;
    private final TbApiUsageStateService apiUsageStateService;
    private final TbApiUsageReportClient apiUsageClient;
    private final SecretConfigurationService secretConfigurationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSms(TenantId tenantId, CustomerId customerId, String[] numbersTo, String message) throws ThingsboardException {
        ConfigEntry configEntry = this.getConfig(tenantId, this.allowSystemSmsService);
        SmsProviderConfiguration configuration = (SmsProviderConfiguration)JacksonUtil.convertValue((Object)configEntry.jsonConfig, SmsProviderConfiguration.class);
        SmsSender smsSender = this.smsSenderFactory.createSmsSender(configuration);
        if (!configEntry.isSystem || this.apiUsageStateService.getApiUsageState(tenantId).isSmsSendEnabled()) {
            int smsCount = 0;
            try {
                for (String numberTo : numbersTo) {
                    smsCount += this.sendSms(smsSender, numberTo, message);
                }
            }
            finally {
                if (configEntry.isSystem && smsCount > 0) {
                    this.apiUsageClient.report(tenantId, customerId, ApiUsageRecordKey.SMS_EXEC_COUNT, (long)smsCount);
                }
            }
        } else {
            throw new RuntimeException("SMS sending is disabled due to API limits!");
        }
    }

    public void sendTestSms(TenantId tenantId, TestSmsRequest testSmsRequest) throws ThingsboardException {
        SmsSender testSmsSender;
        try {
            SmsProviderConfiguration configuration = (SmsProviderConfiguration)this.secretConfigurationService.replaceSecretUsages(tenantId, (Object)testSmsRequest.getProviderConfiguration(), SmsProviderConfiguration.class);
            testSmsSender = this.smsSenderFactory.createSmsSender(configuration);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        this.sendSms(testSmsSender, testSmsRequest.getNumberTo(), testSmsRequest.getMessage());
        testSmsSender.destroy();
    }

    public boolean isConfigured(TenantId tenantId) {
        try {
            ConfigEntry configEntry = this.getConfig(tenantId, this.allowSystemSmsService);
            JacksonUtil.convertValue((Object)configEntry.jsonConfig, SmsProviderConfiguration.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected int sendSms(SmsSender smsSender, String numberTo, String message) throws ThingsboardException {
        try {
            int sentSms = smsSender.sendSms(numberTo, message);
            log.trace("Successfully sent sms to number: {}", (Object)numberTo);
            return sentSms;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private ConfigEntry getConfig(TenantId tenantId, boolean allowSystemSmsService) throws ThingsboardException {
        try {
            JsonNode useSystemSmsSettingsNode;
            AdminSettings adminSettings;
            JsonNode jsonConfig = null;
            boolean isSystem = false;
            if (tenantId != null && !tenantId.isNullUid() && (adminSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, SMS_SETTINGS_KEY)) != null && ((useSystemSmsSettingsNode = (jsonConfig = adminSettings.getJsonValue()).get("useSystemSmsSettings")) == null || useSystemSmsSettingsNode.asBoolean())) {
                jsonConfig = null;
            }
            if (jsonConfig == null) {
                if (!allowSystemSmsService) {
                    throw new RuntimeException("Access to System SMS Service is forbidden!");
                }
                AdminSettings settings = this.adminSettingsService.findAdminSettingsByKey(tenantId, SMS_SETTINGS_KEY);
                if (settings != null) {
                    jsonConfig = settings.getJsonValue();
                    isSystem = true;
                }
            }
            if (jsonConfig == null) {
                throw new IncorrectParameterException("Failed to get sms provider configuration. Settings not found!");
            }
            this.secretConfigurationService.replaceSecretUsages(isSystem ? TenantId.SYS_TENANT_ID : tenantId, jsonConfig);
            return new ConfigEntry(jsonConfig, isSystem);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private ThingsboardException handleException(Exception exception) {
        String message = exception instanceof NestedRuntimeException ? ((NestedRuntimeException)exception).getMostSpecificCause().getMessage() : exception.getMessage();
        log.warn("Unable to send SMS: {}", (Object)message);
        return new ThingsboardException(String.format("Unable to send SMS: %s", message), ThingsboardErrorCode.GENERAL);
    }

    @ConstructorProperties(value={"smsSenderFactory", "adminSettingsService", "apiUsageStateService", "apiUsageClient", "secretConfigurationService"})
    @Generated
    public DefaultSmsService(SmsSenderFactory smsSenderFactory, AdminSettingsService adminSettingsService, TbApiUsageStateService apiUsageStateService, TbApiUsageReportClient apiUsageClient, SecretConfigurationService secretConfigurationService) {
        this.smsSenderFactory = smsSenderFactory;
        this.adminSettingsService = adminSettingsService;
        this.apiUsageStateService = apiUsageStateService;
        this.apiUsageClient = apiUsageClient;
        this.secretConfigurationService = secretConfigurationService;
    }
}

