/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sms;

import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.sms.SmsSender;
import org.thingsboard.rule.engine.api.sms.exception.SmsParseException;

public abstract class AbstractSmsSender
implements SmsSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSmsSender.class);
    protected static final Pattern E_164_PHONE_NUMBER_PATTERN = Pattern.compile("^\\+[1-9]\\d{1,14}$");
    private static final int MAX_SMS_MESSAGE_LENGTH = 1600;
    private static final int MAX_SMS_SEGMENT_LENGTH = 70;

    protected String validatePhoneNumber(String phoneNumber) throws SmsParseException {
        if (!E_164_PHONE_NUMBER_PATTERN.matcher(phoneNumber = phoneNumber.trim()).matches()) {
            throw new SmsParseException("Invalid phone number format. Phone number must be in E.164 format.");
        }
        return phoneNumber;
    }

    protected String prepareMessage(String message) {
        if ((message = message.replaceAll("^\"|\"$", "").replaceAll("\\\\n", "\n")).length() > 1600) {
            log.warn("SMS message exceeds maximum symbols length and will be truncated");
            message = message.substring(0, 1600);
        }
        return message;
    }

    protected int countMessageSegments(String message) {
        return (int)Math.ceil((double)message.length() / 70.0);
    }
}

