/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Dashboard;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.HasOwnerId;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.service.security.model.SecurityUser;

public interface OwnersCacheService {
    public Set<EntityId> fetchOwnersHierarchy(TenantId var1, EntityId var2);

    public Set<EntityId> getOwners(TenantId var1, EntityId var2, HasOwnerId var3);

    public Set<EntityId> getOwners(TenantId var1, EntityGroupId var2);

    public EntityId getOwner(TenantId var1, EntityId var2);

    public void clearOwners(EntityId var1);

    public Set<EntityId> getChildOwners(TenantId var1, EntityId var2);

    public void changeDashboardOwner(TenantId var1, EntityId var2, Dashboard var3) throws ThingsboardException;

    public void changeUserOwner(TenantId var1, EntityId var2, User var3) throws ThingsboardException;

    public void changeCustomerOwner(TenantId var1, EntityId var2, Customer var3) throws ThingsboardException;

    public void changeEntityViewOwner(TenantId var1, EntityId var2, EntityView var3) throws ThingsboardException;

    public void changeEdgeOwner(TenantId var1, EntityId var2, Edge var3) throws ThingsboardException;

    public void changeAssetOwner(TenantId var1, EntityId var2, Asset var3) throws ThingsboardException;

    public void changeDeviceOwner(TenantId var1, EntityId var2, Device var3) throws ThingsboardException;

    public void changeEntityOwner(TenantId var1, EntityId var2, EntityId var3) throws ThingsboardException;

    public boolean isChildOwner(TenantId var1, CustomerId var2, CustomerId var3);

    public <E extends BaseData<? extends UUIDBased>> PageData<E> getGroupEntities(TenantId var1, SecurityUser var2, EntityType var3, Operation var4, PageLink var5, Function<List<EntityGroupId>, PageData<E>> var6) throws Exception;

    public void changeEntityOwner(TenantId var1, EntityId var2, EntityId var3, EntityId var4) throws ThingsboardException;

    public Set<EntityId> getOwnedEntities(TenantId var1, EntityId var2);
}

