/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.permission;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityGroupId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.permission.GroupPermission;
import org.thingsboard.server.common.data.permission.MergedGroupPermissionInfo;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.common.data.permission.Operation;
import org.thingsboard.server.common.data.permission.Resource;
import org.thingsboard.server.common.data.role.Role;
import org.thingsboard.server.common.data.role.RoleType;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.grouppermission.GroupPermissionService;
import org.thingsboard.server.dao.role.RoleService;
import org.thingsboard.server.dao.user.UserPermissionCacheKey;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Service
public class DefaultUserPermissionsService
implements UserPermissionsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserPermissionsService.class);
    @Autowired
    private TbTransactionalCache<UserPermissionCacheKey, MergedUserPermissions> cache;
    private static final MergedUserPermissions sysAdminPermissions;
    @Autowired
    private EntityGroupService entityGroupService;
    @Autowired
    private GroupPermissionService groupPermissionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    public MergedUserPermissions getMergedPermissions(User user, boolean isPublic) throws ThingsboardException {
        if (Authority.SYS_ADMIN.equals((Object)user.getAuthority())) {
            return sysAdminPermissions;
        }
        MergedUserPermissions result = this.getMergedPermissionsFromCache(user.getTenantId(), user.getCustomerId(), user.getId());
        if (result == null) {
            ListenableFuture groups;
            if (isPublic) {
                ListenableFuture publicUserGroup = this.entityGroupService.findPublicUserGroupAsync(user.getTenantId(), user.getCustomerId());
                groups = Futures.transform((ListenableFuture)publicUserGroup, groupOptional -> groupOptional.map(entityGroup -> Collections.singletonList(entityGroup.getId())).orElse(Collections.emptyList()), (Executor)MoreExecutors.directExecutor());
            } else {
                groups = this.entityGroupService.findEntityGroupsForEntityAsync(user.getTenantId(), (EntityId)user.getId());
            }
            ListenableFuture permissions = Futures.transformAsync((ListenableFuture)groups, (AsyncFunction)this.toGroupPermissionsList(user.getTenantId()), (Executor)this.dbCallbackExecutorService);
            try {
                result = (MergedUserPermissions)Futures.transform((ListenableFuture)permissions, groupPermissions -> this.toMergedUserPermissions(user.getTenantId(), groupPermissions), (Executor)this.dbCallbackExecutorService).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
            }
            this.putMergedPermissionsToCache(user.getTenantId(), user.getCustomerId(), user.getId(), result);
        }
        return result;
    }

    public void onRoleUpdated(Role role) throws ThingsboardException {
        PageData groupPermissions = this.groupPermissionService.findGroupPermissionByTenantIdAndRoleId(role.getTenantId(), role.getId(), new PageLink(Integer.MAX_VALUE));
        HashSet<EntityGroupId> uniqueUserGroups = new HashSet<EntityGroupId>();
        for (GroupPermission gpe : groupPermissions.getData()) {
            uniqueUserGroups.add(gpe.getUserGroupId());
        }
        this.evictCacheForUserGroups(role.getTenantId(), uniqueUserGroups, false);
    }

    public void onGroupPermissionUpdated(GroupPermission groupPermission) throws ThingsboardException {
        this.evictCacheForUserGroups(groupPermission.getTenantId(), Collections.singleton(groupPermission.getUserGroupId()), groupPermission.isPublic());
    }

    public void onGroupPermissionDeleted(GroupPermission groupPermission) throws ThingsboardException {
        this.evictCacheForUserGroups(groupPermission.getTenantId(), Collections.singleton(groupPermission.getUserGroupId()), groupPermission.isPublic());
    }

    public void onUserUpdatedOrRemoved(User user) {
        this.evictMergedPermissionsToCache(user.getTenantId(), user.getCustomerId(), (EntityId)user.getId());
    }

    private void evictCacheForUserGroups(TenantId tenantId, Set<EntityGroupId> uniqueUserGroups, boolean isPublic) throws ThingsboardException {
        HashMap<EntityId, Set> usersByOwnerMap = new HashMap<EntityId, Set>();
        for (EntityGroupId userGroupId : uniqueUserGroups) {
            EntityGroup userGroup = this.entityGroupService.findEntityGroupById(tenantId, userGroupId);
            try {
                List entityIds = isPublic ? Collections.singletonList(new UserId(EntityId.NULL_UUID)) : (List)this.entityGroupService.findAllEntityIdsAsync(tenantId, userGroupId, new PageLink(Integer.MAX_VALUE)).get();
                usersByOwnerMap.computeIfAbsent(userGroup.getOwnerId(), ownerId -> new HashSet()).addAll(entityIds);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
            }
        }
        usersByOwnerMap.forEach((ownerId, userIds) -> userIds.forEach(userId -> this.evictMergedPermissionsToCache(tenantId, EntityType.CUSTOMER.equals((Object)ownerId.getEntityType()) ? new CustomerId(ownerId.getId()) : new CustomerId(CustomerId.NULL_UUID), userId)));
    }

    private MergedUserPermissions getMergedPermissionsFromCache(TenantId tenantId, CustomerId customerId, UserId userId) {
        TbCacheValueWrapper cacheValueWrapper = this.cache.get((Serializable)new UserPermissionCacheKey(tenantId, customerId, (EntityId)userId));
        if (cacheValueWrapper == null) {
            log.debug("[{}][{}][{}] Not user permissions in cache", new Object[]{tenantId, customerId, userId});
            return null;
        }
        return (MergedUserPermissions)cacheValueWrapper.get();
    }

    private void putMergedPermissionsToCache(TenantId tenantId, CustomerId customerId, UserId userId, MergedUserPermissions permissions) {
        log.debug("[{}][{}][{}] Pushing user permissions to cache: {}", new Object[]{tenantId, customerId, userId, permissions});
        this.cache.put((Serializable)new UserPermissionCacheKey(tenantId, customerId, (EntityId)userId), (Serializable)permissions);
    }

    private void evictMergedPermissionsToCache(TenantId tenantId, CustomerId customerId, EntityId userId) {
        log.debug("[{}][{}][{}] Evict user permissions to cache", new Object[]{tenantId, customerId, userId});
        this.cache.evict((Serializable)new UserPermissionCacheKey(tenantId, customerId, userId));
    }

    private AsyncFunction<List<EntityGroupId>, List<GroupPermission>> toGroupPermissionsList(TenantId tenantId) {
        return groupIds -> {
            ArrayList result = new ArrayList(groupIds.size());
            for (EntityGroupId userGroupId : groupIds) {
                result.addAll(this.groupPermissionService.findGroupPermissionListByTenantIdAndUserGroupId(tenantId, userGroupId));
            }
            return Futures.immediateFuture(result);
        };
    }

    private MergedUserPermissions toMergedUserPermissions(TenantId tenantId, List<GroupPermission> groupPermissions) {
        HashMap genericPermissions = new HashMap();
        HashMap groupSpecificPermissions = new HashMap();
        for (GroupPermission groupPermission : groupPermissions) {
            Role role = this.roleService.findRoleById(tenantId, groupPermission.getRoleId());
            if (role.getType() == RoleType.GENERIC) {
                this.addGenericRolePermissions(role, genericPermissions);
                continue;
            }
            this.addGroupSpecificRolePermissions(role, groupSpecificPermissions, groupPermission);
        }
        return new MergedUserPermissions(genericPermissions, groupSpecificPermissions);
    }

    private void addGenericRolePermissions(Role role, Map<Resource, Set<Operation>> target) {
        HashMap<Resource, List> rolePermissions = new HashMap<Resource, List>();
        for (Resource resource2 : Resource.values()) {
            if (!role.getPermissions().has(resource2.name())) continue;
            ArrayList operations2 = new ArrayList();
            rolePermissions.put(resource2, operations2);
            role.getPermissions().get(resource2.name()).forEach(node -> operations2.add(Operation.valueOf((String)node.asText())));
        }
        rolePermissions.forEach((resource, operations) -> target.computeIfAbsent((Resource)resource, r -> new HashSet()).addAll(operations));
    }

    private void addGroupSpecificRolePermissions(Role role, Map<EntityGroupId, MergedGroupPermissionInfo> target, GroupPermission groupPermission) {
        ArrayList roleOperations = new ArrayList();
        role.getPermissions().forEach(node -> roleOperations.add(Operation.valueOf((String)node.asText())));
        target.computeIfAbsent(groupPermission.getEntityGroupId(), id -> new MergedGroupPermissionInfo(groupPermission.getEntityGroupType(), new HashSet())).getOperations().addAll(roleOperations);
    }

    static {
        HashMap<Resource, Set<Operation>> sysAdminGenericPermissions = new HashMap<Resource, Set<Operation>>();
        sysAdminGenericPermissions.put(Resource.PROFILE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.ADMIN_SETTINGS, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.DASHBOARD, Set.of(Operation.READ));
        sysAdminGenericPermissions.put(Resource.ALARM, Set.of(Operation.READ));
        sysAdminGenericPermissions.put(Resource.TENANT, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.TENANT_PROFILE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.RULE_CHAIN, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.USER, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.WIDGETS_BUNDLE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.WIDGET_TYPE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.WHITE_LABELING, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.TB_RESOURCE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.NOTIFICATION, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.DOMAIN, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.OAUTH2_CLIENT, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.OAUTH2_CONFIGURATION_TEMPLATE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.CUSTOM_MENU, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.MOBILE_APP, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.MOBILE_APP_BUNDLE, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.MOBILE_APP_SETTINGS, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.SECRET, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.API_KEY, Set.of(Operation.ALL));
        sysAdminGenericPermissions.put(Resource.QUEUE, Set.of(Operation.ALL));
        sysAdminPermissions = new MergedUserPermissions(sysAdminGenericPermissions, new HashMap());
    }
}

