/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.model.token;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;

@Component
public class OAuth2AppTokenFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuth2AppTokenFactory.class);
    private static final String CALLBACK_URL_SCHEME = "callbackUrlScheme";
    private static final long MAX_EXPIRATION_TIME_DIFF_MS = TimeUnit.MINUTES.toMillis(5L);

    public String validateTokenAndGetCallbackUrlScheme(String appPackage, String appToken, String appSecret) {
        Jws jwsClaims;
        try {
            jwsClaims = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(appSecret))).build().parseSignedClaims((CharSequence)appToken);
        }
        catch (MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid Application token: ", ex);
        }
        catch (ExpiredJwtException expiredEx) {
            throw new IllegalArgumentException("Application token expired", expiredEx);
        }
        Claims claims = (Claims)jwsClaims.getPayload();
        Date expiration = claims.getExpiration();
        if (expiration == null) {
            throw new IllegalArgumentException("Application token must have expiration date");
        }
        long timeDiff = expiration.getTime() - System.currentTimeMillis();
        if (timeDiff > MAX_EXPIRATION_TIME_DIFF_MS) {
            throw new IllegalArgumentException("Application token expiration time can't be longer than 5 minutes");
        }
        if (!claims.getIssuer().equals(appPackage)) {
            throw new IllegalArgumentException("Application token issuer doesn't match application package");
        }
        String callbackUrlScheme = (String)claims.get(CALLBACK_URL_SCHEME, String.class);
        if (StringUtils.isEmpty((String)callbackUrlScheme)) {
            throw new IllegalArgumentException("Application token doesn't have callbackUrlScheme");
        }
        return callbackUrlScheme;
    }
}

