/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.model.token;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsBuilder;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.common.data.security.model.JwtToken;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;
import org.thingsboard.server.service.security.exception.JwtExpiredTokenException;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.UserPrincipal;
import org.thingsboard.server.service.security.model.token.AccessJwtToken;
import org.thingsboard.server.service.security.permission.UserPermissionsService;

@Component
public class JwtTokenFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenFactory.class);
    public static int KEY_LENGTH = Jwts.SIG.HS512.getKeyBitLength();
    private static final String SCOPES = "scopes";
    private static final String USER_GROUP_IDS = "userGroupIds";
    private static final String USER_ID = "userId";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String ENABLED = "enabled";
    private static final String IS_PUBLIC = "isPublic";
    private static final String TENANT_ID = "tenantId";
    private static final String CUSTOMER_ID = "customerId";
    private static final String SESSION_ID = "sessionId";
    @Lazy
    private final JwtSettingsService jwtSettingsService;
    private final UserPermissionsService userPermissionsService;
    private volatile JwtParser jwtParser;
    private volatile SecretKey secretKey;

    public AccessJwtToken createAccessJwtToken(SecurityUser securityUser) {
        if (securityUser.getAuthority() == null) {
            throw new IllegalArgumentException("User doesn't have any privileges");
        }
        UserPrincipal principal = securityUser.getUserPrincipal();
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)Jwts.claims().subject(principal.getValue());
        JwtBuilder jwtBuilder = this.setUpToken(securityUser, securityUser.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()), (long)this.jwtSettingsService.getJwtSettings().getTokenExpirationTime().intValue(), claimsBuilder);
        jwtBuilder.claim(FIRST_NAME, (Object)securityUser.getFirstName()).claim(LAST_NAME, (Object)securityUser.getLastName()).claim(ENABLED, (Object)securityUser.isEnabled()).claim(IS_PUBLIC, (Object)(principal.getType() == UserPrincipal.Type.PUBLIC_ID ? 1 : 0));
        if (securityUser.getTenantId() != null) {
            jwtBuilder.claim(TENANT_ID, (Object)securityUser.getTenantId().getId().toString());
        }
        if (securityUser.getCustomerId() != null) {
            jwtBuilder.claim(CUSTOMER_ID, (Object)securityUser.getCustomerId().getId().toString());
        }
        String token = jwtBuilder.compact();
        return new AccessJwtToken(token, (Claims)claimsBuilder.build());
    }

    public SecurityUser parseAccessJwtToken(String token) {
        Jws jwsClaims = this.parseTokenClaims(token);
        Claims claims = (Claims)jwsClaims.getPayload();
        String subject = claims.getSubject();
        List scopes = (List)claims.get(SCOPES, List.class);
        if (scopes == null || scopes.isEmpty()) {
            throw new IllegalArgumentException("JWT Token doesn't have any scopes");
        }
        Authority authority = Authority.parse((String)((String)scopes.get(0)));
        SecurityUser securityUser = new SecurityUser(new UserId(UUID.fromString((String)claims.get(USER_ID, String.class))));
        securityUser.setEmail(subject);
        securityUser.setAuthority(authority);
        String tenantId = (String)claims.get(TENANT_ID, String.class);
        if (tenantId != null) {
            securityUser.setTenantId(TenantId.fromUUID((UUID)UUID.fromString(tenantId)));
        } else if (authority == Authority.SYS_ADMIN) {
            securityUser.setTenantId(TenantId.SYS_TENANT_ID);
        }
        String customerId = (String)claims.get(CUSTOMER_ID, String.class);
        if (customerId != null) {
            securityUser.setCustomerId(new CustomerId(UUID.fromString(customerId)));
        }
        if (claims.get(SESSION_ID, String.class) != null) {
            securityUser.setSessionId((String)claims.get(SESSION_ID, String.class));
        }
        boolean isPublic = false;
        if (authority != Authority.PRE_VERIFICATION_TOKEN) {
            if (authority != Authority.MFA_CONFIGURATION_TOKEN) {
                securityUser.setFirstName((String)claims.get(FIRST_NAME, String.class));
                securityUser.setLastName((String)claims.get(LAST_NAME, String.class));
                securityUser.setEnabled(((Boolean)claims.get(ENABLED, Boolean.class)).booleanValue());
                isPublic = (Boolean)claims.get(IS_PUBLIC, Boolean.class);
            }
            try {
                securityUser.setUserPermissions(this.userPermissionsService.getMergedPermissions((User)securityUser, isPublic));
            }
            catch (Exception e) {
                throw new BadCredentialsException("Failed to get user permissions", (Throwable)e);
            }
        }
        UserPrincipal principal = new UserPrincipal(isPublic ? UserPrincipal.Type.PUBLIC_ID : UserPrincipal.Type.USER_NAME, subject);
        securityUser.setUserPrincipal(principal);
        return securityUser;
    }

    public JwtToken createRefreshToken(SecurityUser securityUser) {
        UserPrincipal principal = securityUser.getUserPrincipal();
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)Jwts.claims().subject(principal.getValue());
        String token = this.setUpToken(securityUser, Collections.singletonList(Authority.REFRESH_TOKEN.name()), (long)this.jwtSettingsService.getJwtSettings().getRefreshTokenExpTime().intValue(), claimsBuilder).claim(IS_PUBLIC, (Object)(principal.getType() == UserPrincipal.Type.PUBLIC_ID ? 1 : 0)).id(UUID.randomUUID().toString()).compact();
        return new AccessJwtToken(token, (Claims)claimsBuilder.build());
    }

    public SecurityUser parseRefreshToken(String token) {
        Jws jwsClaims = this.parseTokenClaims(token);
        Claims claims = (Claims)jwsClaims.getPayload();
        String subject = claims.getSubject();
        List scopes = (List)claims.get(SCOPES, List.class);
        if (scopes == null || scopes.isEmpty()) {
            throw new IllegalArgumentException("Refresh Token doesn't have any scopes");
        }
        if (!((String)scopes.get(0)).equals(Authority.REFRESH_TOKEN.name())) {
            throw new IllegalArgumentException("Invalid Refresh Token scope");
        }
        boolean isPublic = (Boolean)claims.get(IS_PUBLIC, Boolean.class);
        UserPrincipal principal = new UserPrincipal(isPublic ? UserPrincipal.Type.PUBLIC_ID : UserPrincipal.Type.USER_NAME, subject);
        SecurityUser securityUser = new SecurityUser(new UserId(UUID.fromString((String)claims.get(USER_ID, String.class))));
        securityUser.setUserPrincipal(principal);
        if (claims.get(SESSION_ID, String.class) != null) {
            securityUser.setSessionId((String)claims.get(SESSION_ID, String.class));
        }
        return securityUser;
    }

    public JwtToken createMfaToken(SecurityUser user, Authority scope, Integer expirationTime) {
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)Jwts.claims().subject(user.getEmail());
        JwtBuilder jwtBuilder = this.setUpToken(user, Collections.singletonList(scope.name()), (long)expirationTime.intValue(), claimsBuilder).claim(TENANT_ID, (Object)user.getTenantId().toString());
        if (user.getCustomerId() != null) {
            jwtBuilder.claim(CUSTOMER_ID, (Object)user.getCustomerId().toString());
        }
        return new AccessJwtToken(jwtBuilder.compact(), (Claims)claimsBuilder.build());
    }

    public void reload() {
        this.getSecretKey(true);
        this.getJwtParser(true);
    }

    private JwtBuilder setUpToken(SecurityUser securityUser, List<String> scopes, long expirationTime, ClaimsBuilder claimsBuilder) {
        if (StringUtils.isBlank((String)securityUser.getEmail())) {
            throw new IllegalArgumentException("Cannot create JWT Token without username/email");
        }
        ((ClaimsBuilder)claimsBuilder.add((Object)USER_ID, (Object)securityUser.getId().getId().toString())).add((Object)SCOPES, scopes);
        if (securityUser.getSessionId() != null) {
            claimsBuilder.add((Object)SESSION_ID, (Object)securityUser.getSessionId());
        }
        ZonedDateTime currentTime = ZonedDateTime.now();
        claimsBuilder.expiration(Date.from(currentTime.plusSeconds(expirationTime).toInstant()));
        return Jwts.builder().claims((Map)claimsBuilder.build()).issuer(this.jwtSettingsService.getJwtSettings().getTokenIssuer()).issuedAt(Date.from(currentTime.toInstant())).signWith((Key)this.getSecretKey(false), (SecureDigestAlgorithm)Jwts.SIG.HS512);
    }

    public Jws<Claims> parseTokenClaims(String token) {
        try {
            return this.getJwtParser(false).parseSignedClaims((CharSequence)token);
        }
        catch (MalformedJwtException | UnsupportedJwtException | IllegalArgumentException ex) {
            log.debug("Invalid JWT Token", ex);
            throw new BadCredentialsException("Invalid JWT token: ", ex);
        }
        catch (ExpiredJwtException | SignatureException expiredEx) {
            log.debug("JWT Token is expired", expiredEx);
            throw new JwtExpiredTokenException(token, "JWT Token expired", expiredEx);
        }
    }

    public JwtPair createTokenPair(SecurityUser securityUser) {
        securityUser.setSessionId(UUID.randomUUID().toString());
        AccessJwtToken accessToken = this.createAccessJwtToken(securityUser);
        JwtToken refreshToken = this.createRefreshToken(securityUser);
        return new JwtPair(accessToken.token(), refreshToken.token());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getSecretKey(boolean forceReload) {
        if (this.secretKey == null || forceReload) {
            JwtTokenFactory jwtTokenFactory = this;
            synchronized (jwtTokenFactory) {
                if (this.secretKey == null || forceReload) {
                    byte[] decodedToken = Base64.getDecoder().decode(this.jwtSettingsService.getJwtSettings().getTokenSigningKey());
                    this.secretKey = new SecretKeySpec(decodedToken, "HmacSHA512");
                }
            }
        }
        return this.secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JwtParser getJwtParser(boolean forceReload) {
        if (this.jwtParser == null || forceReload) {
            JwtTokenFactory jwtTokenFactory = this;
            synchronized (jwtTokenFactory) {
                if (this.jwtParser == null || forceReload) {
                    this.jwtParser = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(this.jwtSettingsService.getJwtSettings().getTokenSigningKey()))).build();
                }
            }
        }
        return this.jwtParser;
    }

    @ConstructorProperties(value={"jwtSettingsService", "userPermissionsService"})
    @Generated
    public JwtTokenFactory(@Lazy JwtSettingsService jwtSettingsService, UserPermissionsService userPermissionsService) {
        this.jwtSettingsService = jwtSettingsService;
        this.userPermissionsService = userPermissionsService;
    }
}

