/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.model;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.permission.MergedUserPermissions;
import org.thingsboard.server.service.security.model.UserPrincipal;

public class SecurityUser
extends User {
    private static final long serialVersionUID = -797397440703066079L;
    private Collection<GrantedAuthority> authorities;
    private boolean enabled;
    private UserPrincipal userPrincipal;
    private MergedUserPermissions userPermissions;
    private String sessionId = UUID.randomUUID().toString();

    public SecurityUser() {
    }

    public SecurityUser(UserId id) {
        super(id);
    }

    public SecurityUser(User user, boolean enabled, UserPrincipal userPrincipal, MergedUserPermissions userPermissions) {
        super(user);
        this.enabled = enabled;
        this.userPrincipal = userPrincipal;
        this.userPermissions = userPermissions;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        if (this.authorities == null) {
            this.authorities = Stream.of(this.getAuthority()).map(authority -> new SimpleGrantedAuthority(authority.name())).collect(Collectors.toList());
        }
        return this.authorities;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public UserPrincipal getUserPrincipal() {
        return this.userPrincipal;
    }

    @Generated
    public void setUserPrincipal(UserPrincipal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    @Generated
    public MergedUserPermissions getUserPermissions() {
        return this.userPermissions;
    }

    @Generated
    public void setUserPermissions(MergedUserPermissions userPermissions) {
        this.userPermissions = userPermissions;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

