/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.security.model.JwtPair;
import org.thingsboard.server.service.security.auth.MfaAuthenticationToken;
import org.thingsboard.server.service.security.auth.MfaConfigurationToken;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.JwtTokenFactory;

@Component(value="defaultAuthenticationSuccessHandler")
public class RestAwareAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestAwareAuthenticationSuccessHandler.class);
    private final JwtTokenFactory tokenFactory;
    private final TwoFaConfigManager twoFaConfigManager;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        SecurityUser securityUser = (SecurityUser)authentication.getPrincipal();
        JwtPair tokenPair = authentication instanceof MfaAuthenticationToken ? this.createMfaTokenPair(securityUser, Authority.PRE_VERIFICATION_TOKEN) : (authentication instanceof MfaConfigurationToken ? this.createMfaTokenPair(securityUser, Authority.MFA_CONFIGURATION_TOKEN) : this.tokenFactory.createTokenPair(securityUser));
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        JacksonUtil.writeValue((Writer)response.getWriter(), (Object)tokenPair);
        this.clearAuthenticationAttributes(request);
    }

    public JwtPair createMfaTokenPair(SecurityUser securityUser, Authority scope) {
        log.debug("[{}][{}] Creating {} token", new Object[]{securityUser.getTenantId(), securityUser.getId(), scope});
        JwtPair tokenPair = new JwtPair();
        int preVerificationTokenLifetime = this.twoFaConfigManager.getPlatformTwoFaSettings(securityUser.getTenantId(), true).flatMap(settings -> Optional.ofNullable(settings.getTotalAllowedTimeForVerification()).filter(time -> time > 0)).orElse((int)TimeUnit.MINUTES.toSeconds(30L));
        tokenPair.setToken(this.tokenFactory.createMfaToken(securityUser, scope, Integer.valueOf(preVerificationTokenLifetime)).token());
        tokenPair.setRefreshToken(null);
        tokenPair.setScope(scope);
        return tokenPair;
    }

    protected final void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }

    @ConstructorProperties(value={"tokenFactory", "twoFaConfigManager"})
    @Generated
    public RestAwareAuthenticationSuccessHandler(JwtTokenFactory tokenFactory, TwoFaConfigManager twoFaConfigManager) {
        this.tokenFactory = tokenFactory;
        this.twoFaConfigManager = twoFaConfigManager;
    }
}

