/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.pat;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.service.security.auth.extractor.TokenExtractor;
import org.thingsboard.server.service.security.auth.pat.ApiKeyAuthenticationToken;
import org.thingsboard.server.service.security.model.token.ApiKeyAuthRequest;

public class ApiKeyTokenAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String USER_ID_HEADER = "X-User-Id";
    private static final String CUSTOMER_ID_HEADER = "X-Customer-Id";
    private final AuthenticationFailureHandler failureHandler;
    private final TokenExtractor tokenExtractor;

    @Autowired
    public ApiKeyTokenAuthenticationProcessingFilter(AuthenticationFailureHandler failureHandler, @Qualifier(value="apiKeyHeaderTokenExtractor") TokenExtractor tokenExtractor, RequestMatcher matcher) {
        super(matcher);
        this.failureHandler = failureHandler;
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String apiKeyValue = this.tokenExtractor.extract(request);
        UserId userId = this.getUserId(request);
        CustomerId customerId = this.getCustomerId(request);
        ApiKeyAuthRequest apiKeyAuthRequest = new ApiKeyAuthRequest(apiKeyValue, userId, customerId);
        return this.getAuthenticationManager().authenticate((Authentication)new ApiKeyAuthenticationToken(apiKeyAuthRequest));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authResult);
        SecurityContextHolder.setContext((SecurityContext)context);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (!super.requiresAuthentication(request, response)) {
            return false;
        }
        String header = request.getHeader("X-Authorization");
        if (header == null) {
            header = request.getHeader("Authorization");
        }
        return header != null && header.startsWith("ApiKey ");
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response, failed);
    }

    private UserId getUserId(HttpServletRequest request) {
        UUID uuid = this.extractUuidFromHeader(request, USER_ID_HEADER);
        return uuid != null ? new UserId(uuid) : null;
    }

    private CustomerId getCustomerId(HttpServletRequest request) {
        UUID uuid = this.extractUuidFromHeader(request, CUSTOMER_ID_HEADER);
        return uuid != null ? new CustomerId(uuid) : null;
    }

    private UUID extractUuidFromHeader(HttpServletRequest request, String headerName) {
        String headerValue = request.getHeader(headerName);
        if (StringUtils.isNotBlank((String)headerValue)) {
            try {
                return UUID.fromString(headerValue);
            }
            catch (IllegalArgumentException e) {
                throw new AuthenticationServiceException("Invalid " + headerName + " format: " + headerValue);
            }
        }
        return null;
    }
}

