/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.pat;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.ApiKeyAuthRequest;

public class ApiKeyAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 2978710889397403536L;
    private ApiKeyAuthRequest apiKeyAuthRequest;
    private SecurityUser securityUser;

    public ApiKeyAuthenticationToken(ApiKeyAuthRequest apiKeyAuthRequest) {
        super(null);
        this.apiKeyAuthRequest = apiKeyAuthRequest;
        this.setAuthenticated(false);
    }

    public ApiKeyAuthenticationToken(SecurityUser securityUser) {
        super(securityUser.getAuthorities());
        this.eraseCredentials();
        this.securityUser = securityUser;
        super.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.apiKeyAuthRequest;
    }

    public Object getPrincipal() {
        return this.securityUser;
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.apiKeyAuthRequest = null;
    }
}

