/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.mfa.provider.impl;

import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.security.model.mfa.account.OtpBasedTwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.OtpBasedTwoFaProviderConfig;
import org.thingsboard.server.service.security.auth.mfa.provider.TwoFaProvider;
import org.thingsboard.server.service.security.auth.mfa.provider.impl.OtpBasedTwoFaProvider;
import org.thingsboard.server.service.security.model.SecurityUser;

public abstract class OtpBasedTwoFaProvider<C extends OtpBasedTwoFaProviderConfig, A extends OtpBasedTwoFaAccountConfig>
implements TwoFaProvider<C, A> {
    private final Cache verificationCodesCache;

    protected OtpBasedTwoFaProvider(CacheManager cacheManager) {
        this.verificationCodesCache = cacheManager.getCache("twoFaVerificationCodes");
    }

    public final void prepareVerificationCode(SecurityUser user, C providerConfig, A accountConfig) throws ThingsboardException {
        String verificationCode = StringUtils.randomNumeric((int)6);
        this.sendVerificationCode(user, verificationCode, providerConfig, accountConfig);
        this.verificationCodesCache.put((Object)user.getId(), (Object)new Otp(System.currentTimeMillis(), verificationCode, accountConfig));
    }

    protected abstract void sendVerificationCode(SecurityUser var1, String var2, C var3, A var4) throws ThingsboardException;

    public final boolean checkVerificationCode(SecurityUser user, String code, C providerConfig, A accountConfig) {
        Otp correctVerificationCode = (Otp)this.verificationCodesCache.get((Object)user.getId(), Otp.class);
        if (correctVerificationCode != null) {
            if (System.currentTimeMillis() - correctVerificationCode.getTimestamp() > TimeUnit.SECONDS.toMillis(providerConfig.getVerificationCodeLifetime())) {
                this.verificationCodesCache.evict((Object)user.getId());
                return false;
            }
            if (code.equals(correctVerificationCode.getValue()) && accountConfig.equals((Object)correctVerificationCode.getAccountConfig())) {
                this.verificationCodesCache.evict((Object)user.getId());
                return true;
            }
        }
        return false;
    }
}

