/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.mfa.provider.impl;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.security.model.mfa.account.BackupCodeTwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.account.TwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.BackupCodeTwoFaProviderConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;
import org.thingsboard.server.service.security.auth.mfa.provider.TwoFaProvider;
import org.thingsboard.server.service.security.model.SecurityUser;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@TbCoreComponent
public class BackupCodeTwoFaProvider
implements TwoFaProvider<BackupCodeTwoFaProviderConfig, BackupCodeTwoFaAccountConfig> {
    @Autowired
    @Lazy
    private TwoFaConfigManager twoFaConfigManager;

    public BackupCodeTwoFaAccountConfig generateNewAccountConfig(User user, BackupCodeTwoFaProviderConfig providerConfig) {
        BackupCodeTwoFaAccountConfig config = new BackupCodeTwoFaAccountConfig();
        config.setCodes(BackupCodeTwoFaProvider.generateCodes((int)providerConfig.getCodesQuantity(), (int)8));
        config.setSerializeHiddenFields(true);
        return config;
    }

    private static Set<String> generateCodes(int count, int length) {
        return Stream.generate(() -> StringUtils.random((int)length, (String)"0123456789abcdef")).distinct().limit(count).collect(Collectors.toSet());
    }

    public boolean checkVerificationCode(SecurityUser user, String code, BackupCodeTwoFaProviderConfig providerConfig, BackupCodeTwoFaAccountConfig accountConfig) {
        if (CollectionsUtil.contains((Collection)accountConfig.getCodes(), (Object)code)) {
            accountConfig.getCodes().remove(code);
            this.twoFaConfigManager.saveTwoFaAccountConfig(user.getTenantId(), (User)user, (TwoFaAccountConfig)accountConfig);
            return true;
        }
        return false;
    }

    public TwoFaProviderType getType() {
        return TwoFaProviderType.BACKUP_CODE;
    }
}

