/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.mfa.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.UserAuthSettings;
import org.thingsboard.server.common.data.security.model.mfa.PlatformTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.AccountTwoFaSettings;
import org.thingsboard.server.common.data.security.model.mfa.account.TwoFaAccountConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderConfig;
import org.thingsboard.server.common.data.security.model.mfa.provider.TwoFaProviderType;
import org.thingsboard.server.dao.service.ConstraintValidator;
import org.thingsboard.server.dao.settings.AdminSettingsDao;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.user.UserAuthSettingsDao;
import org.thingsboard.server.exception.DataValidationException;
import org.thingsboard.server.service.security.auth.mfa.TwoFactorAuthService;
import org.thingsboard.server.service.security.auth.mfa.config.TwoFaConfigManager;

@Service
public class DefaultTwoFaConfigManager
implements TwoFaConfigManager {
    private final UserAuthSettingsDao userAuthSettingsDao;
    private final AdminSettingsService adminSettingsService;
    private final AdminSettingsDao adminSettingsDao;
    @Lazy
    private final TwoFactorAuthService twoFactorAuthService;
    protected static final String TWO_FACTOR_AUTH_SETTINGS_KEY = "twoFaSettings";

    public Optional<AccountTwoFaSettings> getAccountTwoFaSettings(TenantId tenantId, User user) {
        PlatformTwoFaSettings platformTwoFaSettings = this.getPlatformTwoFaSettings(tenantId, true).orElse(null);
        return Optional.ofNullable(this.userAuthSettingsDao.findByUserId(user.getId())).map(userAuthSettings -> {
            AccountTwoFaSettings twoFaSettings = userAuthSettings.getTwoFaSettings();
            if (twoFaSettings == null) {
                return null;
            }
            LinkedHashMap configs = twoFaSettings.getConfigs();
            boolean updateNeeded = configs.keySet().removeIf(providerType -> platformTwoFaSettings == null || platformTwoFaSettings.getProviderConfig(providerType).isEmpty());
            if (configs.size() == 1 && configs.containsKey(TwoFaProviderType.BACKUP_CODE)) {
                configs.remove(TwoFaProviderType.BACKUP_CODE);
                updateNeeded = true;
            }
            if (!configs.isEmpty() && configs.values().stream().noneMatch(TwoFaAccountConfig::isUseByDefault)) {
                configs.values().stream().filter(config -> config.getProviderType() != TwoFaProviderType.BACKUP_CODE).findFirst().ifPresent(config -> config.setUseByDefault(true));
                updateNeeded = true;
            }
            if (updateNeeded) {
                twoFaSettings = this.saveAccountTwoFaSettings(tenantId, user, twoFaSettings);
            }
            return twoFaSettings;
        });
    }

    protected AccountTwoFaSettings saveAccountTwoFaSettings(TenantId tenantId, User user, AccountTwoFaSettings settings) {
        UserAuthSettings userAuthSettings = Optional.ofNullable(this.userAuthSettingsDao.findByUserId(user.getId())).orElseGet(() -> {
            UserAuthSettings newUserAuthSettings = new UserAuthSettings();
            newUserAuthSettings.setUserId(user.getId());
            return newUserAuthSettings;
        });
        userAuthSettings.setTwoFaSettings(settings);
        settings.getConfigs().values().forEach(accountConfig -> accountConfig.setSerializeHiddenFields(true));
        this.userAuthSettingsDao.save(tenantId, (Object)userAuthSettings);
        settings.getConfigs().values().forEach(accountConfig -> accountConfig.setSerializeHiddenFields(false));
        return settings;
    }

    public Optional<TwoFaAccountConfig> getTwoFaAccountConfig(TenantId tenantId, User user, TwoFaProviderType providerType) {
        return this.getAccountTwoFaSettings(tenantId, user).map(AccountTwoFaSettings::getConfigs).flatMap(configs -> Optional.ofNullable((TwoFaAccountConfig)configs.get(providerType)));
    }

    public AccountTwoFaSettings saveTwoFaAccountConfig(TenantId tenantId, User user, TwoFaAccountConfig accountConfig) {
        this.getTwoFaProviderConfig(tenantId, accountConfig.getProviderType()).orElseThrow(() -> new IllegalArgumentException("2FA provider is not configured"));
        AccountTwoFaSettings settings = this.getAccountTwoFaSettings(tenantId, user).orElseGet(() -> {
            AccountTwoFaSettings newSettings = new AccountTwoFaSettings();
            newSettings.setConfigs(new LinkedHashMap());
            return newSettings;
        });
        LinkedHashMap configs = settings.getConfigs();
        if (configs.isEmpty() && accountConfig.getProviderType() == TwoFaProviderType.BACKUP_CODE) {
            throw new IllegalArgumentException("To use 2FA backup codes you first need to configure at least one provider");
        }
        if (accountConfig.isUseByDefault()) {
            configs.values().forEach(config -> config.setUseByDefault(false));
        }
        configs.put(accountConfig.getProviderType(), accountConfig);
        if (configs.values().stream().noneMatch(TwoFaAccountConfig::isUseByDefault)) {
            configs.values().stream().findFirst().ifPresent(config -> config.setUseByDefault(true));
        }
        this.checkAccountTwoFaSettings(tenantId, user, settings);
        return this.saveAccountTwoFaSettings(tenantId, user, settings);
    }

    public AccountTwoFaSettings deleteTwoFaAccountConfig(TenantId tenantId, User user, TwoFaProviderType providerType) {
        AccountTwoFaSettings settings = (AccountTwoFaSettings)this.getAccountTwoFaSettings(tenantId, user).orElseThrow(() -> new IllegalArgumentException("2FA not configured"));
        settings.getConfigs().remove(providerType);
        if (settings.getConfigs().size() == 1) {
            settings.getConfigs().remove(TwoFaProviderType.BACKUP_CODE);
        }
        if (!settings.getConfigs().isEmpty() && settings.getConfigs().values().stream().noneMatch(TwoFaAccountConfig::isUseByDefault)) {
            settings.getConfigs().values().stream().min(Comparator.comparing(TwoFaAccountConfig::getProviderType)).ifPresent(config -> config.setUseByDefault(true));
        }
        this.checkAccountTwoFaSettings(tenantId, user, settings);
        return this.saveAccountTwoFaSettings(tenantId, user, settings);
    }

    private Optional<TwoFaProviderConfig> getTwoFaProviderConfig(TenantId tenantId, TwoFaProviderType providerType) {
        return this.getPlatformTwoFaSettings(tenantId, true).flatMap(twoFaSettings -> twoFaSettings.getProviderConfig(providerType));
    }

    public Optional<PlatformTwoFaSettings> getPlatformTwoFaSettings(TenantId tenantId, boolean sysadminSettingsAsDefault) {
        Optional<PlatformTwoFaSettings> twoFaSettings = Optional.ofNullable(this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, TWO_FACTOR_AUTH_SETTINGS_KEY)).map(adminSettings -> (PlatformTwoFaSettings)JacksonUtil.treeToValue((JsonNode)adminSettings.getJsonValue(), PlatformTwoFaSettings.class));
        if (!tenantId.isSysTenantId()) {
            if (twoFaSettings.isPresent() && !twoFaSettings.get().isUseSystemTwoFactorAuthSettings() && twoFaSettings.get().getProviders().isEmpty()) {
                twoFaSettings.get().setUseSystemTwoFactorAuthSettings(true);
            }
            if (sysadminSettingsAsDefault && (twoFaSettings.isEmpty() || twoFaSettings.get().isUseSystemTwoFactorAuthSettings())) {
                return this.getPlatformTwoFaSettings(TenantId.SYS_TENANT_ID, false);
            }
        }
        return twoFaSettings;
    }

    public PlatformTwoFaSettings savePlatformTwoFaSettings(TenantId tenantId, PlatformTwoFaSettings twoFactorAuthSettings) throws ThingsboardException {
        if (tenantId.equals((Object)TenantId.SYS_TENANT_ID) || !twoFactorAuthSettings.isUseSystemTwoFactorAuthSettings()) {
            ConstraintValidator.validateFields((Object)twoFactorAuthSettings);
        }
        for (TwoFaProviderConfig providerConfig : twoFactorAuthSettings.getProviders()) {
            this.twoFactorAuthService.checkProvider(tenantId, providerConfig.getProviderType());
        }
        if (tenantId.isSysTenantId()) {
            if (twoFactorAuthSettings.isEnforceTwoFa()) {
                if (twoFactorAuthSettings.getProviders().isEmpty()) {
                    throw new DataValidationException("At least one 2FA provider is required if enforcing is enabled");
                }
                if (twoFactorAuthSettings.getEnforcedUsersFilter() == null) {
                    throw new DataValidationException("Users filter to enforce 2FA for is required");
                }
            }
        } else {
            if (!twoFactorAuthSettings.isUseSystemTwoFactorAuthSettings() && twoFactorAuthSettings.getProviders().isEmpty()) {
                throw new DataValidationException("At least one 2FA provider is required");
            }
            twoFactorAuthSettings.setEnforceTwoFa(false);
            twoFactorAuthSettings.setEnforcedUsersFilter(null);
        }
        AdminSettings settings = Optional.ofNullable(this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, TWO_FACTOR_AUTH_SETTINGS_KEY)).orElseGet(() -> {
            AdminSettings newSettings = new AdminSettings();
            newSettings.setTenantId(tenantId);
            newSettings.setKey(TWO_FACTOR_AUTH_SETTINGS_KEY);
            return newSettings;
        });
        settings.setJsonValue(JacksonUtil.valueToTree((Object)twoFactorAuthSettings));
        this.adminSettingsService.saveAdminSettings(tenantId, settings);
        return twoFactorAuthSettings;
    }

    public void deletePlatformTwoFaSettings(TenantId tenantId) {
        Optional.ofNullable(this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, TWO_FACTOR_AUTH_SETTINGS_KEY)).ifPresent(adminSettings -> this.adminSettingsDao.removeById(tenantId, adminSettings.getId().getId()));
    }

    private void checkAccountTwoFaSettings(TenantId tenantId, User user, AccountTwoFaSettings settings) {
        if (settings.getConfigs().isEmpty() && this.twoFactorAuthService.isEnforceTwoFaEnabled(tenantId, user)) {
            throw new DataValidationException("At least one 2FA provider is required");
        }
    }

    @ConstructorProperties(value={"userAuthSettingsDao", "adminSettingsService", "adminSettingsDao", "twoFactorAuthService"})
    @Generated
    public DefaultTwoFaConfigManager(UserAuthSettingsDao userAuthSettingsDao, AdminSettingsService adminSettingsService, AdminSettingsDao adminSettingsDao, @Lazy TwoFactorAuthService twoFactorAuthService) {
        this.userAuthSettingsDao = userAuthSettingsDao;
        this.adminSettingsService = adminSettingsService;
        this.adminSettingsDao = adminSettingsDao;
        this.twoFactorAuthService = twoFactorAuthService;
    }
}

