/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.extractor;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.service.security.auth.extractor.TokenExtractor;

@Component(value="jwtQueryTokenExtractor")
public class JwtQueryTokenExtractor
implements TokenExtractor {
    public String extract(HttpServletRequest request) {
        String[] tokenParamValue;
        String token = null;
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty() && (tokenParamValue = (String[])request.getParameterMap().get("token")) != null && tokenParamValue.length == 1) {
            token = tokenParamValue[0];
        }
        if (StringUtils.isBlank(token)) {
            throw new AuthenticationServiceException("Authorization query parameter cannot be blank!");
        }
        return token;
    }
}

