/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth.extractor;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.service.security.auth.extractor.TokenExtractor;

public abstract class AbstractHeaderTokenExtractor
implements TokenExtractor {
    private final String headerPrefix;

    protected AbstractHeaderTokenExtractor(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    public String extract(HttpServletRequest request) {
        String header = request.getHeader("X-Authorization");
        if (StringUtils.isBlank((String)header) && StringUtils.isBlank((String)(header = request.getHeader("Authorization")))) {
            throw new AuthenticationServiceException("Authorization header cannot be blank!");
        }
        if (header.length() < this.headerPrefix.length()) {
            throw new AuthenticationServiceException("Invalid authorization header size.");
        }
        return header.substring(this.headerPrefix.length());
    }
}

