/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.security.auth;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.model.token.RawAccessJwtToken;

public abstract class AbstractJwtAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -6212297506742428406L;
    private RawAccessJwtToken rawAccessToken;
    private SecurityUser securityUser;

    public AbstractJwtAuthenticationToken(RawAccessJwtToken unsafeToken) {
        super(null);
        this.rawAccessToken = unsafeToken;
        this.setAuthenticated(false);
    }

    public AbstractJwtAuthenticationToken(SecurityUser securityUser) {
        super(securityUser.getAuthorities());
        this.eraseCredentials();
        this.securityUser = securityUser;
        super.setAuthenticated(true);
    }

    public void setAuthenticated(boolean authenticated) {
        if (authenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        }
        super.setAuthenticated(false);
    }

    public Object getCredentials() {
        return this.rawAccessToken;
    }

    public Object getPrincipal() {
        return this.securityUser;
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.rawAccessToken = null;
    }
}

