/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.rule;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.flow.TbRuleChainInputNode;
import org.thingsboard.rule.engine.flow.TbRuleChainInputNodeConfiguration;
import org.thingsboard.rule.engine.flow.TbRuleChainOutputNode;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.rule.DefaultRuleChainCreateRequest;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainOutputLabelsUsage;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.rule.RuleChainUpdateResult;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.rule.RuleNodeUpdateResult;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.component.RuleNodeClassInfo;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.rule.TbRuleChainService;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.utils.TbNodeUpgradeUtils;

@Service
@TbCoreComponent
public class DefaultTbRuleChainService
extends AbstractTbEntityService
implements TbRuleChainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbRuleChainService.class);
    private final RuleChainService ruleChainService;
    private final RelationService relationService;
    private final InstallScripts installScripts;
    private final ComponentDiscoveryService componentDiscoveryService;

    public Set<String> getRuleChainOutputLabels(TenantId tenantId, RuleChainId ruleChainId) {
        RuleChainMetaData metaData = this.ruleChainService.loadRuleChainMetaData(tenantId, ruleChainId);
        TreeSet<String> outputLabels = new TreeSet<String>();
        for (RuleNode ruleNode : metaData.getNodes()) {
            if (!this.isOutputRuleNode(ruleNode)) continue;
            outputLabels.add(ruleNode.getName());
        }
        return outputLabels;
    }

    public List<RuleChainOutputLabelsUsage> getOutputLabelUsage(TenantId tenantId, RuleChainId ruleChainId) {
        List ruleNodes = this.ruleChainService.findRuleNodesByTenantIdAndType(tenantId, TbRuleChainInputNode.class.getName(), ruleChainId.getId().toString());
        HashMap ruleChainNamesCache = new HashMap();
        List filteredRuleNodes = ruleNodes.stream().filter(node -> {
            try {
                TbRuleChainInputNodeConfiguration configuration = (TbRuleChainInputNodeConfiguration)JacksonUtil.treeToValue((JsonNode)node.getConfiguration(), TbRuleChainInputNodeConfiguration.class);
                return ruleChainId.getId().toString().equals(configuration.getRuleChainId());
            }
            catch (Exception e) {
                log.warn("[{}][{}] Failed to decode rule node configuration", new Object[]{tenantId, ruleChainId, e});
                return false;
            }
        }).collect(Collectors.toList());
        return filteredRuleNodes.stream().map(ruleNode -> {
            RuleChainOutputLabelsUsage usage = new RuleChainOutputLabelsUsage();
            usage.setRuleNodeId(ruleNode.getId());
            usage.setRuleNodeName(ruleNode.getName());
            usage.setRuleChainId(ruleNode.getRuleChainId());
            List relations = this.ruleChainService.getRuleNodeRelations(tenantId, ruleNode.getId());
            if (relations != null && !relations.isEmpty()) {
                usage.setLabels(relations.stream().map(EntityRelation::getType).collect(Collectors.toSet()));
            }
            return usage;
        }).filter(usage -> usage.getLabels() != null).peek(usage -> {
            String ruleChainName = ruleChainNamesCache.computeIfAbsent(usage.getRuleChainId(), id -> this.ruleChainService.findRuleChainById(tenantId, id).getName());
            usage.setRuleChainName(ruleChainName);
        }).sorted(Comparator.comparing(RuleChainOutputLabelsUsage::getRuleChainName).thenComparing(RuleChainOutputLabelsUsage::getRuleNodeName)).collect(Collectors.toList());
    }

    public List<RuleChain> updateRelatedRuleChains(TenantId tenantId, RuleChainId ruleChainId, RuleChainUpdateResult result) {
        HashSet ruleChainIds = new HashSet();
        log.debug("[{}][{}] Going to update links in related rule chains", (Object)tenantId, (Object)ruleChainId);
        if (result.getUpdatedRuleNodes() == null || result.getUpdatedRuleNodes().isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> oldLabels = new HashSet<String>();
        HashSet<String> newLabels = new HashSet<String>();
        HashSet<String> confusedLabels = new HashSet<String>();
        HashMap<String, String> updatedLabels = new HashMap<String, String>();
        for (RuleNodeUpdateResult update : result.getUpdatedRuleNodes()) {
            RuleNode oldNode = update.getOldRuleNode();
            RuleNode newNode = update.getNewRuleNode();
            if (!this.isOutputRuleNode(newNode)) continue;
            try {
                oldLabels.add(oldNode.getName());
                newLabels.add(newNode.getName());
                if (oldNode.getName().equals(newNode.getName())) continue;
                String oldLabel = oldNode.getName();
                String newLabel = newNode.getName();
                if (updatedLabels.containsKey(oldLabel) && !((String)updatedLabels.get(oldLabel)).equals(newLabel)) {
                    confusedLabels.add(oldLabel);
                    log.warn("[{}][{}] Can't automatically rename the label from [{}] to [{}] due to conflict [{}]", new Object[]{tenantId, ruleChainId, oldLabel, newLabel, updatedLabels.get(oldLabel)});
                    continue;
                }
                updatedLabels.put(oldLabel, newLabel);
            }
            catch (Exception e) {
                log.warn("[{}][{}][{}] Failed to decode rule node configuration", new Object[]{tenantId, ruleChainId, newNode.getId(), e});
            }
        }
        confusedLabels.forEach(updatedLabels::remove);
        newLabels.forEach(updatedLabels::remove);
        if (!oldLabels.equals(newLabels)) {
            ruleChainIds.addAll(this.updateRelatedRuleChains(tenantId, ruleChainId, updatedLabels));
        }
        return ruleChainIds.stream().map(id -> this.ruleChainService.findRuleChainById(tenantId, id)).collect(Collectors.toList());
    }

    public RuleChain save(RuleChain ruleChain, SecurityUser user) throws Exception {
        ActionType actionType = ruleChain.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = ruleChain.getTenantId();
        try {
            RuleChain savedRuleChain = (RuleChain)this.checkNotNull((Object)this.ruleChainService.saveRuleChain(ruleChain));
            this.autoCommit((User)user, (EntityId)savedRuleChain.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedRuleChain.getId(), (HasName)savedRuleChain, null, actionType, (User)user, new Object[0]);
            return savedRuleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), (HasName)ruleChain, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(RuleChain ruleChain, User user) {
        TenantId tenantId = ruleChain.getTenantId();
        RuleChainId ruleChainId = ruleChain.getId();
        try {
            this.ruleChainService.deleteRuleChainById(tenantId, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, null, ActionType.DELETED, user, new Object[]{ruleChainId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.DELETED, user, e, new Object[]{ruleChainId.toString()});
            throw e;
        }
    }

    public RuleChain saveDefaultByName(TenantId tenantId, DefaultRuleChainCreateRequest request, User user) throws Exception {
        try {
            RuleChain savedRuleChain = this.installScripts.createDefaultRuleChain(tenantId, request.getName());
            this.autoCommit(user, (EntityId)savedRuleChain.getId());
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)savedRuleChain.getId(), (HasName)savedRuleChain, ActionType.ADDED, user, new Object[0]);
            return savedRuleChain;
        }
        catch (Exception e) {
            RuleChain ruleChain = new RuleChain();
            ruleChain.setName(request.getName());
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), (HasName)ruleChain, ActionType.ADDED, user, e, new Object[0]);
            throw e;
        }
    }

    public RuleChain setRootRuleChain(TenantId tenantId, RuleChain ruleChain, User user) {
        RuleChainId ruleChainId = ruleChain.getId();
        try {
            RuleChain previousRootRuleChain = this.ruleChainService.getRootTenantRuleChain(tenantId);
            if (this.ruleChainService.setRootRuleChain(tenantId, ruleChainId)) {
                if (previousRootRuleChain != null) {
                    previousRootRuleChain = this.ruleChainService.findRuleChainById(tenantId, previousRootRuleChain.getId());
                    this.logEntityActionService.logEntityAction(tenantId, (EntityId)previousRootRuleChain.getId(), (HasName)previousRootRuleChain, ActionType.UPDATED, user, new Object[0]);
                }
                ruleChain = this.ruleChainService.findRuleChainById(tenantId, ruleChainId);
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, ActionType.UPDATED, user, new Object[0]);
            }
            return ruleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.UPDATED, user, e, new Object[]{ruleChainId.toString()});
            throw e;
        }
    }

    public RuleChainMetaData saveRuleChainMetaData(TenantId tenantId, RuleChain ruleChain, RuleChainMetaData ruleChainMetaData, boolean updateRelated, User user) throws Exception {
        RuleChainId ruleChainId = ruleChain.getId();
        RuleChainId ruleChainMetaDataId = ruleChainMetaData.getRuleChainId();
        try {
            RuleChainUpdateResult result = this.ruleChainService.saveRuleChainMetaData(tenantId, ruleChainMetaData, arg_0 -> this.updateRuleNodeConfiguration(arg_0));
            this.checkNotNull((Object)(result.isSuccess() ? Boolean.valueOf(true) : null));
            List updatedRuleChains = updateRelated && result.isSuccess() ? this.updateRelatedRuleChains(tenantId, ruleChainMetaDataId, result) : Collections.emptyList();
            if (updatedRuleChains.isEmpty()) {
                this.autoCommit(user, (EntityId)ruleChainMetaData.getRuleChainId());
            } else {
                ArrayList<UUID> uuids = new ArrayList<UUID>(updatedRuleChains.size() + 1);
                uuids.add(ruleChainMetaData.getRuleChainId().getId());
                updatedRuleChains.forEach(rc -> uuids.add(rc.getId().getId()));
                this.autoCommit(user, EntityType.RULE_CHAIN, uuids);
            }
            RuleChainMetaData savedRuleChainMetaData = (RuleChainMetaData)this.checkNotNull((Object)this.ruleChainService.loadRuleChainMetaData(tenantId, ruleChainMetaDataId));
            if (RuleChainType.CORE.equals((Object)ruleChain.getType())) {
                updatedRuleChains.forEach(updatedRuleChain -> this.tbClusterService.broadcastEntityStateChangeEvent(tenantId, (EntityId)updatedRuleChain.getId(), ComponentLifecycleEvent.UPDATED));
            }
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, ActionType.UPDATED, user, new Object[]{ruleChainMetaData});
            for (RuleChain updatedRuleChain2 : updatedRuleChains) {
                if (!RuleChainType.CORE.equals((Object)ruleChain.getType())) continue;
                RuleChainMetaData updatedRuleChainMetaData = (RuleChainMetaData)this.checkNotNull((Object)this.ruleChainService.loadRuleChainMetaData(tenantId, updatedRuleChain2.getId()));
                this.logEntityActionService.logEntityAction(tenantId, (EntityId)updatedRuleChain2.getId(), (HasName)updatedRuleChain2, ActionType.UPDATED, user, new Object[]{updatedRuleChainMetaData});
            }
            return savedRuleChainMetaData;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.ADDED, user, e, new Object[]{ruleChainMetaData});
            throw e;
        }
    }

    public RuleChain assignRuleChainToEdge(TenantId tenantId, RuleChain ruleChain, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        RuleChainId ruleChainId = ruleChain.getId();
        EdgeId edgeId = edge.getId();
        try {
            RuleChain savedRuleChain = (RuleChain)this.checkNotNull((Object)this.ruleChainService.assignRuleChainToEdge(tenantId, ruleChainId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)savedRuleChain, null, actionType, user, new Object[]{ruleChainId.toString(), edgeId.toString(), edge.getName()});
            return savedRuleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), actionType, user, e, new Object[]{ruleChainId.toString(), edgeId.toString()});
            throw e;
        }
    }

    public RuleChain unassignRuleChainFromEdge(TenantId tenantId, RuleChain ruleChain, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        RuleChainId ruleChainId = ruleChain.getId();
        EdgeId edgeId = edge.getId();
        try {
            RuleChain savedRuleChain = (RuleChain)this.checkNotNull((Object)this.ruleChainService.unassignRuleChainFromEdge(tenantId, ruleChainId, edgeId, false));
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)savedRuleChain, null, actionType, user, new Object[]{ruleChainId.toString(), edgeId.toString(), edge.getName()});
            return savedRuleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), actionType, user, e, new Object[]{ruleChainId, edgeId});
            throw e;
        }
    }

    public RuleChain setEdgeTemplateRootRuleChain(TenantId tenantId, RuleChain ruleChain, User user) throws ThingsboardException {
        RuleChainId ruleChainId = ruleChain.getId();
        try {
            this.ruleChainService.setEdgeTemplateRootRuleChain(tenantId, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, ActionType.UPDATED, user, new Object[0]);
            return ruleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.UPDATED, user, e, new Object[]{ruleChainId.toString()});
            throw e;
        }
    }

    public RuleChain setAutoAssignToEdgeRuleChain(TenantId tenantId, RuleChain ruleChain, User user) throws ThingsboardException {
        RuleChainId ruleChainId = ruleChain.getId();
        try {
            this.ruleChainService.setAutoAssignToEdgeRuleChain(tenantId, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, ActionType.UPDATED, user, new Object[0]);
            return ruleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.UPDATED, user, e, new Object[]{ruleChainId.toString()});
            throw e;
        }
    }

    public RuleChain unsetAutoAssignToEdgeRuleChain(TenantId tenantId, RuleChain ruleChain, User user) throws ThingsboardException {
        RuleChainId ruleChainId = ruleChain.getId();
        try {
            this.ruleChainService.unsetAutoAssignToEdgeRuleChain(tenantId, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)ruleChainId, (HasName)ruleChain, ActionType.UPDATED, user, new Object[0]);
            return ruleChain;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.RULE_CHAIN), ActionType.UPDATED, user, e, new Object[]{ruleChainId.toString()});
            throw e;
        }
    }

    public RuleNode updateRuleNodeConfiguration(RuleNode node) {
        RuleChainId ruleChainId = node.getRuleChainId();
        RuleNodeId ruleNodeId = node.getId();
        String ruleNodeType = node.getType();
        try {
            RuleNodeClassInfo ruleNodeClass = (RuleNodeClassInfo)this.componentDiscoveryService.getRuleNodeInfo(ruleNodeType).orElseThrow(() -> new RuntimeException("Rule node " + ruleNodeType + " is not supported!"));
            if (ruleNodeClass.isVersioned()) {
                int toVersion;
                int fromVersion = node.getConfigurationVersion();
                if (fromVersion < (toVersion = ruleNodeClass.getCurrentVersion())) {
                    log.debug("Going to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, fromVersion, toVersion});
                    TbNodeUpgradeUtils.upgradeConfigurationAndVersion((RuleNode)node, (RuleNodeClassInfo)ruleNodeClass);
                    log.debug("Successfully upgrade rule node with id: {} type: {}, rule chain id: {} fromVersion: {} toVersion: {}", new Object[]{ruleNodeId, ruleNodeType, ruleChainId, fromVersion, toVersion});
                } else {
                    log.debug("Rule node with id: {} type: {} ruleChainId: {} already set to latest version!", new Object[]{ruleNodeId, ruleChainId, ruleNodeType});
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to upgrade rule node with id: {} type: {}, rule chain id: {}", new Object[]{ruleNodeId, ruleNodeType, ruleChainId, e});
        }
        return node;
    }

    private Set<RuleChainId> updateRelatedRuleChains(TenantId tenantId, RuleChainId ruleChainId, Map<String, String> labelsMap) {
        HashSet<RuleChainId> updatedRuleChains = new HashSet<RuleChainId>();
        List usageList = this.getOutputLabelUsage(tenantId, ruleChainId);
        for (RuleChainOutputLabelsUsage usage : usageList) {
            labelsMap.forEach((oldLabel, newLabel) -> {
                if (usage.getLabels().contains(oldLabel)) {
                    updatedRuleChains.add(usage.getRuleChainId());
                    this.renameOutgoingLinks(tenantId, usage.getRuleNodeId(), oldLabel, newLabel);
                }
            });
        }
        return updatedRuleChains;
    }

    private void renameOutgoingLinks(TenantId tenantId, RuleNodeId ruleNodeId, String oldLabel, String newLabel) {
        List relations = this.ruleChainService.getRuleNodeRelations(tenantId, ruleNodeId);
        for (EntityRelation relation : relations) {
            if (!relation.getType().equals(oldLabel)) continue;
            this.relationService.deleteRelation(tenantId, relation);
            relation.setType(newLabel);
            this.relationService.saveRelation(tenantId, relation);
        }
    }

    private boolean isOutputRuleNode(RuleNode ruleNode) {
        return this.isRuleNode(ruleNode, TbRuleChainOutputNode.class);
    }

    private boolean isInputRuleNode(RuleNode ruleNode) {
        return this.isRuleNode(ruleNode, TbRuleChainInputNode.class);
    }

    private boolean isRuleNode(RuleNode ruleNode, Class<?> clazz) {
        return ruleNode != null && ruleNode.getType().equals(clazz.getName());
    }

    @ConstructorProperties(value={"ruleChainService", "relationService", "installScripts", "componentDiscoveryService"})
    @Generated
    public DefaultTbRuleChainService(RuleChainService ruleChainService, RelationService relationService, InstallScripts installScripts, ComponentDiscoveryService componentDiscoveryService) {
        this.ruleChainService = ruleChainService;
        this.relationService = relationService;
        this.installScripts = installScripts;
        this.componentDiscoveryService = componentDiscoveryService;
    }
}

