/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.profile;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.device.DeviceProfileService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;

@Service
public class DefaultTbDeviceProfileCache
implements TbDeviceProfileCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbDeviceProfileCache.class);
    private final Lock deviceProfileFetchLock = new ReentrantLock();
    private final DeviceProfileService deviceProfileService;
    private final DeviceService deviceService;
    private final ConcurrentMap<DeviceProfileId, DeviceProfile> deviceProfilesMap = new ConcurrentHashMap();
    private final ConcurrentMap<DeviceId, DeviceProfileId> devicesMap = new ConcurrentHashMap();
    private final ConcurrentMap<TenantId, ConcurrentMap<EntityId, Consumer<DeviceProfile>>> profileListeners = new ConcurrentHashMap();
    private final ConcurrentMap<TenantId, ConcurrentMap<EntityId, BiConsumer<DeviceId, DeviceProfile>>> deviceProfileListeners = new ConcurrentHashMap();

    public DefaultTbDeviceProfileCache(DeviceProfileService deviceProfileService, DeviceService deviceService) {
        this.deviceProfileService = deviceProfileService;
        this.deviceService = deviceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProfile get(TenantId tenantId, DeviceProfileId deviceProfileId) {
        DeviceProfile profile = (DeviceProfile)this.deviceProfilesMap.get(deviceProfileId);
        if (profile == null) {
            this.deviceProfileFetchLock.lock();
            try {
                profile = (DeviceProfile)this.deviceProfilesMap.get(deviceProfileId);
                if (profile == null && (profile = this.deviceProfileService.findDeviceProfileById(tenantId, deviceProfileId)) != null) {
                    this.deviceProfilesMap.put(deviceProfileId, profile);
                    log.debug("[{}] Fetch device profile into cache: {}", (Object)profile.getId(), (Object)profile);
                }
            }
            finally {
                this.deviceProfileFetchLock.unlock();
            }
        }
        log.trace("[{}] Found device profile in cache: {}", (Object)deviceProfileId, (Object)profile);
        return profile;
    }

    public DeviceProfile get(TenantId tenantId, DeviceId deviceId) {
        DeviceProfileId profileId = (DeviceProfileId)this.devicesMap.get(deviceId);
        if (profileId == null) {
            Device device = this.deviceService.findDeviceById(tenantId, deviceId);
            if (device != null) {
                profileId = device.getDeviceProfileId();
                this.devicesMap.put(deviceId, profileId);
            } else {
                return null;
            }
        }
        return this.get(tenantId, profileId);
    }

    public void evict(TenantId tenantId, DeviceProfileId profileId) {
        DeviceProfile oldProfile = (DeviceProfile)this.deviceProfilesMap.remove(profileId);
        log.debug("[{}] evict device profile from cache: {}", (Object)profileId, (Object)oldProfile);
        DeviceProfile newProfile = this.get(tenantId, profileId);
        if (newProfile != null) {
            this.notifyProfileListeners(newProfile);
        }
    }

    public void evict(TenantId tenantId, DeviceId deviceId) {
        DeviceProfile newProfile;
        DeviceProfileId old = (DeviceProfileId)this.devicesMap.remove(deviceId);
        if (!(old == null || (newProfile = this.get(tenantId, deviceId)) != null && old.equals((Object)newProfile.getId()))) {
            this.notifyDeviceListeners(tenantId, deviceId, newProfile);
        }
    }

    public void addListener(TenantId tenantId, EntityId listenerId, Consumer<DeviceProfile> profileListener, BiConsumer<DeviceId, DeviceProfile> deviceListener) {
        if (profileListener != null) {
            this.profileListeners.computeIfAbsent(tenantId, id -> new ConcurrentHashMap()).put(listenerId, profileListener);
        }
        if (deviceListener != null) {
            this.deviceProfileListeners.computeIfAbsent(tenantId, id -> new ConcurrentHashMap()).put(listenerId, deviceListener);
        }
    }

    public DeviceProfile find(DeviceProfileId deviceProfileId) {
        return this.deviceProfileService.findDeviceProfileById(TenantId.SYS_TENANT_ID, deviceProfileId);
    }

    public DeviceProfile findOrCreateDeviceProfile(TenantId tenantId, String profileName) {
        return this.deviceProfileService.findOrCreateDeviceProfile(tenantId, profileName);
    }

    public void removeListener(TenantId tenantId, EntityId listenerId) {
        ConcurrentMap deviceListeners;
        ConcurrentMap tenantListeners = (ConcurrentMap)this.profileListeners.get(tenantId);
        if (tenantListeners != null) {
            tenantListeners.remove(listenerId);
        }
        if ((deviceListeners = (ConcurrentMap)this.deviceProfileListeners.get(tenantId)) != null) {
            deviceListeners.remove(listenerId);
        }
    }

    private void notifyProfileListeners(DeviceProfile profile) {
        ConcurrentMap tenantListeners = (ConcurrentMap)this.profileListeners.get(profile.getTenantId());
        if (tenantListeners != null) {
            tenantListeners.forEach((id, listener) -> listener.accept(profile));
        }
    }

    private void notifyDeviceListeners(TenantId tenantId, DeviceId deviceId, DeviceProfile profile) {
        ConcurrentMap tenantListeners;
        if (profile != null && (tenantListeners = (ConcurrentMap)this.deviceProfileListeners.get(tenantId)) != null) {
            tenantListeners.forEach((id, listener) -> listener.accept(deviceId, profile));
        }
    }
}

