/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.ResourcesShortageNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.ResourcesShortageTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.notification.rule.trigger.config.ResourcesShortageNotificationRuleTriggerConfig;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;
import org.thingsboard.server.service.notification.rule.trigger.ResourcesShortageTriggerProcessor;

@Service
public class ResourcesShortageTriggerProcessor
implements NotificationRuleTriggerProcessor<ResourcesShortageTrigger, ResourcesShortageNotificationRuleTriggerConfig> {
    public boolean matchesFilter(ResourcesShortageTrigger trigger, ResourcesShortageNotificationRuleTriggerConfig triggerConfig) {
        float usagePercent = (float)trigger.getUsage().longValue() / 100.0f;
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$notification$rule$trigger$ResourcesShortageTrigger$Resource[trigger.getResource().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                if (usagePercent >= triggerConfig.getCpuThreshold()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (usagePercent >= triggerConfig.getRamThreshold()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> usagePercent >= triggerConfig.getStorageThreshold();
        };
    }

    public RuleOriginatedNotificationInfo constructNotificationInfo(ResourcesShortageTrigger trigger) {
        return ResourcesShortageNotificationInfo.builder().resource(trigger.getResource().name()).usage(trigger.getUsage()).serviceId(trigger.getServiceId()).serviceType(trigger.getServiceType()).build();
    }

    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.RESOURCES_SHORTAGE;
    }

    @Generated
    public ResourcesShortageTriggerProcessor() {
    }
}

