/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.channels;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.template.SmsDeliveryMethodNotificationTemplate;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.NotificationChannel;

@Component
public class SmsNotificationChannel
implements NotificationChannel<User, SmsDeliveryMethodNotificationTemplate> {
    private final SmsService smsService;

    public void sendNotification(User recipient, SmsDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        String phone = recipient.getPhone();
        if (StringUtils.isBlank((CharSequence)phone)) {
            throw new RuntimeException("User does not have phone number");
        }
        this.smsService.sendSms(ctx.getTenantId(), null, new String[]{phone}, processedTemplate.getBody());
    }

    public void check(TenantId tenantId) throws Exception {
        if (!this.smsService.isConfigured(tenantId)) {
            throw new RuntimeException("SMS provider is not configured");
        }
    }

    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.SMS;
    }

    @ConstructorProperties(value={"smsService"})
    @Generated
    public SmsNotificationChannel(SmsService smsService) {
        this.smsService = smsService;
    }
}

