/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.settings.MobileAppNotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.template.DeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.notification.template.NotificationTemplateConfig;
import org.thingsboard.server.common.data.util.TemplateUtils;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.service.notification.NotificationProcessingContext;

public class NotificationProcessingContext {
    private final TenantId tenantId;
    private final NotificationSettings settings;
    private final NotificationSettings systemSettings;
    private final NotificationRequest request;
    private final Set<NotificationDeliveryMethod> deliveryMethods;
    private final NotificationTemplate notificationTemplate;
    private final NotificationType notificationType;
    private final Map<NotificationDeliveryMethod, DeliveryMethodNotificationTemplate> templates;
    private final NotificationRequestStats stats;
    private final SecretConfigurationService secretConfigurationService;
    private final Function<String, JsonNode> translationProvider;
    private final Map<String, JsonNode> fullTranslations = new ConcurrentReferenceHashMap(4, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private final Map<String, Map<String, String>> translations = new ConcurrentHashMap();

    public NotificationProcessingContext(TenantId tenantId, NotificationRequest request, Set<NotificationDeliveryMethod> deliveryMethods, NotificationTemplate template, NotificationSettings settings, NotificationSettings systemSettings, Function<String, JsonNode> translationProvider, SecretConfigurationService secretConfigurationService) {
        this.tenantId = tenantId;
        this.request = request;
        this.deliveryMethods = deliveryMethods;
        this.settings = settings;
        this.systemSettings = systemSettings;
        this.translationProvider = translationProvider;
        this.notificationTemplate = template;
        this.notificationType = template.getNotificationType();
        this.templates = new EnumMap(NotificationDeliveryMethod.class);
        this.stats = request.getStats() != null ? request.getStats() : new NotificationRequestStats();
        this.secretConfigurationService = secretConfigurationService;
        this.init();
    }

    private void init() {
        NotificationTemplateConfig templateConfig = this.notificationTemplate.getConfiguration();
        templateConfig.getDeliveryMethodsTemplates().forEach((deliveryMethod, template) -> {
            if (template.isEnabled()) {
                template = this.processTemplate(template, null, null);
                this.templates.put(deliveryMethod, template);
            }
        });
    }

    public <C extends NotificationDeliveryMethodConfig> C getDeliveryMethodConfig(NotificationDeliveryMethod deliveryMethod) {
        NotificationDeliveryMethodConfig config;
        NotificationSettings settings = this.settings;
        boolean isSystem = false;
        if (deliveryMethod == NotificationDeliveryMethod.MOBILE_APP && !this.tenantId.isSysTenantId() && ((config = (MobileAppNotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(deliveryMethod)) == null || config.isUseSystemSettings())) {
            settings = this.systemSettings;
            isSystem = true;
        }
        config = (NotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(deliveryMethod);
        return (C)((NotificationDeliveryMethodConfig)this.secretConfigurationService.replaceSecretUsages(isSystem ? TenantId.SYS_TENANT_ID : this.tenantId, (Object)config, config.getClass()));
    }

    public <T extends DeliveryMethodNotificationTemplate> T getProcessedTemplate(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        DeliveryMethodNotificationTemplate template = (DeliveryMethodNotificationTemplate)this.templates.get(deliveryMethod);
        if (recipient != null) {
            String string;
            if (recipient instanceof User) {
                User user = (User)recipient;
                string = user.getLocale();
            } else {
                string = Locale.US.toString();
            }
            String locale = string;
            Map additionalTemplateContext = this.createTemplateContextForRecipient(recipient);
            ArrayList params = new ArrayList(additionalTemplateContext.keySet());
            params.add("translate");
            if (template.getTemplatableValues().stream().anyMatch(value -> value.contains((Collection)params))) {
                template = this.processTemplate(template, locale, additionalTemplateContext);
            }
        }
        return (T)template;
    }

    private <T extends DeliveryMethodNotificationTemplate> T processTemplate(T template, String locale, Map<String, String> additionalTemplateContext) {
        HashMap<String, String> templateContext = new HashMap<String, String>();
        if (this.request.getInfo() != null) {
            templateContext.putAll(this.request.getInfo().getTemplateData());
        }
        if (additionalTemplateContext != null) {
            templateContext.putAll(additionalTemplateContext);
        }
        if (templateContext.isEmpty()) {
            return template;
        }
        template = template.copy();
        template.getTemplatableValues().forEach(templatableValue -> {
            String value = templatableValue.get();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                Map<String, UnaryOperator> functions = null;
                if (locale != null && this.translationProvider != null) {
                    functions = Map.of("translate", key -> this.translate(key, locale));
                }
                value = TemplateUtils.processTemplate((String)value, (Map)templateContext, functions);
                templatableValue.set(value);
            }
        });
        return template;
    }

    private String translate(String key, String locale) {
        return this.translations.computeIfAbsent(key, k -> new ConcurrentHashMap()).computeIfAbsent(locale, k -> {
            JsonNode fullTranslation = (JsonNode)this.fullTranslations.computeIfAbsent(locale, this.translationProvider);
            return Optional.ofNullable(JacksonUtil.getByKeyPath((JsonNode)fullTranslation, (String)key)).map(JsonNode::asText).orElse("");
        });
    }

    private Map<String, String> createTemplateContextForRecipient(NotificationRecipient recipient) {
        return Map.of("recipientTitle", recipient.getTitle(), "recipientEmail", Strings.nullToEmpty((String)recipient.getEmail()), "recipientFirstName", Strings.nullToEmpty((String)recipient.getFirstName()), "recipientLastName", Strings.nullToEmpty((String)recipient.getLastName()));
    }

    @Generated
    public static NotificationProcessingContextBuilder builder() {
        return new NotificationProcessingContextBuilder();
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public NotificationRequest getRequest() {
        return this.request;
    }

    @Generated
    public Set<NotificationDeliveryMethod> getDeliveryMethods() {
        return this.deliveryMethods;
    }

    @Generated
    public NotificationTemplate getNotificationTemplate() {
        return this.notificationTemplate;
    }

    @Generated
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public NotificationRequestStats getStats() {
        return this.stats;
    }
}

