/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.activation.DataSource;
import jakarta.annotation.PreDestroy;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.xml.bind.DatatypeConverter;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.ApiUsageRecordState;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.blob.BlobEntity;
import org.thingsboard.server.common.data.exception.RateLimitExceededException;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.BlobEntityId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.ReportId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.blob.BlobEntityService;
import org.thingsboard.server.dao.exception.IncorrectParameterException;
import org.thingsboard.server.dao.report.ReportService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.dao.wl.WhiteLabelingService;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.mail.DefaultMailService;
import org.thingsboard.server.service.mail.MailSenderInternalExecutorService;
import org.thingsboard.server.service.mail.MailTemplates;
import org.thingsboard.server.service.mail.PasswordResetExecutorService;
import org.thingsboard.server.service.mail.TbMailContextComponent;
import org.thingsboard.server.service.mail.TbMailSender;

@Service
public class DefaultMailService
implements MailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMailService.class);
    private static final String MAIL_SETTINGS_KEY = "mail";
    private static final String TARGET_EMAIL = "targetEmail";
    private static final String UTF_8 = "UTF-8";
    private static final long DEFAULT_TIMEOUT = 10000L;
    private final ScheduledExecutorService timeoutScheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"mail-service-watchdog");
    private final AdminSettingsService adminSettingsService;
    private final BlobEntityService blobEntityService;
    private final TbApiUsageReportClient apiUsageClient;
    @Lazy
    private final TbApiUsageStateService apiUsageStateService;
    private final MailSenderInternalExecutorService mailExecutorService;
    private final PasswordResetExecutorService passwordResetExecutorService;
    private final TbMailContextComponent ctx;
    private final RateLimitService rateLimitService;
    private final ReportService reportService;
    private final WhiteLabelingService whiteLabelingService;
    @Value(value="${actors.rule.allow_system_mail_service}")
    private boolean allowSystemMailService;
    @Value(value="${mail.per_tenant_rate_limits:}")
    private String perTenantRateLimitConfig;

    @PreDestroy
    public void destroy() {
        this.timeoutScheduler.shutdownNow();
    }

    public void sendEmail(TenantId tenantId, String email, String subject, String message) throws ThingsboardException {
        this.sendMail(tenantId, email, subject, message);
    }

    public void sendTestMail(TenantId tenantId, JsonNode jsonConfig, String email) throws ThingsboardException {
        this.ctx.getSecretConfigurationService().replaceSecretUsages(tenantId, jsonConfig);
        TbMailSender testMailSender = new TbMailSender(this.ctx, tenantId, jsonConfig);
        String mailFrom = this.getStringValue(jsonConfig, "mailFrom");
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"test");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "test", model);
        this.sendMail((JavaMailSenderImpl)testMailSender, mailFrom, email, subject, message, this.getTimeout(jsonConfig));
    }

    public void sendActivationEmail(TenantId tenantId, String activationLink, long ttlMs, String email) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"activation");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("activationLink", activationLink);
        model.put("activationLinkTtlInHours", (int)Math.ceil((double)ttlMs / 3600000.0));
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "activation", model);
        this.sendMail(tenantId, email, subject, message);
    }

    public void sendAccountActivatedEmail(TenantId tenantId, String loginLink, String email) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"accountActivated");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("loginLink", loginLink);
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "accountActivated", model);
        this.sendMail(tenantId, email, subject, message);
    }

    public void sendResetPasswordEmail(TenantId tenantId, String passwordResetLink, long ttlMs, String email) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"resetPassword");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("passwordResetLink", passwordResetLink);
        model.put("passwordResetLinkTtlInHours", (int)Math.ceil((double)ttlMs / 3600000.0));
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "resetPassword", model);
        this.sendMail(tenantId, email, subject, message);
    }

    public void sendResetPasswordEmailAsync(TenantId tenantId, String passwordResetLink, long ttlMs, String email) {
        this.passwordResetExecutorService.execute(() -> {
            try {
                this.sendResetPasswordEmail(tenantId, passwordResetLink, ttlMs, email);
            }
            catch (Exception e) {
                log.error("Error occurred: {} ", (Object)e.getMessage());
            }
        });
    }

    public void sendPasswordWasResetEmail(TenantId tenantId, String loginLink, String email) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"passwordWasReset");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("loginLink", loginLink);
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "passwordWasReset", model);
        this.sendMail(tenantId, email, subject, message);
    }

    private void sendMail(TenantId tenantId, String email, String subject, String message) throws ThingsboardException {
        JsonNode jsonConfig = this.getConfig(tenantId);
        TbMailSender mailSender = new TbMailSender(this.ctx, tenantId, jsonConfig);
        String mailFrom = this.getStringValue(jsonConfig, "mailFrom");
        this.sendMail((JavaMailSenderImpl)mailSender, mailFrom, email, subject, message, this.getTimeout(jsonConfig));
    }

    public void send(TenantId tenantId, CustomerId customerId, TbEmail tbEmail) throws ThingsboardException {
        ConfigEntry configEntry = this.getConfig(tenantId, this.allowSystemMailService);
        JsonNode jsonConfig = configEntry.jsonConfig;
        TbMailSender mailSender = new TbMailSender(this.ctx, configEntry.isSystem ? TenantId.SYS_TENANT_ID : tenantId, jsonConfig);
        this.sendMail(tenantId, customerId, tbEmail, (JavaMailSender)mailSender, false, this.getTimeout(jsonConfig));
    }

    public void send(TenantId tenantId, CustomerId customerId, TbEmail tbEmail, long timeout, JavaMailSender javaMailSender) throws ThingsboardException {
        this.sendMail(tenantId, customerId, tbEmail, javaMailSender, true, timeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMail(TenantId tenantId, CustomerId customerId, TbEmail tbEmail, JavaMailSender javaMailSender, boolean externalMailSender, long timeout) throws ThingsboardException {
        ConfigEntry configEntry = this.getConfig(tenantId, true);
        JsonNode jsonConfig = configEntry.jsonConfig;
        if (!externalMailSender && configEntry.isSystem && !this.apiUsageStateService.getApiUsageState(tenantId).isEmailSendEnabled()) throw new RuntimeException("Email sending is disabled due to API limits!");
        if (tenantId != null && !tenantId.isSysTenantId() && StringUtils.isNotEmpty((String)this.perTenantRateLimitConfig) && !this.rateLimitService.checkRateLimit(LimitedApi.EMAILS, (Object)tenantId, this.perTenantRateLimitConfig)) {
            throw new RateLimitExceededException(LimitedApi.EMAILS);
        }
        String mailFrom = this.getStringValue(jsonConfig, "mailFrom");
        try {
            MimeMessage mailMsg = javaMailSender.createMimeMessage();
            boolean multipart = MapUtils.isNotEmpty((Map)tbEmail.getImages()) || CollectionsUtil.isNotEmpty((Collection)tbEmail.getAttachments()) || CollectionsUtil.isNotEmpty((Collection)tbEmail.getReports());
            MimeMessageHelper helper = new MimeMessageHelper(mailMsg, multipart, UTF_8);
            helper.setFrom(StringUtils.isBlank((String)tbEmail.getFrom()) ? mailFrom : tbEmail.getFrom());
            helper.setTo(tbEmail.getTo().split("\\s*,\\s*"));
            if (!StringUtils.isBlank((String)tbEmail.getCc())) {
                helper.setCc(tbEmail.getCc().split("\\s*,\\s*"));
            }
            if (!StringUtils.isBlank((String)tbEmail.getBcc())) {
                helper.setBcc(tbEmail.getBcc().split("\\s*,\\s*"));
            }
            helper.setSubject(tbEmail.getSubject());
            helper.setText(tbEmail.getBody(), tbEmail.isHtml());
            if (tbEmail.getAttachments() != null) {
                for (BlobEntityId blobEntityId : tbEmail.getAttachments()) {
                    BlobEntity blobEntity = this.blobEntityService.findBlobEntityById(tenantId, blobEntityId);
                    if (blobEntity == null) continue;
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(blobEntity.getData().array(), blobEntity.getContentType());
                    helper.addAttachment(blobEntity.getName(), (DataSource)dataSource);
                }
            }
            if (tbEmail.getImages() != null) {
                for (String imgId : tbEmail.getImages().keySet()) {
                    String imgValue = (String)tbEmail.getImages().get(imgId);
                    String value = imgValue.replaceFirst("^data:image/[^;]*;base64,?", "");
                    byte[] bytes = DatatypeConverter.parseBase64Binary((String)value);
                    String contentType = helper.getFileTypeMap().getContentType(imgId);
                    InputStreamSource iss = () -> new ByteArrayInputStream(bytes);
                    helper.addInline(imgId, iss, contentType);
                }
            }
            if (tbEmail.getReports() != null) {
                for (ReportId reportId : tbEmail.getReports()) {
                    Report report = this.reportService.findReportById(tenantId, reportId);
                    if (report == null) continue;
                    byte[] data = this.reportService.getReportData(tenantId, reportId);
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(data, report.getFormat().getContentType());
                    helper.addAttachment(report.getName(), (DataSource)dataSource);
                }
            }
            this.sendMailWithTimeout(javaMailSender, helper.getMimeMessage(), timeout);
            if (externalMailSender || !configEntry.isSystem) return;
            this.apiUsageClient.report(tenantId, customerId, ApiUsageRecordKey.EMAIL_EXEC_COUNT, 1L);
            return;
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e);
        }
    }

    public void sendAccountLockoutEmail(TenantId tenantId, String lockoutEmail, String email, Integer maxFailedLoginAttempts) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"accountLockout");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("lockoutAccount", lockoutEmail);
        model.put("maxFailedLoginAttempts", maxFailedLoginAttempts);
        model.put(TARGET_EMAIL, email);
        String message = this.body(mailTemplates, "accountLockout", model);
        this.sendMail(tenantId, email, subject, message);
    }

    public void sendTwoFaVerificationEmail(TenantId tenantId, String email, String verificationCode, int expirationTimeSeconds) throws ThingsboardException {
        this.sendTemplateEmail(tenantId, email, "twoFaVerification", Map.of(TARGET_EMAIL, email, "code", verificationCode, "expirationTimeSeconds", expirationTimeSeconds));
    }

    public void sendApiFeatureStateEmail(TenantId tenantId, ApiFeature apiFeature, ApiUsageStateValue stateValue, String email, ApiUsageRecordState recordState) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(TenantId.SYS_TENANT_ID);
        String subject = null;
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("apiFeature", apiFeature.getLabel());
        model.put(TARGET_EMAIL, email);
        String message = null;
        switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiUsageStateValue[stateValue.ordinal()]) {
            case 1: {
                model.put("apiLabel", this.toEnabledValueLabel(apiFeature));
                message = this.body(mailTemplates, "apiUsageStateEnabled", model);
                subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"apiUsageStateEnabled");
                break;
            }
            case 2: {
                model.put("apiValueLabel", this.toDisabledValueLabel(apiFeature) + " " + this.toWarningValueLabel(recordState));
                message = this.body(mailTemplates, "apiUsageStateWarning", model);
                subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"apiUsageStateWarning");
                break;
            }
            case 3: {
                model.put("apiLimitValueLabel", this.toDisabledValueLabel(apiFeature) + " " + this.toDisabledValueLabel(recordState));
                message = this.body(mailTemplates, "apiUsageStateDisabled", model);
                subject = MailTemplates.subject((JsonNode)mailTemplates, (String)"apiUsageStateDisabled");
            }
        }
        this.sendMail(tenantId, email, subject, message);
    }

    public void testConnection(TenantId tenantId) throws Exception {
        JsonNode jsonConfig = this.getConfig(tenantId);
        TbMailSender mailSender = new TbMailSender(this.ctx, tenantId, jsonConfig);
        mailSender.testConnection();
    }

    public boolean isConfigured(TenantId tenantId) {
        try {
            ConfigEntry configEntry = this.getConfig(tenantId, this.allowSystemMailService);
            JsonNode jsonConfig = configEntry.jsonConfig;
            new TbMailSender(this.ctx, tenantId, jsonConfig);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void sendTemplateEmail(TenantId tenantId, String email, String template, Map<String, Object> templateModel) throws ThingsboardException {
        JsonNode mailTemplates = this.whiteLabelingService.getMergedTenantMailTemplates(tenantId);
        String subject = MailTemplates.subject((JsonNode)mailTemplates, (String)template);
        String message = this.body(mailTemplates, template, templateModel);
        this.sendMail(tenantId, email, subject, message);
    }

    private String toEnabledValueLabel(ApiFeature apiFeature) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiFeature[apiFeature.ordinal()]) {
            case 1 -> "save";
            case 2 -> "receive";
            case 3 -> "invoke";
            case 4 -> "process";
            case 5, 6 -> "send";
            case 7 -> "create";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toDisabledValueLabel(ApiFeature apiFeature) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiFeature[apiFeature.ordinal()]) {
            case 1 -> "saved";
            case 2 -> "received";
            case 3 -> "invoked";
            case 4 -> "processed";
            case 5, 6 -> "sent";
            case 7 -> "created";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toWarningValueLabel(ApiUsageRecordState recordState) {
        String valueInM = recordState.getValueAsString();
        String thresholdInM = recordState.getThresholdAsString();
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiUsageRecordKey[recordState.getKey().ordinal()]) {
            case 1, 2 -> valueInM + " out of " + thresholdInM + " allowed data points";
            case 3 -> valueInM + " out of " + thresholdInM + " allowed messages";
            case 4 -> valueInM + " out of " + thresholdInM + " allowed JavaScript functions";
            case 5 -> valueInM + " out of " + thresholdInM + " allowed Tbel functions";
            case 6 -> valueInM + " out of " + thresholdInM + " allowed Rule Engine messages";
            case 7 -> valueInM + " out of " + thresholdInM + " allowed Email messages";
            case 8 -> valueInM + " out of " + thresholdInM + " allowed SMS messages";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private String toDisabledValueLabel(ApiUsageRecordState recordState) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$ApiUsageRecordKey[recordState.getKey().ordinal()]) {
            case 1, 2 -> recordState.getValueAsString() + " data points";
            case 3 -> recordState.getValueAsString() + " messages";
            case 4 -> "JavaScript functions " + recordState.getValueAsString() + " times";
            case 5 -> "TBEL functions " + recordState.getValueAsString() + " times";
            case 6 -> recordState.getValueAsString() + " Rule Engine messages";
            case 7 -> recordState.getValueAsString() + " Email messages";
            case 8 -> recordState.getValueAsString() + " SMS messages";
            default -> throw new RuntimeException("Not implemented!");
        };
    }

    private void sendMail(JavaMailSenderImpl mailSender, String mailFrom, String email, String subject, String message, long timeout) throws ThingsboardException {
        try {
            MimeMessage mimeMsg = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMsg, UTF_8);
            helper.setFrom(mailFrom);
            helper.setTo(email);
            helper.setSubject(subject);
            helper.setText(message, true);
            this.sendMailWithTimeout((JavaMailSender)mailSender, helper.getMimeMessage(), timeout);
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e);
        }
    }

    private void sendMailWithTimeout(JavaMailSender mailSender, MimeMessage msg, long timeout) throws ThingsboardException {
        ListenableFuture submittedMail = Futures.withTimeout((ListenableFuture)this.mailExecutorService.submit(() -> mailSender.send(msg)), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutScheduler);
        try {
            submittedMail.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timeout!");
        }
        catch (Exception e) {
            throw new ThingsboardException("Unable to send mail", ExceptionUtils.getRootCause((Throwable)e), ThingsboardErrorCode.GENERAL);
        }
    }

    private String getStringValue(JsonNode jsonNode, String key) {
        if (jsonNode.has(key)) {
            return jsonNode.get(key).asText();
        }
        return "";
    }

    private long getTimeout(JsonNode jsonConfig) {
        if (jsonConfig.has("timeout")) {
            return jsonConfig.get("timeout").asLong(10000L);
        }
        return 10000L;
    }

    private JsonNode getConfig(TenantId tenantId) throws ThingsboardException {
        return this.getConfig((TenantId)tenantId, (boolean)true).jsonConfig;
    }

    private ConfigEntry getConfig(TenantId tenantId, boolean allowSystemMailService) throws ThingsboardException {
        try {
            JsonNode useSystemMailSettingsNode;
            AdminSettings adminSettings;
            JsonNode jsonConfig = null;
            boolean isSystem = false;
            if (tenantId != null && !tenantId.isNullUid() && (adminSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, MAIL_SETTINGS_KEY)) != null && ((useSystemMailSettingsNode = (jsonConfig = adminSettings.getJsonValue()).get("useSystemMailSettings")) == null || useSystemMailSettingsNode.asBoolean())) {
                jsonConfig = null;
            }
            if (jsonConfig == null) {
                if (!allowSystemMailService) {
                    throw new RuntimeException("Access to System Mail Service is forbidden!");
                }
                AdminSettings settings = this.adminSettingsService.findAdminSettingsByKey(tenantId, MAIL_SETTINGS_KEY);
                if (settings != null) {
                    jsonConfig = settings.getJsonValue();
                    isSystem = true;
                }
            }
            if (jsonConfig == null) {
                throw new IncorrectParameterException("Failed to get mail configuration. Settings not found!");
            }
            this.ctx.getSecretConfigurationService().replaceSecretUsages(isSystem ? TenantId.SYS_TENANT_ID : tenantId, jsonConfig);
            return new ConfigEntry(jsonConfig, isSystem);
        }
        catch (Exception e) {
            throw this.handleException((Throwable)e);
        }
    }

    private String body(JsonNode mailTemplates, String template, Map<String, Object> model) throws ThingsboardException {
        try {
            return MailTemplates.body((JsonNode)mailTemplates, (String)template, model);
        }
        catch (Exception e) {
            log.warn("Failed to process mail template: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new ThingsboardException("Failed to process mail template: " + e.getMessage(), (Throwable)e, ThingsboardErrorCode.GENERAL);
        }
    }

    protected ThingsboardException handleException(Throwable exception) {
        if (exception instanceof ThingsboardException) {
            ThingsboardException thingsboardException = (ThingsboardException)exception;
            return thingsboardException;
        }
        if (exception instanceof NestedRuntimeException) {
            exception = ((NestedRuntimeException)exception).getMostSpecificCause();
        }
        log.warn("Unable to send mail: {}", (Object)exception.getMessage());
        return new ThingsboardException("Unable to send mail: " + exception.getMessage(), ThingsboardErrorCode.GENERAL);
    }

    @ConstructorProperties(value={"adminSettingsService", "blobEntityService", "apiUsageClient", "apiUsageStateService", "mailExecutorService", "passwordResetExecutorService", "ctx", "rateLimitService", "reportService", "whiteLabelingService"})
    @Generated
    public DefaultMailService(AdminSettingsService adminSettingsService, BlobEntityService blobEntityService, TbApiUsageReportClient apiUsageClient, @Lazy TbApiUsageStateService apiUsageStateService, MailSenderInternalExecutorService mailExecutorService, PasswordResetExecutorService passwordResetExecutorService, TbMailContextComponent ctx, RateLimitService rateLimitService, ReportService reportService, WhiteLabelingService whiteLabelingService) {
        this.adminSettingsService = adminSettingsService;
        this.blobEntityService = blobEntityService;
        this.apiUsageClient = apiUsageClient;
        this.apiUsageStateService = apiUsageStateService;
        this.mailExecutorService = mailExecutorService;
        this.passwordResetExecutorService = passwordResetExecutorService;
        this.ctx = ctx;
        this.rateLimitService = rateLimitService;
        this.reportService = reportService;
        this.whiteLabelingService = whiteLabelingService;
    }
}

