/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.license;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.thingsboard.license.client.InstanceRegistry;
import org.thingsboard.license.client.TbLicenseCtx;
import org.thingsboard.server.dao.instance.registry.InstanceRegistryService;
import org.thingsboard.server.queue.discovery.DiscoveryService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;

@Component
public class DefaultTbLicenseCtx
implements TbLicenseCtx {
    private final InstanceRegistryService instanceRegistryService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final DiscoveryService discoveryService;
    private final JdbcTemplate jdbcTemplate;

    public InstanceRegistry save(InstanceRegistry instanceRegistry) {
        return this.instanceRegistryService.save(instanceRegistry);
    }

    public InstanceRegistry findByServiceId(String serviceId) {
        return this.instanceRegistryService.findByServiceId(serviceId);
    }

    public List<InstanceRegistry> findAll() {
        return this.instanceRegistryService.findAll();
    }

    public void deleteByServiceId(String serviceId) {
        this.instanceRegistryService.deleteByServiceId(serviceId);
    }

    public String getServiceId() {
        return this.serviceInfoProvider.getServiceId();
    }

    public UUID getClusterId() {
        return (UUID)this.jdbcTemplate.queryForObject("SELECT cluster_id from tb_cluster", UUID.class);
    }

    public boolean isServiceAvailable(String serviceId) {
        return this.discoveryService.getOtherServers().stream().anyMatch(serviceInfo -> serviceInfo.getServiceId().equals(serviceId));
    }

    @ConstructorProperties(value={"instanceRegistryService", "serviceInfoProvider", "discoveryService", "jdbcTemplate"})
    @Generated
    public DefaultTbLicenseCtx(InstanceRegistryService instanceRegistryService, TbServiceInfoProvider serviceInfoProvider, DiscoveryService discoveryService, JdbcTemplate jdbcTemplate) {
        this.instanceRegistryService = instanceRegistryService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.discoveryService = discoveryService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

