/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.job.task;

import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.CfReprocessingTask;
import org.thingsboard.server.common.data.job.task.CfReprocessingTaskResult;
import org.thingsboard.server.queue.task.TaskProcessor;
import org.thingsboard.server.queue.util.TbRuleEngineComponent;
import org.thingsboard.server.service.cf.CalculatedFieldReprocessingService;

@TbRuleEngineComponent
@Component
public class CfReprocessingTaskProcessor
extends TaskProcessor<CfReprocessingTask, CfReprocessingTaskResult> {
    @Autowired
    @Lazy
    private CalculatedFieldReprocessingService cfReprocessingService;
    @Value(value="${queue.calculated_fields.reprocessing_timeout:300000}")
    private int timeoutMs;

    public CfReprocessingTaskResult process(CfReprocessingTask task) throws Exception {
        this.cfReprocessingService.reprocess(task);
        return CfReprocessingTaskResult.success((CfReprocessingTask)task);
    }

    public long getProcessingTimeout(CfReprocessingTask task) {
        return this.timeoutMs;
    }

    public JobType getJobType() {
        return JobType.CF_REPROCESSING;
    }

    @Generated
    public CfReprocessingTaskProcessor() {
    }
}

