/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.job;

import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.JobStats;
import org.thingsboard.server.common.data.job.task.TaskResult;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.settings.TasksQueueConfig;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Component
public class JobStatsProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobStatsProcessor.class);
    private final JobService jobService;
    private final TasksQueueConfig queueConfig;
    private final QueueConsumerManager<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> jobStatsConsumer;
    private final ExecutorService consumerExecutor;

    public JobStatsProcessor(JobService jobService, TasksQueueConfig queueConfig, TbCoreQueueFactory queueFactory) {
        this.jobService = jobService;
        this.queueConfig = queueConfig;
        this.consumerExecutor = Executors.newCachedThreadPool((ThreadFactory)ThingsBoardThreadFactory.forName((String)"job-stats-consumer"));
        this.jobStatsConsumer = QueueConsumerManager.builder().name("job-stats").msgPackProcessor((arg_0, arg_1) -> this.processStats(arg_0, arg_1)).pollInterval((long)queueConfig.getStatsPollInterval()).consumerCreator(() -> ((TbCoreQueueFactory)queueFactory).createJobStatsConsumer()).consumerExecutor(this.consumerExecutor).build();
    }

    @AfterStartUp(order=11)
    public void afterStartUp() {
        this.jobStatsConsumer.subscribe();
        this.jobStatsConsumer.launch();
    }

    private void processStats(List<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> consumer) {
        HashMap<JobId, JobStats> stats = new HashMap<JobId, JobStats>();
        for (TbProtoQueueMsg<TransportProtos.JobStatsMsg> msg : msgs) {
            TransportProtos.JobStatsMsg statsMsg = (TransportProtos.JobStatsMsg)msg.getValue();
            TenantId tenantId = TenantId.fromUUID((UUID)new UUID(statsMsg.getTenantIdMSB(), statsMsg.getTenantIdLSB()));
            JobId jobId2 = new JobId(new UUID(statsMsg.getJobIdMSB(), statsMsg.getJobIdLSB()));
            JobStats jobStats2 = stats.computeIfAbsent(jobId2, __ -> new JobStats(tenantId, jobId2));
            if (statsMsg.hasTaskResult()) {
                TaskResult taskResult = (TaskResult)JacksonUtil.fromString((String)statsMsg.getTaskResult().getValue(), TaskResult.class);
                jobStats2.getTaskResults().add(taskResult);
            }
            if (!statsMsg.hasTotalTasksCount()) continue;
            jobStats2.setTotalTasksCount(Integer.valueOf(statsMsg.getTotalTasksCount()));
        }
        stats.forEach((jobId, jobStats) -> {
            TenantId tenantId = jobStats.getTenantId();
            try {
                log.debug("[{}][{}] Processing job stats: {}", new Object[]{tenantId, jobId, stats});
                this.jobService.processStats(tenantId, jobId, jobStats);
            }
            catch (Exception e) {
                log.error("[{}][{}] Failed to process job stats: {}", new Object[]{tenantId, jobId, jobStats, e});
            }
        });
        consumer.commit();
        Thread.sleep(this.queueConfig.getStatsProcessingInterval());
    }

    @PreDestroy
    private void destroy() {
        this.jobStatsConsumer.stop();
        this.consumerExecutor.shutdownNow();
    }
}

