/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.job;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.CfReprocessingJobConfiguration;
import org.thingsboard.server.common.data.job.Job;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.CfReprocessingTask;
import org.thingsboard.server.common.data.job.task.CfReprocessingTaskResult;
import org.thingsboard.server.common.data.job.task.Task;
import org.thingsboard.server.common.data.job.task.TaskResult;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.service.job.CfReprocessingJobProcessor;
import org.thingsboard.server.service.job.JobProcessor;

@Component
public class CfReprocessingJobProcessor
implements JobProcessor {
    private final CalculatedFieldService calculatedFieldService;
    private final DeviceService deviceService;
    private final AssetService assetService;

    public int process(Job job, Consumer<Task<?>> taskConsumer) throws Exception {
        CfReprocessingJobConfiguration configuration = (CfReprocessingJobConfiguration)job.getConfiguration();
        TenantId tenantId = job.getTenantId();
        CalculatedField calculatedField = this.calculatedFieldService.findById(tenantId, configuration.getCalculatedFieldId());
        EntityId cfEntityId = calculatedField.getEntityId();
        int tasksCount = 0;
        for (EntityInfo entityInfo : switch (1.$SwitchMap$org$thingsboard$server$common$data$EntityType[cfEntityId.getEntityType().ordinal()]) {
            case 1 -> List.of(this.deviceService.findDeviceEntityInfoById(tenantId, (DeviceId)cfEntityId));
            case 2 -> List.of(this.assetService.findAssetEntityInfoById(tenantId, (AssetId)cfEntityId));
            case 3 -> new PageDataIterable(pageLink -> this.deviceService.findDeviceEntityInfosByTenantIdAndDeviceProfileId(tenantId, (DeviceProfileId)cfEntityId, pageLink), 512);
            case 4 -> new PageDataIterable(pageLink -> this.assetService.findAssetEntityInfosByTenantIdAndAssetProfileId(tenantId, (AssetProfileId)cfEntityId, pageLink), 512);
            default -> throw new IllegalArgumentException("Unsupported CF entity type " + String.valueOf(cfEntityId.getEntityType()));
        }) {
            taskConsumer.accept((Task<?>)this.createTask(job, configuration, calculatedField, entityInfo));
            ++tasksCount;
        }
        return tasksCount;
    }

    public void reprocess(Job job, List<TaskResult> taskFailures, Consumer<Task<?>> taskConsumer) throws Exception {
        CfReprocessingJobConfiguration configuration = (CfReprocessingJobConfiguration)job.getConfiguration();
        CalculatedField calculatedField = this.calculatedFieldService.findById(job.getTenantId(), configuration.getCalculatedFieldId());
        for (TaskResult taskFailure : taskFailures) {
            CfReprocessingTaskResult.CfReprocessingTaskFailure failure = ((CfReprocessingTaskResult)taskFailure).getFailure();
            EntityInfo entityInfo = failure.getEntityInfo();
            taskConsumer.accept((Task<?>)this.createTask(job, (CfReprocessingJobConfiguration)job.getConfiguration(), calculatedField, entityInfo));
        }
    }

    private CfReprocessingTask createTask(Job job, CfReprocessingJobConfiguration configuration, CalculatedField calculatedField, EntityInfo entityInfo) {
        return ((CfReprocessingTask.CfReprocessingTaskBuilder)((CfReprocessingTask.CfReprocessingTaskBuilder)((CfReprocessingTask.CfReprocessingTaskBuilder)((CfReprocessingTask.CfReprocessingTaskBuilder)CfReprocessingTask.builder().tenantId(job.getTenantId())).jobId((JobId)job.getId())).key(configuration.getTasksKey())).retries(0)).calculatedField(calculatedField).entityInfo(entityInfo).startTs(configuration.getStartTs()).endTs(configuration.getEndTs()).build();
    }

    public JobType getType() {
        return JobType.CF_REPROCESSING;
    }

    @ConstructorProperties(value={"calculatedFieldService", "deviceService", "assetService"})
    @Generated
    public CfReprocessingJobProcessor(CalculatedFieldService calculatedFieldService, DeviceService deviceService, AssetService assetService) {
        this.calculatedFieldService = calculatedFieldService;
        this.deviceService = deviceService;
        this.assetService = assetService;
    }
}

