/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.channel.EventLoopGroup;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.integration.api.IntegrationCallback;
import org.thingsboard.integration.api.IntegrationContext;
import org.thingsboard.integration.api.IntegrationRateLimitService;
import org.thingsboard.integration.api.converter.ConverterContext;
import org.thingsboard.integration.api.data.DownLinkMsg;
import org.thingsboard.integration.api.data.IntegrationDownlinkMsg;
import org.thingsboard.integration.api.util.IntegrationMqttClientSettingsComponent;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.IntegrationDebugEvent;
import org.thingsboard.server.common.data.event.RawDataEvent;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.AbstractIntegration;
import org.thingsboard.server.common.data.integration.Integration;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.gen.integration.AssetUplinkDataProto;
import org.thingsboard.server.gen.integration.DeviceUplinkDataProto;
import org.thingsboard.server.gen.integration.EntityViewDataProto;
import org.thingsboard.server.service.integration.ConverterContextComponent;
import org.thingsboard.server.service.integration.IntegrationContextComponent;
import org.thingsboard.server.service.integration.LocalConverterContext;

public class LocalIntegrationContext
implements IntegrationContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalIntegrationContext.class);
    private static final String DEVICE_VIEW_NAME_ENDING = "_View";
    private final IntegrationContextComponent ctx;
    private final Integration configuration;
    private final ConverterContext uplinkConverterContext;
    private final ConverterContext downlinkConverterContext;
    private final IntegrationMqttClientSettingsComponent integrationMqttClientSettingsComponent;
    @Value(value="${integrations.init.connection_timeout_sec:10}")
    private int integrationConnectTimeoutSec;

    public LocalIntegrationContext(IntegrationContextComponent ctx, Integration configuration, IntegrationMqttClientSettingsComponent integrationMqttClientSettingsComponent) {
        this.ctx = ctx;
        this.configuration = configuration;
        this.integrationMqttClientSettingsComponent = integrationMqttClientSettingsComponent;
        TenantId tenantId = configuration.getTenantId();
        ConverterContextComponent converterContextComponent = ctx.getConverterContextComponent();
        this.uplinkConverterContext = new LocalConverterContext(converterContextComponent, tenantId, configuration.getDefaultConverterId());
        this.downlinkConverterContext = new LocalConverterContext(converterContextComponent, tenantId, configuration.getDownlinkConverterId());
    }

    public void processUplinkData(DeviceUplinkDataProto data, IntegrationCallback<Void> callback) {
        this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, data, callback).run();
    }

    public void processUplinkData(AssetUplinkDataProto data, IntegrationCallback<Void> callback) {
        this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, data, callback).run();
    }

    public void createEntityView(EntityViewDataProto data, IntegrationCallback<Void> callback) {
        this.ctx.getPlatformIntegrationService().processUplinkData((AbstractIntegration)this.configuration, data, callback).run();
    }

    public void processCustomMsg(TbMsg tbMsg, IntegrationCallback<Void> callback) {
        this.ctx.getPlatformIntegrationService().process(this.configuration.getTenantId(), tbMsg, callback);
        if (callback != null) {
            callback.onSuccess(null);
        }
    }

    public void saveEvent(IntegrationDebugEvent event, IntegrationCallback<Void> callback) {
        this.doSaveEvent((Event)event, callback);
    }

    public void saveLifecycleEvent(ComponentLifecycleEvent lcEvent, Exception e) {
        this.ctx.getEventStorageService().persistLifecycleEvent(this.configuration.getTenantId(), (EntityId)this.configuration.getId(), lcEvent, e);
    }

    public void saveRawDataEvent(String deviceName, String type, String uid, JsonNode body, IntegrationCallback<Void> callback) {
        Device device = this.ctx.getDeviceService().findDeviceByTenantIdAndName(this.configuration.getTenantId(), deviceName);
        if (device != null) {
            this.doSaveEvent((Event)RawDataEvent.builder().tenantId(this.configuration.getTenantId()).entityId(device.getId().getId()).serviceId(this.getServiceId()).uuid(uid).messageType(type).message(body.toString()).build(), callback);
        }
    }

    public DownLinkMsg getDownlinkMsg(String deviceName) {
        Device device = this.ctx.getDeviceService().findDeviceByTenantIdAndName(this.configuration.getTenantId(), deviceName);
        if (device != null) {
            return this.ctx.getDownlinkCacheService().get(this.configuration.getId(), (EntityId)device.getId());
        }
        return null;
    }

    public DownLinkMsg putDownlinkMsg(IntegrationDownlinkMsg msg) {
        return this.ctx.getDownlinkCacheService().put(msg);
    }

    public void removeDownlinkMsg(String deviceName) {
        Device device = this.ctx.getDeviceService().findDeviceByTenantIdAndName(this.configuration.getTenantId(), deviceName);
        if (device != null) {
            this.ctx.getDownlinkCacheService().remove(this.configuration.getId(), (EntityId)device.getId());
        }
    }

    public boolean isClosed() {
        return false;
    }

    private void doSaveEvent(Event event, IntegrationCallback<Void> callback) {
        DonAsynchron.withCallback((ListenableFuture)this.ctx.getEventService().saveAsync(event), res -> callback.onSuccess(null), arg_0 -> callback.onError(arg_0));
    }

    public String getServiceId() {
        return this.ctx.getServiceInfoProvider().getServiceId();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.ctx.getEventLoopGroup();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.ctx.getScheduledExecutorService();
    }

    public ExecutorService getExecutorService() {
        return this.ctx.getGeneralExecutorService();
    }

    public ExecutorService getCallBackExecutorService() {
        return this.ctx.getCallBackExecutorService();
    }

    public boolean isExceptionStackTraceEnabled() {
        return this.ctx.isExceptionStackTraceEnabled();
    }

    public void onUplinkMessageProcessed(boolean success) {
        if (this.configuration != null) {
            this.ctx.getIntegrationStatisticsService().onUplinkMsg(this.configuration.getType(), success);
        }
    }

    public void onDownlinkMessageProcessed(boolean success) {
        if (this.configuration != null) {
            this.ctx.getIntegrationStatisticsService().onUplinkMsg(this.configuration.getType(), success);
        }
    }

    public Optional<IntegrationRateLimitService> getRateLimitService() {
        return Optional.of(this.ctx.getRateLimitService());
    }

    public int getMqttClientRetransmissionMaxAttempts() {
        return this.integrationMqttClientSettingsComponent.getRetransmissionMaxAttempts();
    }

    public long getMqttClientRetransmissionInitialDelayMillis() {
        return this.integrationMqttClientSettingsComponent.getRetransmissionInitialDelayMillis();
    }

    public double getMqttClientRetransmissionJitterFactor() {
        return this.integrationMqttClientSettingsComponent.getRetransmissionJitterFactor();
    }

    @Generated
    public IntegrationContextComponent getCtx() {
        return this.ctx;
    }

    @Generated
    public Integration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ConverterContext getUplinkConverterContext() {
        return this.uplinkConverterContext;
    }

    @Generated
    public ConverterContext getDownlinkConverterContext() {
        return this.downlinkConverterContext;
    }

    @Generated
    public IntegrationMqttClientSettingsComponent getIntegrationMqttClientSettingsComponent() {
        return this.integrationMqttClientSettingsComponent;
    }

    @Generated
    public void setIntegrationConnectTimeoutSec(int integrationConnectTimeoutSec) {
        this.integrationConnectTimeoutSec = integrationConnectTimeoutSec;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalIntegrationContext)) {
            return false;
        }
        LocalIntegrationContext other = (LocalIntegrationContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getIntegrationConnectTimeoutSec() != other.getIntegrationConnectTimeoutSec()) {
            return false;
        }
        IntegrationContextComponent this$ctx = this.getCtx();
        IntegrationContextComponent other$ctx = other.getCtx();
        if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
            return false;
        }
        Integration this$configuration = this.getConfiguration();
        Integration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        ConverterContext this$uplinkConverterContext = this.getUplinkConverterContext();
        ConverterContext other$uplinkConverterContext = other.getUplinkConverterContext();
        if (this$uplinkConverterContext == null ? other$uplinkConverterContext != null : !this$uplinkConverterContext.equals(other$uplinkConverterContext)) {
            return false;
        }
        ConverterContext this$downlinkConverterContext = this.getDownlinkConverterContext();
        ConverterContext other$downlinkConverterContext = other.getDownlinkConverterContext();
        if (this$downlinkConverterContext == null ? other$downlinkConverterContext != null : !this$downlinkConverterContext.equals(other$downlinkConverterContext)) {
            return false;
        }
        IntegrationMqttClientSettingsComponent this$integrationMqttClientSettingsComponent = this.getIntegrationMqttClientSettingsComponent();
        IntegrationMqttClientSettingsComponent other$integrationMqttClientSettingsComponent = other.getIntegrationMqttClientSettingsComponent();
        return !(this$integrationMqttClientSettingsComponent == null ? other$integrationMqttClientSettingsComponent != null : !this$integrationMqttClientSettingsComponent.equals(other$integrationMqttClientSettingsComponent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalIntegrationContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIntegrationConnectTimeoutSec();
        IntegrationContextComponent $ctx = this.getCtx();
        result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
        Integration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        ConverterContext $uplinkConverterContext = this.getUplinkConverterContext();
        result = result * 59 + ($uplinkConverterContext == null ? 43 : $uplinkConverterContext.hashCode());
        ConverterContext $downlinkConverterContext = this.getDownlinkConverterContext();
        result = result * 59 + ($downlinkConverterContext == null ? 43 : $downlinkConverterContext.hashCode());
        IntegrationMqttClientSettingsComponent $integrationMqttClientSettingsComponent = this.getIntegrationMqttClientSettingsComponent();
        result = result * 59 + ($integrationMqttClientSettingsComponent == null ? 43 : $integrationMqttClientSettingsComponent.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LocalIntegrationContext(ctx=" + String.valueOf(this.getCtx()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", uplinkConverterContext=" + String.valueOf(this.getUplinkConverterContext()) + ", downlinkConverterContext=" + String.valueOf(this.getDownlinkConverterContext()) + ", integrationMqttClientSettingsComponent=" + String.valueOf(this.getIntegrationMqttClientSettingsComponent()) + ", integrationConnectTimeoutSec=" + this.getIntegrationConnectTimeoutSec() + ")";
    }

    @Generated
    public int getIntegrationConnectTimeoutSec() {
        return this.integrationConnectTimeoutSec;
    }
}

