/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.integration;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.integration.api.IntegrationRateLimitService;
import org.thingsboard.integration.api.IntegrationStatisticsService;
import org.thingsboard.integration.api.util.LogSettingsComponent;
import org.thingsboard.server.dao.asset.AssetService;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.secret.SecretConfigurationService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.integration.ConverterContextComponent;
import org.thingsboard.server.service.integration.EventStorageService;
import org.thingsboard.server.service.integration.PlatformIntegrationService;
import org.thingsboard.server.service.integration.downlink.DownlinkCacheService;
import org.thingsboard.server.service.state.DeviceStateService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@TbCoreComponent
@Component
public class IntegrationContextComponent {
    private volatile boolean isClosed = false;
    @Autowired
    private TbServiceInfoProvider serviceInfoProvider;
    @Autowired
    private DeviceStateService deviceStateService;
    @Lazy
    @Autowired
    private PlatformIntegrationService platformIntegrationService;
    @Lazy
    @Autowired
    private IntegrationService integrationService;
    @Lazy
    @Autowired
    private ConverterService converterService;
    @Lazy
    @Autowired
    private DeviceService deviceService;
    @Lazy
    @Autowired
    private EntityViewService entityViewService;
    @Lazy
    @Autowired
    private RelationService relationService;
    @Lazy
    @Autowired
    private AttributesService attributesService;
    @Lazy
    @Autowired
    private TelemetrySubscriptionService telemetrySubscriptionService;
    @Lazy
    @Autowired
    private EventService eventService;
    @Lazy
    @Autowired
    private DownlinkCacheService downlinkCacheService;
    @Lazy
    @Autowired
    private ConverterContextComponent converterContextComponent;
    @Lazy
    @Autowired
    private CustomerService customerService;
    @Lazy
    @Autowired
    private AssetService assetService;
    @Lazy
    @Autowired
    private EntityGroupService entityGroupService;
    @Lazy
    @Autowired
    private LogSettingsComponent logSettingsComponent;
    @Lazy
    @Autowired
    private IntegrationStatisticsService integrationStatisticsService;
    @Autowired
    private IntegrationRateLimitService rateLimitService;
    @Autowired
    private SecretConfigurationService secretConfigurationService;
    @Lazy
    @Autowired
    private EventStorageService eventStorageService;
    private EventLoopGroup eventLoopGroup;
    private ScheduledExecutorService scheduledExecutorService;
    private ExecutorService callBackExecutorService;
    private ExecutorService generalExecutorService;

    @EventListener
    public void handleContextClosed(ContextClosedEvent event) {
        this.isClosed = true;
    }

    @PostConstruct
    public void init() {
        this.eventLoopGroup = new NioEventLoopGroup();
        this.scheduledExecutorService = ThingsBoardExecutors.newScheduledThreadPool((int)3, (String)"integration-scheduled");
        this.callBackExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)Math.max(2, Runtime.getRuntime().availableProcessors()), (String)"integration-callback");
        this.generalExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)20, (String)"integration-general");
    }

    @PreDestroy
    public void destroy() {
        this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        if (this.callBackExecutorService != null) {
            this.callBackExecutorService.shutdownNow();
        }
        if (this.generalExecutorService != null) {
            this.generalExecutorService.shutdownNow();
        }
    }

    ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    ExecutorService getCallBackExecutorService() {
        return this.callBackExecutorService;
    }

    ExecutorService getGeneralExecutorService() {
        return this.generalExecutorService;
    }

    public boolean isExceptionStackTraceEnabled() {
        return this.logSettingsComponent.isExceptionStackTraceEnabled();
    }

    @Generated
    public IntegrationContextComponent() {
    }

    @Generated
    public boolean isClosed() {
        return this.isClosed;
    }

    @Generated
    public TbServiceInfoProvider getServiceInfoProvider() {
        return this.serviceInfoProvider;
    }

    @Generated
    public DeviceStateService getDeviceStateService() {
        return this.deviceStateService;
    }

    @Lazy
    @Generated
    public PlatformIntegrationService getPlatformIntegrationService() {
        return this.platformIntegrationService;
    }

    @Lazy
    @Generated
    public IntegrationService getIntegrationService() {
        return this.integrationService;
    }

    @Lazy
    @Generated
    public ConverterService getConverterService() {
        return this.converterService;
    }

    @Lazy
    @Generated
    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    @Lazy
    @Generated
    public EntityViewService getEntityViewService() {
        return this.entityViewService;
    }

    @Lazy
    @Generated
    public RelationService getRelationService() {
        return this.relationService;
    }

    @Lazy
    @Generated
    public AttributesService getAttributesService() {
        return this.attributesService;
    }

    @Lazy
    @Generated
    public TelemetrySubscriptionService getTelemetrySubscriptionService() {
        return this.telemetrySubscriptionService;
    }

    @Lazy
    @Generated
    public EventService getEventService() {
        return this.eventService;
    }

    @Lazy
    @Generated
    public DownlinkCacheService getDownlinkCacheService() {
        return this.downlinkCacheService;
    }

    @Lazy
    @Generated
    public ConverterContextComponent getConverterContextComponent() {
        return this.converterContextComponent;
    }

    @Lazy
    @Generated
    public CustomerService getCustomerService() {
        return this.customerService;
    }

    @Lazy
    @Generated
    public AssetService getAssetService() {
        return this.assetService;
    }

    @Lazy
    @Generated
    public EntityGroupService getEntityGroupService() {
        return this.entityGroupService;
    }

    @Lazy
    @Generated
    public LogSettingsComponent getLogSettingsComponent() {
        return this.logSettingsComponent;
    }

    @Lazy
    @Generated
    public IntegrationStatisticsService getIntegrationStatisticsService() {
        return this.integrationStatisticsService;
    }

    @Generated
    public IntegrationRateLimitService getRateLimitService() {
        return this.rateLimitService;
    }

    @Generated
    public SecretConfigurationService getSecretConfigurationService() {
        return this.secretConfigurationService;
    }

    @Lazy
    @Generated
    public EventStorageService getEventStorageService() {
        return this.eventStorageService;
    }

    @Generated
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Generated
    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    @Generated
    public void setServiceInfoProvider(TbServiceInfoProvider serviceInfoProvider) {
        this.serviceInfoProvider = serviceInfoProvider;
    }

    @Generated
    public void setDeviceStateService(DeviceStateService deviceStateService) {
        this.deviceStateService = deviceStateService;
    }

    @Generated
    public void setPlatformIntegrationService(@Lazy PlatformIntegrationService platformIntegrationService) {
        this.platformIntegrationService = platformIntegrationService;
    }

    @Generated
    public void setIntegrationService(@Lazy IntegrationService integrationService) {
        this.integrationService = integrationService;
    }

    @Generated
    public void setConverterService(@Lazy ConverterService converterService) {
        this.converterService = converterService;
    }

    @Generated
    public void setDeviceService(@Lazy DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    @Generated
    public void setEntityViewService(@Lazy EntityViewService entityViewService) {
        this.entityViewService = entityViewService;
    }

    @Generated
    public void setRelationService(@Lazy RelationService relationService) {
        this.relationService = relationService;
    }

    @Generated
    public void setAttributesService(@Lazy AttributesService attributesService) {
        this.attributesService = attributesService;
    }

    @Generated
    public void setTelemetrySubscriptionService(@Lazy TelemetrySubscriptionService telemetrySubscriptionService) {
        this.telemetrySubscriptionService = telemetrySubscriptionService;
    }

    @Generated
    public void setEventService(@Lazy EventService eventService) {
        this.eventService = eventService;
    }

    @Generated
    public void setDownlinkCacheService(@Lazy DownlinkCacheService downlinkCacheService) {
        this.downlinkCacheService = downlinkCacheService;
    }

    @Generated
    public void setConverterContextComponent(@Lazy ConverterContextComponent converterContextComponent) {
        this.converterContextComponent = converterContextComponent;
    }

    @Generated
    public void setCustomerService(@Lazy CustomerService customerService) {
        this.customerService = customerService;
    }

    @Generated
    public void setAssetService(@Lazy AssetService assetService) {
        this.assetService = assetService;
    }

    @Generated
    public void setEntityGroupService(@Lazy EntityGroupService entityGroupService) {
        this.entityGroupService = entityGroupService;
    }

    @Generated
    public void setLogSettingsComponent(@Lazy LogSettingsComponent logSettingsComponent) {
        this.logSettingsComponent = logSettingsComponent;
    }

    @Generated
    public void setIntegrationStatisticsService(@Lazy IntegrationStatisticsService integrationStatisticsService) {
        this.integrationStatisticsService = integrationStatisticsService;
    }

    @Generated
    public void setRateLimitService(IntegrationRateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    @Generated
    public void setSecretConfigurationService(SecretConfigurationService secretConfigurationService) {
        this.secretConfigurationService = secretConfigurationService;
    }

    @Generated
    public void setEventStorageService(@Lazy EventStorageService eventStorageService) {
        this.eventStorageService = eventStorageService;
    }

    @Generated
    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    @Generated
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Generated
    public void setCallBackExecutorService(ExecutorService callBackExecutorService) {
        this.callBackExecutorService = callBackExecutorService;
    }

    @Generated
    public void setGeneralExecutorService(ExecutorService generalExecutorService) {
        this.generalExecutorService = generalExecutorService;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationContextComponent)) {
            return false;
        }
        IntegrationContextComponent other = (IntegrationContextComponent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isClosed() != other.isClosed()) {
            return false;
        }
        TbServiceInfoProvider this$serviceInfoProvider = this.getServiceInfoProvider();
        TbServiceInfoProvider other$serviceInfoProvider = other.getServiceInfoProvider();
        if (this$serviceInfoProvider == null ? other$serviceInfoProvider != null : !this$serviceInfoProvider.equals(other$serviceInfoProvider)) {
            return false;
        }
        DeviceStateService this$deviceStateService = this.getDeviceStateService();
        DeviceStateService other$deviceStateService = other.getDeviceStateService();
        if (this$deviceStateService == null ? other$deviceStateService != null : !this$deviceStateService.equals(other$deviceStateService)) {
            return false;
        }
        PlatformIntegrationService this$platformIntegrationService = this.getPlatformIntegrationService();
        PlatformIntegrationService other$platformIntegrationService = other.getPlatformIntegrationService();
        if (this$platformIntegrationService == null ? other$platformIntegrationService != null : !this$platformIntegrationService.equals(other$platformIntegrationService)) {
            return false;
        }
        IntegrationService this$integrationService = this.getIntegrationService();
        IntegrationService other$integrationService = other.getIntegrationService();
        if (this$integrationService == null ? other$integrationService != null : !this$integrationService.equals(other$integrationService)) {
            return false;
        }
        ConverterService this$converterService = this.getConverterService();
        ConverterService other$converterService = other.getConverterService();
        if (this$converterService == null ? other$converterService != null : !this$converterService.equals(other$converterService)) {
            return false;
        }
        DeviceService this$deviceService = this.getDeviceService();
        DeviceService other$deviceService = other.getDeviceService();
        if (this$deviceService == null ? other$deviceService != null : !this$deviceService.equals(other$deviceService)) {
            return false;
        }
        EntityViewService this$entityViewService = this.getEntityViewService();
        EntityViewService other$entityViewService = other.getEntityViewService();
        if (this$entityViewService == null ? other$entityViewService != null : !this$entityViewService.equals(other$entityViewService)) {
            return false;
        }
        RelationService this$relationService = this.getRelationService();
        RelationService other$relationService = other.getRelationService();
        if (this$relationService == null ? other$relationService != null : !this$relationService.equals(other$relationService)) {
            return false;
        }
        AttributesService this$attributesService = this.getAttributesService();
        AttributesService other$attributesService = other.getAttributesService();
        if (this$attributesService == null ? other$attributesService != null : !this$attributesService.equals(other$attributesService)) {
            return false;
        }
        TelemetrySubscriptionService this$telemetrySubscriptionService = this.getTelemetrySubscriptionService();
        TelemetrySubscriptionService other$telemetrySubscriptionService = other.getTelemetrySubscriptionService();
        if (this$telemetrySubscriptionService == null ? other$telemetrySubscriptionService != null : !this$telemetrySubscriptionService.equals(other$telemetrySubscriptionService)) {
            return false;
        }
        EventService this$eventService = this.getEventService();
        EventService other$eventService = other.getEventService();
        if (this$eventService == null ? other$eventService != null : !this$eventService.equals(other$eventService)) {
            return false;
        }
        DownlinkCacheService this$downlinkCacheService = this.getDownlinkCacheService();
        DownlinkCacheService other$downlinkCacheService = other.getDownlinkCacheService();
        if (this$downlinkCacheService == null ? other$downlinkCacheService != null : !this$downlinkCacheService.equals(other$downlinkCacheService)) {
            return false;
        }
        ConverterContextComponent this$converterContextComponent = this.getConverterContextComponent();
        ConverterContextComponent other$converterContextComponent = other.getConverterContextComponent();
        if (this$converterContextComponent == null ? other$converterContextComponent != null : !this$converterContextComponent.equals(other$converterContextComponent)) {
            return false;
        }
        CustomerService this$customerService = this.getCustomerService();
        CustomerService other$customerService = other.getCustomerService();
        if (this$customerService == null ? other$customerService != null : !this$customerService.equals(other$customerService)) {
            return false;
        }
        AssetService this$assetService = this.getAssetService();
        AssetService other$assetService = other.getAssetService();
        if (this$assetService == null ? other$assetService != null : !this$assetService.equals(other$assetService)) {
            return false;
        }
        EntityGroupService this$entityGroupService = this.getEntityGroupService();
        EntityGroupService other$entityGroupService = other.getEntityGroupService();
        if (this$entityGroupService == null ? other$entityGroupService != null : !this$entityGroupService.equals(other$entityGroupService)) {
            return false;
        }
        LogSettingsComponent this$logSettingsComponent = this.getLogSettingsComponent();
        LogSettingsComponent other$logSettingsComponent = other.getLogSettingsComponent();
        if (this$logSettingsComponent == null ? other$logSettingsComponent != null : !this$logSettingsComponent.equals(other$logSettingsComponent)) {
            return false;
        }
        IntegrationStatisticsService this$integrationStatisticsService = this.getIntegrationStatisticsService();
        IntegrationStatisticsService other$integrationStatisticsService = other.getIntegrationStatisticsService();
        if (this$integrationStatisticsService == null ? other$integrationStatisticsService != null : !this$integrationStatisticsService.equals(other$integrationStatisticsService)) {
            return false;
        }
        IntegrationRateLimitService this$rateLimitService = this.getRateLimitService();
        IntegrationRateLimitService other$rateLimitService = other.getRateLimitService();
        if (this$rateLimitService == null ? other$rateLimitService != null : !this$rateLimitService.equals(other$rateLimitService)) {
            return false;
        }
        SecretConfigurationService this$secretConfigurationService = this.getSecretConfigurationService();
        SecretConfigurationService other$secretConfigurationService = other.getSecretConfigurationService();
        if (this$secretConfigurationService == null ? other$secretConfigurationService != null : !this$secretConfigurationService.equals(other$secretConfigurationService)) {
            return false;
        }
        EventStorageService this$eventStorageService = this.getEventStorageService();
        EventStorageService other$eventStorageService = other.getEventStorageService();
        if (this$eventStorageService == null ? other$eventStorageService != null : !this$eventStorageService.equals(other$eventStorageService)) {
            return false;
        }
        EventLoopGroup this$eventLoopGroup = this.getEventLoopGroup();
        EventLoopGroup other$eventLoopGroup = other.getEventLoopGroup();
        if (this$eventLoopGroup == null ? other$eventLoopGroup != null : !this$eventLoopGroup.equals(other$eventLoopGroup)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        if (this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService)) {
            return false;
        }
        ExecutorService this$callBackExecutorService = this.getCallBackExecutorService();
        ExecutorService other$callBackExecutorService = other.getCallBackExecutorService();
        if (this$callBackExecutorService == null ? other$callBackExecutorService != null : !this$callBackExecutorService.equals(other$callBackExecutorService)) {
            return false;
        }
        ExecutorService this$generalExecutorService = this.getGeneralExecutorService();
        ExecutorService other$generalExecutorService = other.getGeneralExecutorService();
        return !(this$generalExecutorService == null ? other$generalExecutorService != null : !this$generalExecutorService.equals(other$generalExecutorService));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegrationContextComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isClosed() ? 79 : 97);
        TbServiceInfoProvider $serviceInfoProvider = this.getServiceInfoProvider();
        result = result * 59 + ($serviceInfoProvider == null ? 43 : $serviceInfoProvider.hashCode());
        DeviceStateService $deviceStateService = this.getDeviceStateService();
        result = result * 59 + ($deviceStateService == null ? 43 : $deviceStateService.hashCode());
        PlatformIntegrationService $platformIntegrationService = this.getPlatformIntegrationService();
        result = result * 59 + ($platformIntegrationService == null ? 43 : $platformIntegrationService.hashCode());
        IntegrationService $integrationService = this.getIntegrationService();
        result = result * 59 + ($integrationService == null ? 43 : $integrationService.hashCode());
        ConverterService $converterService = this.getConverterService();
        result = result * 59 + ($converterService == null ? 43 : $converterService.hashCode());
        DeviceService $deviceService = this.getDeviceService();
        result = result * 59 + ($deviceService == null ? 43 : $deviceService.hashCode());
        EntityViewService $entityViewService = this.getEntityViewService();
        result = result * 59 + ($entityViewService == null ? 43 : $entityViewService.hashCode());
        RelationService $relationService = this.getRelationService();
        result = result * 59 + ($relationService == null ? 43 : $relationService.hashCode());
        AttributesService $attributesService = this.getAttributesService();
        result = result * 59 + ($attributesService == null ? 43 : $attributesService.hashCode());
        TelemetrySubscriptionService $telemetrySubscriptionService = this.getTelemetrySubscriptionService();
        result = result * 59 + ($telemetrySubscriptionService == null ? 43 : $telemetrySubscriptionService.hashCode());
        EventService $eventService = this.getEventService();
        result = result * 59 + ($eventService == null ? 43 : $eventService.hashCode());
        DownlinkCacheService $downlinkCacheService = this.getDownlinkCacheService();
        result = result * 59 + ($downlinkCacheService == null ? 43 : $downlinkCacheService.hashCode());
        ConverterContextComponent $converterContextComponent = this.getConverterContextComponent();
        result = result * 59 + ($converterContextComponent == null ? 43 : $converterContextComponent.hashCode());
        CustomerService $customerService = this.getCustomerService();
        result = result * 59 + ($customerService == null ? 43 : $customerService.hashCode());
        AssetService $assetService = this.getAssetService();
        result = result * 59 + ($assetService == null ? 43 : $assetService.hashCode());
        EntityGroupService $entityGroupService = this.getEntityGroupService();
        result = result * 59 + ($entityGroupService == null ? 43 : $entityGroupService.hashCode());
        LogSettingsComponent $logSettingsComponent = this.getLogSettingsComponent();
        result = result * 59 + ($logSettingsComponent == null ? 43 : $logSettingsComponent.hashCode());
        IntegrationStatisticsService $integrationStatisticsService = this.getIntegrationStatisticsService();
        result = result * 59 + ($integrationStatisticsService == null ? 43 : $integrationStatisticsService.hashCode());
        IntegrationRateLimitService $rateLimitService = this.getRateLimitService();
        result = result * 59 + ($rateLimitService == null ? 43 : $rateLimitService.hashCode());
        SecretConfigurationService $secretConfigurationService = this.getSecretConfigurationService();
        result = result * 59 + ($secretConfigurationService == null ? 43 : $secretConfigurationService.hashCode());
        EventStorageService $eventStorageService = this.getEventStorageService();
        result = result * 59 + ($eventStorageService == null ? 43 : $eventStorageService.hashCode());
        EventLoopGroup $eventLoopGroup = this.getEventLoopGroup();
        result = result * 59 + ($eventLoopGroup == null ? 43 : $eventLoopGroup.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        ExecutorService $callBackExecutorService = this.getCallBackExecutorService();
        result = result * 59 + ($callBackExecutorService == null ? 43 : $callBackExecutorService.hashCode());
        ExecutorService $generalExecutorService = this.getGeneralExecutorService();
        result = result * 59 + ($generalExecutorService == null ? 43 : $generalExecutorService.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegrationContextComponent(isClosed=" + this.isClosed() + ", serviceInfoProvider=" + String.valueOf(this.getServiceInfoProvider()) + ", deviceStateService=" + String.valueOf(this.getDeviceStateService()) + ", platformIntegrationService=" + String.valueOf(this.getPlatformIntegrationService()) + ", integrationService=" + String.valueOf(this.getIntegrationService()) + ", converterService=" + String.valueOf(this.getConverterService()) + ", deviceService=" + String.valueOf(this.getDeviceService()) + ", entityViewService=" + String.valueOf(this.getEntityViewService()) + ", relationService=" + String.valueOf(this.getRelationService()) + ", attributesService=" + String.valueOf(this.getAttributesService()) + ", telemetrySubscriptionService=" + String.valueOf(this.getTelemetrySubscriptionService()) + ", eventService=" + String.valueOf(this.getEventService()) + ", downlinkCacheService=" + String.valueOf(this.getDownlinkCacheService()) + ", converterContextComponent=" + String.valueOf(this.getConverterContextComponent()) + ", customerService=" + String.valueOf(this.getCustomerService()) + ", assetService=" + String.valueOf(this.getAssetService()) + ", entityGroupService=" + String.valueOf(this.getEntityGroupService()) + ", logSettingsComponent=" + String.valueOf(this.getLogSettingsComponent()) + ", integrationStatisticsService=" + String.valueOf(this.getIntegrationStatisticsService()) + ", rateLimitService=" + String.valueOf(this.getRateLimitService()) + ", secretConfigurationService=" + String.valueOf(this.getSecretConfigurationService()) + ", eventStorageService=" + String.valueOf(this.getEventStorageService()) + ", eventLoopGroup=" + String.valueOf(this.getEventLoopGroup()) + ", scheduledExecutorService=" + String.valueOf(this.getScheduledExecutorService()) + ", callBackExecutorService=" + String.valueOf(this.getCallBackExecutorService()) + ", generalExecutorService=" + String.valueOf(this.getGeneralExecutorService()) + ")";
    }
}

