/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.dao.customer.CustomerService;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.dao.group.EntityGroupService;
import org.thingsboard.server.service.install.update.EntityGroupAllPaginatedUpdater;

class EdgesGroupAllUpdater
extends EntityGroupAllPaginatedUpdater<EdgeId, Edge> {
    private final EdgeService edgeService;

    public EdgesGroupAllUpdater(EdgeService edgeService, CustomerService customerService, EntityGroupService entityGroupService, EntityGroup groupAll, boolean fetchAllTenantEntities) {
        super(customerService, entityGroupService, groupAll, fetchAllTenantEntities, (arg_0, arg_1) -> ((EdgeService)edgeService).findEdgesByTenantId(arg_0, arg_1), (arg_0, arg_1) -> ((EdgeService)edgeService).findEdgesByTenantIdAndIdsAsync(arg_0, arg_1), entityId -> new EdgeId(entityId.getId()), edge -> edge.getId());
        this.edgeService = edgeService;
    }

    protected void unassignFromCustomer(Edge entity) {
        entity.setCustomerId(new CustomerId(CustomerId.NULL_UUID));
        this.edgeService.saveEdge(entity);
    }

    protected String getName() {
        return "Edges group all updater";
    }
}

