/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.migrate;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.UUIDConverter;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.model.sqlts.dictionary.KeyDictionaryCompositeKey;
import org.thingsboard.server.dao.model.sqlts.dictionary.KeyDictionaryEntry;
import org.thingsboard.server.dao.model.sqlts.latest.TsKvLatestEntity;
import org.thingsboard.server.dao.sqlts.dictionary.KeyDictionaryRepository;
import org.thingsboard.server.dao.sqlts.insert.latest.InsertLatestTsRepository;
import org.thingsboard.server.dao.util.NoSqlTsDao;
import org.thingsboard.server.dao.util.SqlTsLatestDao;
import org.thingsboard.server.service.install.InstallScripts;
import org.thingsboard.server.service.install.migrate.CassandraToSqlColumnData;
import org.thingsboard.server.service.install.migrate.CassandraToSqlTable;
import org.thingsboard.server.service.install.migrate.TsLatestMigrateService;

@Service
@Profile(value={"install"})
@NoSqlTsDao
@SqlTsLatestDao
public class CassandraTsLatestToSqlMigrateService
implements TsLatestMigrateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraTsLatestToSqlMigrateService.class);
    private static final int MAX_KEY_LENGTH = 255;
    private static final int MAX_STR_V_LENGTH = 10000000;
    private static final String SQL_DIR = "sql";
    @Autowired
    private InsertLatestTsRepository insertLatestTsRepository;
    @Autowired
    protected CassandraCluster cluster;
    @Autowired
    protected KeyDictionaryRepository keyDictionaryRepository;
    @Autowired
    private InstallScripts installScripts;
    @Value(value="${spring.datasource.url}")
    protected String dbUrl;
    @Value(value="${spring.datasource.username}")
    protected String dbUserName;
    @Value(value="${spring.datasource.password}")
    protected String dbPassword;
    private final ConcurrentMap<String, Integer> tsKvDictionaryMap = new ConcurrentHashMap();
    protected static final ReentrantLock tsCreationLock = new ReentrantLock();
    private List<CassandraToSqlTable> tables = Arrays.asList(new /* Unavailable Anonymous Inner Class!! */);

    public void migrate() throws Exception {
        log.info("Performing migration of latest timeseries data from cassandra to SQL database ...");
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            Path schemaUpdateFile = Paths.get(this.installScripts.getDataDir(), SQL_DIR, "schema-ts-latest-psql.sql");
            this.loadSql(schemaUpdateFile, conn);
            conn.setAutoCommit(false);
            for (CassandraToSqlTable table : this.tables) {
                table.migrateToSql(this.cluster.getSession(), conn);
            }
        }
        catch (Exception e) {
            log.error("Unexpected error during ThingsBoard entities data migration!", (Throwable)e);
            throw e;
        }
    }

    private TsKvLatestEntity getTsKvLatestEntity(CassandraToSqlColumnData[] data) {
        TsKvLatestEntity latestEntity = new TsKvLatestEntity();
        latestEntity.setEntityId(UUIDConverter.fromString((String)data[0].getValue()));
        latestEntity.setKey(this.getOrSaveKeyId(data[1].getValue()).intValue());
        latestEntity.setTs(Long.valueOf(Long.parseLong(data[2].getValue())));
        String strV = data[4].getValue();
        if (strV != null) {
            if (strV.length() > 10000000) {
                log.warn("[ts_kv_latest] Value size [{}] exceeds maximum size [{}] of column [str_v] and will be truncated!", (Object)strV.length(), (Object)10000000);
                log.warn("Affected data:\n{}", (Object)strV);
                strV = strV.substring(0, 10000000);
            }
            latestEntity.setStrValue(strV);
        } else {
            Long longV = null;
            try {
                longV = Long.parseLong(data[5].getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (longV != null) {
                latestEntity.setLongValue(longV);
            } else {
                Double doubleV = null;
                try {
                    doubleV = Double.parseDouble(data[6].getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (doubleV != null) {
                    latestEntity.setDoubleValue(doubleV);
                } else {
                    String jsonV = data[7].getValue();
                    if (StringUtils.isNoneEmpty((String)jsonV)) {
                        latestEntity.setJsonValue(jsonV);
                    } else {
                        Boolean boolV = null;
                        try {
                            boolV = Boolean.parseBoolean(data[3].getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (boolV != null) {
                            latestEntity.setBooleanValue(boolV);
                        } else {
                            log.warn("All values in key-value row are nullable ");
                        }
                    }
                }
            }
        }
        return latestEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getOrSaveKeyId(String strKey) {
        Integer keyId;
        if (strKey.length() > 255) {
            log.warn("[ts_kv_latest] Value size [{}] exceeds maximum size [{}] of column [key] and will be truncated!", (Object)strKey.length(), (Object)255);
            log.warn("Affected data:\n{}", (Object)strKey);
            strKey = strKey.substring(0, 255);
        }
        if ((keyId = (Integer)this.tsKvDictionaryMap.get(strKey)) == null) {
            Optional tsKvDictionaryOptional = this.keyDictionaryRepository.findById((Object)new KeyDictionaryCompositeKey(strKey));
            if (!tsKvDictionaryOptional.isPresent()) {
                tsCreationLock.lock();
                try {
                    tsKvDictionaryOptional = this.keyDictionaryRepository.findById((Object)new KeyDictionaryCompositeKey(strKey));
                    if (!tsKvDictionaryOptional.isPresent()) {
                        KeyDictionaryEntry keyDictionaryEntry = new KeyDictionaryEntry();
                        keyDictionaryEntry.setKey(strKey);
                        try {
                            KeyDictionaryEntry saved = (KeyDictionaryEntry)this.keyDictionaryRepository.save((Object)keyDictionaryEntry);
                            this.tsKvDictionaryMap.put(saved.getKey(), saved.getKeyId());
                            keyId = saved.getKeyId();
                        }
                        catch (ConstraintViolationException e) {
                            tsKvDictionaryOptional = this.keyDictionaryRepository.findById((Object)new KeyDictionaryCompositeKey(strKey));
                            KeyDictionaryEntry dictionary = (KeyDictionaryEntry)tsKvDictionaryOptional.orElseThrow(() -> new RuntimeException("Failed to get TsKvDictionary entity from DB!"));
                            this.tsKvDictionaryMap.put(dictionary.getKey(), dictionary.getKeyId());
                            keyId = dictionary.getKeyId();
                        }
                    }
                    keyId = ((KeyDictionaryEntry)tsKvDictionaryOptional.get()).getKeyId();
                }
                finally {
                    tsCreationLock.unlock();
                }
            } else {
                keyId = ((KeyDictionaryEntry)tsKvDictionaryOptional.get()).getKeyId();
                this.tsKvDictionaryMap.put(strKey, keyId);
            }
        }
        return keyId;
    }

    private void loadSql(Path sqlFile, Connection conn) throws Exception {
        String sql = new String(Files.readAllBytes(sqlFile), Charset.forName("UTF-8"));
        conn.createStatement().execute(sql);
        Thread.sleep(5000L);
    }
}

