/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.housekeeper.TsHistoryDeletionHousekeeperTask;
import org.thingsboard.server.common.data.kv.BaseDeleteTsKvQuery;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class TsHistoryDeletionTaskProcessor
extends HousekeeperTaskProcessor<TsHistoryDeletionHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsHistoryDeletionTaskProcessor.class);
    private final TimeseriesService timeseriesService;

    public void process(TsHistoryDeletionHousekeeperTask task) throws Exception {
        BaseDeleteTsKvQuery deleteQuery = new BaseDeleteTsKvQuery(task.getKey(), 0L, System.currentTimeMillis(), false, false);
        this.wait((Future)this.timeseriesService.remove(task.getTenantId(), task.getEntityId(), List.of(deleteQuery)));
        log.debug("[{}][{}][{}] Deleted timeseries history for key '{}'", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), task.getKey()});
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_TS_HISTORY;
    }

    @ConstructorProperties(value={"timeseriesService"})
    @Generated
    public TsHistoryDeletionTaskProcessor(TimeseriesService timeseriesService) {
        this.timeseriesService = timeseriesService;
    }
}

