/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.dao.job.JobService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class JobsDeletionTaskProcessor
extends HousekeeperTaskProcessor<HousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobsDeletionTaskProcessor.class);
    private final JobService jobService;

    public void process(HousekeeperTask task) throws Exception {
        int deletedCount = this.jobService.deleteJobsByEntityId(task.getTenantId(), task.getEntityId());
        log.debug("[{}][{}][{}] Deleted {} jobs", new Object[]{task.getTenantId(), task.getEntityId().getEntityType(), task.getEntityId(), deletedCount});
    }

    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.DELETE_JOBS;
    }

    @ConstructorProperties(value={"jobService"})
    @Generated
    public JobsDeletionTaskProcessor(JobService jobService) {
        this.jobService = jobService;
    }
}

