/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper;

import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.housekeeper.HousekeeperConfig;
import org.thingsboard.server.queue.provider.TbCoreQueueFactory;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.housekeeper.HousekeeperService;

@TbCoreComponent
@Service
public class HousekeeperReprocessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HousekeeperReprocessingService.class);
    private final HousekeeperConfig config;
    private final HousekeeperService housekeeperService;
    private final QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> consumer;
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> producer;
    private final TopicPartitionInfo submitTpi;
    private final ExecutorService consumerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)ThingsBoardThreadFactory.forName((String)"housekeeper-reprocessing-consumer"));

    public HousekeeperReprocessingService(HousekeeperConfig config, @Lazy HousekeeperService housekeeperService, TbCoreQueueFactory queueFactory) {
        this.config = config;
        this.housekeeperService = housekeeperService;
        this.consumer = QueueConsumerManager.builder().name("Housekeeper reprocessing").msgPackProcessor((arg_0, arg_1) -> this.processMsgs(arg_0, arg_1)).pollInterval((long)config.getPollInterval()).consumerCreator(() -> ((TbCoreQueueFactory)queueFactory).createHousekeeperReprocessingMsgConsumer()).consumerExecutor(this.consumerExecutor).build();
        this.producer = queueFactory.createHousekeeperReprocessingMsgProducer();
        this.submitTpi = TopicPartitionInfo.builder().topic(this.producer.getDefaultTopic()).build();
    }

    @AfterStartUp(order=11)
    public void afterStartUp() {
        this.consumer.subscribe();
        this.consumer.launch();
    }

    private void processMsgs(List<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> consumer) throws Exception {
        Thread.sleep(this.config.getTaskReprocessingDelay());
        for (TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg> msg : msgs) {
            log.trace("Reprocessing task: {}", msg);
            try {
                this.housekeeperService.processTask((TransportProtos.ToHousekeeperServiceMsg)msg.getValue());
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                log.error("Unexpected error during message reprocessing [{}]", msg, (Object)e);
                this.submitForReprocessing((TransportProtos.ToHousekeeperServiceMsg)msg.getValue(), e);
            }
        }
        consumer.commit();
    }

    public void submitForReprocessing(TransportProtos.ToHousekeeperServiceMsg msg, Throwable error) {
        TransportProtos.HousekeeperTaskProto task = msg.getTask();
        LinkedHashSet<String> errors = new LinkedHashSet<String>((Collection<String>)task.getErrorsList());
        errors.add(StringUtils.truncate((String)ExceptionUtils.getStackTrace((Throwable)error), (int)1024));
        msg = msg.toBuilder().setTask(task.toBuilder().setAttempt(task.getAttempt() + 1).clearErrors().addAllErrors(errors).build()).build();
        log.trace("Submitting for reprocessing: {}", (Object)msg);
        this.producer.send(this.submitTpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), null);
    }

    @PreDestroy
    private void stop() {
        this.consumer.stop();
        this.consumerExecutor.shutdownNow();
        log.info("Stopped Housekeeper reprocessing service");
    }
}

