/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.integration;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapper;
import org.thingsboard.integration.api.converter.wrapper.ConverterUnwrapperFactory;
import org.thingsboard.server.common.data.ConvertersInfo;
import org.thingsboard.server.common.data.IntegrationConvertersInfo;
import org.thingsboard.server.common.data.LibraryConvertersInfo;
import org.thingsboard.server.common.data.converter.ConverterType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.integration.IntegrationInfo;
import org.thingsboard.server.common.data.integration.IntegrationType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.converter.ConverterService;
import org.thingsboard.server.dao.integration.IntegrationService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.converter.ConverterLibraryService;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.integration.TbIntegrationService;

@Service
@TbCoreComponent
public class DefaultTbIntegrationService
extends AbstractTbEntityService
implements TbIntegrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbIntegrationService.class);
    private final IntegrationService integrationService;
    private final ConverterLibraryService converterLibraryService;
    private final ConverterService converterService;

    public PageData<IntegrationInfo> findTenantIntegrationInfos(TenantId tenantId, PageLink pageLink, boolean isEdgeTemplate) {
        if (isEdgeTemplate) {
            PageData pageData = this.integrationService.findTenantIntegrationInfos(tenantId, pageLink, isEdgeTemplate);
            List integrationInfos = pageData.getData();
            integrationInfos.forEach(integration -> {
                ObjectNode status = JacksonUtil.newObjectNode();
                status.put("success", true);
                integration.setStatus(status);
            });
            return pageData;
        }
        return this.integrationService.findTenantIntegrationInfosWithStats(tenantId, isEdgeTemplate, pageLink);
    }

    public PageData<IntegrationInfo> findIntegrationInfosByTenantIdAndEdgeId(TenantId tenantId, EdgeId edgeId, PageLink pageLink) {
        PageData pageData = this.integrationService.findIntegrationInfosByTenantIdAndEdgeId(tenantId, edgeId, pageLink);
        pageData.getData().forEach(integration -> {
            ObjectNode status = JacksonUtil.newObjectNode();
            status.put("success", true);
            integration.setStatus(status);
        });
        return pageData;
    }

    public Map<IntegrationType, IntegrationConvertersInfo> getIntegrationsConvertersInfo(TenantId tenantId) {
        boolean hasUplink = this.converterService.hasConverterOfType(tenantId, ConverterType.UPLINK);
        boolean hasDownlink = this.converterService.hasConverterOfType(tenantId, ConverterType.DOWNLINK);
        Map libraryConvertersInfo = this.converterLibraryService.getConvertersInfo();
        HashMap<IntegrationType, IntegrationConvertersInfo> result = new HashMap<IntegrationType, IntegrationConvertersInfo>();
        for (IntegrationType integrationType : IntegrationType.values()) {
            String directory = integrationType.getDirectory();
            LibraryConvertersInfo libraryInfo = libraryConvertersInfo.getOrDefault(directory, new LibraryConvertersInfo(false, false));
            Set keys = ConverterUnwrapperFactory.getUnwrapper((IntegrationType)integrationType).map(ConverterUnwrapper::getKeys).orElse(null);
            result.put(integrationType, new IntegrationConvertersInfo(new ConvertersInfo(libraryInfo.uplink(), hasUplink, keys), new ConvertersInfo(libraryInfo.downlink(), hasDownlink, null)));
        }
        return result;
    }

    @ConstructorProperties(value={"integrationService", "converterLibraryService", "converterService"})
    @Generated
    public DefaultTbIntegrationService(IntegrationService integrationService, ConverterLibraryService converterLibraryService, ConverterService converterService) {
        this.integrationService = integrationService;
        this.converterLibraryService = converterLibraryService;
        this.converterService = converterService;
    }
}

