/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.edge;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.group.EntityGroup;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.dao.rule.RuleChainService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.edge.TbEdgeService;

@TbCoreComponent
@Service
public class DefaultTbEdgeService
extends AbstractTbEntityService
implements TbEdgeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbEdgeService.class);
    private final RuleChainService ruleChainService;

    public Edge save(Edge edge, RuleChain edgeTemplateRootRuleChain, EntityGroup entityGroup, User user) throws Exception {
        return this.save(edge, edgeTemplateRootRuleChain, entityGroup != null ? Collections.singletonList(entityGroup) : Collections.emptyList(), user);
    }

    public Edge save(Edge edge, RuleChain edgeTemplateRootRuleChain, List<EntityGroup> entityGroups, User user) throws Exception {
        if (entityGroups == null) {
            entityGroups = Collections.emptyList();
        }
        ActionType actionType = edge.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = edge.getTenantId();
        try {
            Edge edgeById;
            String oldEdgeName = null;
            if (ActionType.UPDATED.equals((Object)actionType) && (edgeById = this.edgeService.findEdgeById(tenantId, edge.getId())) != null) {
                oldEdgeName = edgeById.getName();
            }
            if (ActionType.ADDED.equals((Object)actionType) && edge.getRootRuleChainId() == null) {
                edge.setRootRuleChainId(edgeTemplateRootRuleChain.getId());
            }
            Edge savedEdge = (Edge)this.checkNotNull((Object)this.edgeService.saveEdge(edge));
            EdgeId edgeId = savedEdge.getId();
            if (!entityGroups.isEmpty() && ActionType.ADDED.equals((Object)actionType)) {
                for (EntityGroup entityGroup : entityGroups) {
                    this.entityGroupService.addEntityToEntityGroup(tenantId, entityGroup.getId(), (EntityId)edgeId);
                }
            }
            if (ActionType.ADDED.equals((Object)actionType)) {
                this.ruleChainService.assignRuleChainToEdge(tenantId, edgeTemplateRootRuleChain.getId(), edgeId);
                savedEdge = this.edgeService.setEdgeRootRuleChain(tenantId, savedEdge, edgeTemplateRootRuleChain.getId());
                this.edgeService.assignDefaultRuleChainsToEdge(tenantId, savedEdge.getId());
                this.edgeService.assignTenantAdministratorsAndUsersGroupToEdge(tenantId, savedEdge.getId());
                if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
                    Customer customerById = this.customerService.findCustomerById(tenantId, new CustomerId(edge.getOwnerId().getId()));
                    this.edgeService.assignCustomerAdministratorsAndUsersGroupToEdge(tenantId, savedEdge.getId(), customerById.getId(), customerById.getParentCustomerId());
                }
            }
            if (oldEdgeName != null && !oldEdgeName.equals(savedEdge.getName())) {
                String customerName = null;
                if (EntityType.CUSTOMER.equals((Object)edge.getOwnerId().getEntityType())) {
                    Customer customer = this.customerService.findCustomerById(tenantId, new CustomerId(edge.getOwnerId().getId()));
                    customerName = customer.getName();
                }
                this.edgeService.renameEdgeAllGroups(tenantId, savedEdge, oldEdgeName, customerName, customerName);
            }
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)edgeId, (HasName)savedEdge, savedEdge.getCustomerId(), actionType, user, new Object[0]);
            return savedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), (HasName)edge, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    public void delete(EdgeId edgeId, User user) {
        Edge edge = this.edgeService.findEdgeById(user.getTenantId(), edgeId);
        this.delete(edge, user);
    }

    public void delete(Edge edge, User user) {
        ActionType actionType = ActionType.DELETED;
        EdgeId edgeId = edge.getId();
        TenantId tenantId = edge.getTenantId();
        try {
            this.edgeService.deleteEdge(tenantId, edgeId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)edgeId, (HasName)edge, edge.getCustomerId(), actionType, user, new Object[]{edgeId.toString()});
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), actionType, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    public Edge setEdgeRootRuleChain(Edge edge, RuleChainId ruleChainId, User user) throws Exception {
        TenantId tenantId = edge.getTenantId();
        EdgeId edgeId = edge.getId();
        try {
            Edge updatedEdge = this.edgeService.setEdgeRootRuleChain(tenantId, edge, ruleChainId);
            this.logEntityActionService.logEntityAction(tenantId, (EntityId)edgeId, (HasName)edge, null, ActionType.UPDATED, user, new Object[0]);
            return updatedEdge;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.EDGE), ActionType.UPDATED, user, e, new Object[]{edgeId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"ruleChainService"})
    @Generated
    public DefaultTbEdgeService(RuleChainService ruleChainService) {
        this.ruleChainService = ruleChainService;
    }
}

